/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.links;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class LinkImpl
extends ExtensibleImpl<Link>
implements Link {
    private String operationRef;
    private String operationId;
    private Map<String, Object> parameters = ModelUtils.createMap();
    private Object requestBody;
    private String description;
    private String ref;
    private Server server;

    public static Link createInstance(AnnotationModel annotation, ApiContext context) {
        AnnotationModel serverAnnotation;
        LinkImpl from = new LinkImpl();
        from.setOperationRef((String)annotation.getValue("operationRef", String.class));
        from.setOperationId((String)annotation.getValue("operationId", String.class));
        List parametersAnnotation = (List)annotation.getValue("parameters", List.class);
        if (parametersAnnotation != null) {
            for (AnnotationModel parameterAnnotation : parametersAnnotation) {
                from.addParameter((String)parameterAnnotation.getValue("name", String.class), parameterAnnotation.getValue("expression", String.class));
            }
        }
        from.setRequestBody(annotation.getValue("requestBody", String.class));
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setExtensions(LinkImpl.parseExtensions(annotation));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        if ((serverAnnotation = (AnnotationModel)annotation.getValue("server", AnnotationModel.class)) != null) {
            from.setServer(ServerImpl.createInstance(serverAnnotation, context));
        }
        return from;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getOperationRef() {
        return this.operationRef;
    }

    public void setOperationRef(String operationRef) {
        this.operationRef = operationRef;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public Map<String, Object> getParameters() {
        return ModelUtils.readOnlyView(this.parameters);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = ModelUtils.createMap(parameters);
    }

    public Link addParameter(String name, Object parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = ModelUtils.createMap();
            }
            this.parameters.put(name, parameter);
        }
        return this;
    }

    public void removeParameter(String name) {
        if (this.parameters != null) {
            this.parameters.remove(name);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !((String)ref).contains(".") && !((String)ref).contains("/")) {
            ref = "#/components/links/" + (String)ref;
        }
        this.ref = ref;
    }

    public static void merge(Link from, Link to, boolean override) {
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setExtensions(ModelUtils.mergeProperty(to.getExtensions(), from.getExtensions(), override));
        to.setOperationId(ModelUtils.mergeProperty(to.getOperationId(), from.getOperationId(), override));
        to.setOperationRef(ModelUtils.mergeProperty(to.getOperationRef(), from.getOperationRef(), override));
        to.setRequestBody(ModelUtils.mergeProperty(to.getRequestBody(), from.getRequestBody(), override));
        for (String parameterName : from.getParameters().keySet()) {
            LinkImpl.applyLinkParameter(parameterName, from.getParameters().get(parameterName), to.getParameters(), (arg_0, arg_1) -> ((Link)to).addParameter(arg_0, arg_1));
        }
    }

    public static void merge(String linkName, Link link, Map<String, Link> links, boolean override) {
        if (link == null) {
            return;
        }
        if (linkName == null || linkName.isEmpty()) {
            linkName = "?";
        }
        Link model = links.getOrDefault(linkName, new LinkImpl());
        links.put(linkName, model);
        LinkImpl.merge(link, model, override);
        if (model.getRef() != null) {
            links.remove(linkName);
            links.put(model.getRef().split("/")[3], model);
        }
    }

    private static void applyLinkParameter(String parameterName, Object parameter, Map<String, Object> linkParameters, BiConsumer<String, Object> addParameter) {
        if (parameterName == null || parameterName.isEmpty()) {
            parameterName = "?";
        }
        Object model = linkParameters.get(parameterName);
        model = ModelUtils.mergeProperty(model, parameter, true);
        addParameter.accept(parameterName, model);
    }
}

