/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.spi.AutoDiscoverable;

public class AdminJerseyServiceIteratorProvider
extends ServiceFinder.ServiceIteratorProvider {
    private static final Map<String, String[]> services = new HashMap<String, String[]>();
    private static final ThreadLocal<Boolean> applyDefinedValues;
    private static final ServiceFinder.ServiceIteratorProvider defaultProvider;

    public AdminJerseyServiceIteratorProvider() {
        applyDefinedValues.set(Boolean.TRUE);
    }

    public void disable() {
        applyDefinedValues.remove();
    }

    private String[] getServiceNames(Class service, String serviceName) {
        if (serviceName == null) {
            return services.get(service.getName());
        }
        return services.get(serviceName);
    }

    public <T> Iterator<Class<T>> createClassIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
        String[] values = this.getServiceNames(service, serviceName);
        if (!applyDefinedValues.get().booleanValue() || values == null) {
            return defaultProvider.createClassIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }
        return new ClassIterator<Class<T>>(services.get(serviceName), loader, ignoreOnClassNotFound);
    }

    public <T> Iterator<T> createIterator(final Class<T> service, final String serviceName, final ClassLoader loader, final boolean ignoreOnClassNotFound) {
        String[] values = this.getServiceNames(service, serviceName);
        if (!applyDefinedValues.get().booleanValue() || values == null) {
            return defaultProvider.createIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }
        return new Iterator<T>(){
            Iterator<Class<T>> delegate;
            {
                this.delegate = AdminJerseyServiceIteratorProvider.this.createClassIterator(service, serviceName, loader, ignoreOnClassNotFound);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public T next() {
                try {
                    return this.delegate.next().newInstance();
                }
                catch (Exception ex) {
                    throw new ServiceConfigurationError(ex.getLocalizedMessage(), ex);
                }
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        };
    }

    static {
        services.put(AutoDiscoverable.class.getName(), new String[]{"org.glassfish.jersey.server.filter.internal.ServerFiltersAutoDiscoverable"});
        applyDefinedValues = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        defaultProvider = new ServiceFinder.DefaultServiceIteratorProvider();
    }

    public static class ClassIterator<T extends Class>
    implements Iterator<T> {
        private final String[] names;
        private final ClassLoader classLoader;
        private final boolean ignoreOnClassNotFound;
        private int index = -1;
        private String clazzName;
        private T clazz;

        private ClassIterator(String[] names, ClassLoader classLoader, boolean ignoreOnClassNotFound) {
            this.names = names;
            this.classLoader = classLoader;
            this.ignoreOnClassNotFound = ignoreOnClassNotFound;
        }

        @Override
        public boolean hasNext() {
            if (this.clazzName != null) {
                return true;
            }
            if (this.names == null) {
                return false;
            }
            while (this.clazzName == null) {
                if (++this.index >= this.names.length) {
                    return false;
                }
                this.clazzName = this.names[this.index];
                if (!this.ignoreOnClassNotFound) continue;
                try {
                    this.clazz = Class.forName(this.clazzName, true, this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    this.clazzName = null;
                }
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                try {
                    if (this.clazz != null) {
                        T t = this.clazz;
                        return t;
                    }
                    Class<?> clazz = Class.forName(this.clazzName, true, this.classLoader);
                    return (T)clazz;
                }
                catch (Exception ex) {
                    throw new ServiceConfigurationError(ex.getLocalizedMessage(), ex);
                }
                finally {
                    this.clazz = null;
                    this.clazzName = null;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

