/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.admin.report.ActionReporter;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Type;
import org.glassfish.admin.rest.provider.ActionReportJson2Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.api.admin.AdminCommandState;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class AdminCommandStateJsonProvider
extends BaseProvider<AdminCommandState> {
    private static final ActionReportJson2Provider actionReportJsonProvider = new ActionReportJson2Provider();

    public AdminCommandStateJsonProvider() {
        super(AdminCommandState.class, MediaType.APPLICATION_JSON_TYPE, new MediaType("application", "x-javascript"));
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    @Override
    public String getContent(AdminCommandState proxy) {
        try {
            return this.processState(proxy).toString();
        }
        catch (JsonException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JsonObject processState(AdminCommandState state) throws JsonException {
        JsonObjectBuilder result = Json.createObjectBuilder();
        result.add("state", state.getState().name());
        result.add("id", state.getId());
        result.add("empty-payload", state.isOutboundPayloadEmpty());
        ActionReporter ar = (ActionReporter)state.getActionReport();
        this.addActionReporter(ar, result);
        return result.build();
    }

    protected void addActionReporter(ActionReporter ar, JsonObjectBuilder json) throws JsonException {
        if (ar != null) {
            json.add("action-report", (JsonValue)actionReportJsonProvider.processReport(ar));
        }
    }
}

