/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.KeystoreManager;
import com.sun.enterprise.admin.servermgmt.domain.DomainBuilder;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileRealmStorageManager;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-domain")
@PerLookup
public final class CreateDomainCommand
extends CLICommand {
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(CreateDomainCommand.class);
    private static final String ADMIN_PORT = "adminport";
    private static final String ADMIN_PASSWORD = "password";
    private static final String MASTER_PASSWORD = "masterpassword";
    private static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SAVE_MASTER_PASSWORD = "savemasterpassword";
    private static final String INSTANCE_PORT = "instanceport";
    private static final String DOMAIN_PROPERTIES = "domainproperties";
    private static final String PORTBASE_OPTION = "portbase";
    private static final String HAZELCAST_DAS_PORT = "hazelcastdasport";
    private static final String HAZELCAST_START_PORT = "hazelcaststartport";
    private static final String HAZELCAST_AUTO_INCREMENT = "hazelcastautoincrement";
    @Param(name="adminport", optional=true)
    private String adminPort;
    @Param(name="portbase", optional=true)
    private String portBase;
    @Param(obsolete=true, name="profile", optional=true)
    private String profile;
    @Param(name="template", optional=true)
    private String template;
    @Param(name="domaindir", optional=true)
    private String domainDir;
    @Param(name="instanceport", optional=true)
    private String instancePort;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    private boolean saveMasterPassword = false;
    @Param(name="usemasterpassword", optional=true, defaultValue="false")
    private boolean useMasterPassword = false;
    @Param(name="domainproperties", optional=true, separator=58)
    private Properties domainProperties;
    @Param(name="keytooloptions", optional=true)
    private String keytoolOptions;
    @Param(name="savelogin", optional=true, defaultValue="false")
    private boolean saveLoginOpt = false;
    @Param(name="nopassword", optional=true, defaultValue="false")
    private boolean noPassword = false;
    @Param(name="password", optional=true, password=true)
    private String adminPassword = null;
    @Param(name="masterpassword", optional=true, password=true)
    private String masterPassword = null;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts = true;
    @Param(name="hazelcastdasport", optional=true)
    private String hazelcastDasPort;
    @Param(name="hazelcaststartport", optional=true)
    private String hazelcastStartPort;
    @Param(name="hazelcastautoincrement", optional=true)
    private String hazelcastAutoIncrement;
    @Param(name="domain_name", primary=true)
    private String domainName;
    private String adminUser;

    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        CommandModelData.ParamModelData adminPort = new CommandModelData.ParamModelData(ADMIN_PORT, String.class, true, Integer.toString(4848));
        CommandModelData.ParamModelData instancePort = new CommandModelData.ParamModelData(INSTANCE_PORT, String.class, true, Integer.toString(8080));
        CommandModelData.ParamModelData hazelcastDasPort = new CommandModelData.ParamModelData(HAZELCAST_DAS_PORT, String.class, true, Integer.toString(4900));
        CommandModelData.ParamModelData hazelcastStartPort = new CommandModelData.ParamModelData(HAZELCAST_START_PORT, String.class, true, Integer.toString(5900));
        block12: for (CommandModel.ParamModel paramModel : opts) {
            switch (paramModel.getName()) {
                case "adminport": {
                    uopts.add((CommandModel.ParamModel)adminPort);
                    continue block12;
                }
                case "instanceport": {
                    uopts.add((CommandModel.ParamModel)instancePort);
                    continue block12;
                }
                case "hazelcastdasport": {
                    uopts.add((CommandModel.ParamModel)hazelcastDasPort);
                    continue block12;
                }
                case "hazelcaststartport": {
                    uopts.add((CommandModel.ParamModel)hazelcastStartPort);
                }
            }
            uopts.add(paramModel);
        }
        return uopts;
    }

    protected void validate() throws CommandException, CommandValidationException {
        block13: {
            if (this.domainDir == null) {
                this.domainDir = this.getSystemProperty("com.sun.aas.domainsRoot");
            }
            if (this.domainDir == null) {
                throw new CommandValidationException(STRINGS.get("InvalidDomainPath", new Object[]{this.domainDir}));
            }
            if (this.programOpts.getUser() == null && !this.noPassword) {
                try {
                    this.buildTerminal();
                    this.buildLineReader();
                    if (this.lineReader != null && this.programOpts.isInteractive()) {
                        String val = this.lineReader.readLine(STRINGS.get("AdminUserRequiredPrompt", new Object[]{"admin"}));
                        if (CreateDomainCommand.ok((String)val)) {
                            this.programOpts.setUser(val);
                            if (this.adminPassword == null) {
                                char[] pwdArr = this.getAdminPassword();
                                this.adminPassword = pwdArr != null ? new String(pwdArr) : null;
                            }
                        }
                        break block13;
                    }
                    throw new CommandValidationException(STRINGS.get("AdminUserRequired"));
                }
                catch (EndOfFileException | UserInterruptException val) {
                }
                finally {
                    this.closeTerminal();
                }
            }
        }
        if (this.programOpts.getUser() != null) {
            try {
                FileRealmStorageManager.validateUserName((String)this.programOpts.getUser());
            }
            catch (IllegalArgumentException ise) {
                throw new CommandValidationException(STRINGS.get("InvalidUserName", new Object[]{this.programOpts.getUser()}));
            }
        }
    }

    public void verifyPortBase() throws CommandValidationException {
        if (this.usePortBase()) {
            this.setOptionsWithPortBase(this.convertPortStr(this.portBase));
        }
    }

    private void setOptionsWithPortBase(int portbase) throws CommandValidationException {
        this.verifyPortBasePortIsValid(ADMIN_PORT, portbase + 48);
        this.adminPort = String.valueOf(portbase + 48);
        this.verifyPortBasePortIsValid(INSTANCE_PORT, portbase + 80);
        this.instancePort = String.valueOf(portbase + 80);
        this.domainProperties = new Properties();
        this.verifyPortBasePortIsValid("http.ssl.port", portbase + 81);
        this.domainProperties.put("http.ssl.port", String.valueOf(portbase + 81));
        this.verifyPortBasePortIsValid("orb.ssl.port", portbase + 38);
        this.domainProperties.put("orb.ssl.port", String.valueOf(portbase + 38));
        this.verifyPortBasePortIsValid("orb.mutualauth.port", portbase + 39);
        this.domainProperties.put("orb.mutualauth.port", String.valueOf(portbase + 39));
        this.verifyPortBasePortIsValid("jms.port", portbase + 76);
        this.domainProperties.put("jms.port", String.valueOf(portbase + 76));
        this.verifyPortBasePortIsValid("orb.listener.port", portbase + 37);
        this.domainProperties.put("orb.listener.port", String.valueOf(portbase + 37));
        this.verifyPortBasePortIsValid("domain.jmxPort", portbase + 86);
        this.domainProperties.put("domain.jmxPort", String.valueOf(portbase + 86));
        this.verifyPortBasePortIsValid("osgi.shell.telnet.port", portbase + 66);
        this.domainProperties.put("osgi.shell.telnet.port", String.valueOf(portbase + 66));
        this.verifyPortBasePortIsValid("java.debugger.port", portbase + 9);
        this.domainProperties.put("java.debugger.port", String.valueOf(portbase + 9));
        this.verifyPortBasePortIsValid(HAZELCAST_DAS_PORT, portbase + 49);
        this.hazelcastDasPort = String.valueOf(portbase + 49);
        this.verifyPortBasePortIsValid(HAZELCAST_START_PORT, portbase + 59);
        this.hazelcastStartPort = String.valueOf(portbase + 59);
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            PEDomainsManager manager = new PEDomainsManager();
            DomainConfig config = new DomainConfig(this.domainName, this.domainDir);
            manager.validateDomain(config, false);
            this.verifyPortBase();
        }
        catch (DomainException e) {
            throw new CommandException(STRINGS.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        this.adminUser = this.programOpts.getUser();
        if (!CreateDomainCommand.ok((String)this.adminUser)) {
            this.adminUser = "admin";
            this.adminPassword = "";
        } else if (this.noPassword) {
            this.adminPassword = "";
        } else {
            char[] pwdArr = this.getAdminPassword();
            String string = this.adminPassword = pwdArr != null ? new String(pwdArr) : null;
        }
        if (this.saveMasterPassword) {
            this.useMasterPassword = true;
        }
        if (this.masterPassword == null) {
            char[] mpArr;
            this.masterPassword = this.useMasterPassword ? ((mpArr = this.getMasterPassword()) != null ? new String(mpArr) : null) : DEFAULT_MASTER_PASSWORD;
        }
        try {
            if (this.adminPort != null) {
                this.verifyPortIsValid(this.adminPort);
            }
            if (this.hazelcastDasPort != null) {
                this.verifyPortIsValid(this.hazelcastDasPort);
            }
            if (this.hazelcastStartPort != null) {
                this.verifyPortIsValid(this.hazelcastStartPort);
            }
            if (this.instancePort != null) {
                this.verifyPortIsValid(this.instancePort);
            }
            this.createTheDomain(this.domainDir, this.domainProperties);
        }
        catch (Exception e) {
            throw new CommandException(STRINGS.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        return 0;
    }

    private char[] getAdminPassword() throws CommandValidationException {
        CommandModelData.ParamModelData paramModelData = new CommandModelData.ParamModelData(ADMIN_PASSWORD, String.class, false, null);
        paramModelData.prompt = STRINGS.get("AdminPassword");
        paramModelData.promptAgain = STRINGS.get("AdminPasswordAgain");
        paramModelData.param._password = true;
        return this.getPassword((CommandModel.ParamModel)paramModelData, "", true);
    }

    private char[] getMasterPassword() throws CommandValidationException {
        CommandModelData.ParamModelData paramModelData = new CommandModelData.ParamModelData(MASTER_PASSWORD, String.class, false, null);
        paramModelData.prompt = STRINGS.get("MasterPassword");
        paramModelData.promptAgain = STRINGS.get("MasterPasswordAgain");
        paramModelData.param._password = true;
        return this.getPassword((CommandModel.ParamModel)paramModelData, DEFAULT_MASTER_PASSWORD, true);
    }

    private void verifyPortIsValid(String portNum) throws CommandException, CommandValidationException {
        int portToVerify = this.convertPortStr(portNum);
        if (!NetUtils.isPortValid((int)portToVerify)) {
            throw new CommandException(STRINGS.get("InvalidPortRange", new Object[]{portNum}));
        }
        if (!this.checkPorts) {
            logger.log(Level.FINER, "Port ={0}", portToVerify);
            return;
        }
        switch (NetUtils.checkPort((int)portToVerify)) {
            case illegalNumber: {
                throw new CommandException(STRINGS.get("InvalidPortRange", new Object[]{portNum}));
            }
            case inUse: {
                throw new CommandException(STRINGS.get("PortInUseError", new Object[]{this.domainName, portNum}));
            }
            case noPermission: {
                throw new CommandException(STRINGS.get("NoPermissionForPortError", new Object[]{portNum, this.domainName}));
            }
            case unknown: {
                throw new CommandException(STRINGS.get("UnknownPortMsg", new Object[]{portNum}));
            }
            case OK: {
                logger.log(Level.FINER, "Port ={0}", portToVerify);
                break;
            }
        }
    }

    private int convertPortStr(String port) throws CommandValidationException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException(STRINGS.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws CommandValidationException {
        if (portNum <= 0 || portNum > 65535) {
            throw new CommandValidationException(STRINGS.get("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new CommandValidationException(STRINGS.get("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        logger.log(Level.FINER, "Port ={0}", portNum);
    }

    private void createTheDomain(String domainPath, Properties domainProperties) throws DomainException, CommandValidationException {
        String domainFilePath = domainPath + File.separator + this.domainName;
        if (FileUtils.safeGetCanonicalFile((File)new File(domainFilePath)).exists()) {
            throw new CommandValidationException(STRINGS.get("DomainExists", new Object[]{this.domainName}));
        }
        DomainConfig domainConfig = null;
        if (this.template == null || this.template.endsWith(".jar")) {
            domainConfig = new DomainConfig(this.domainName, domainPath, this.adminUser, this.adminPassword, this.masterPassword, this.saveMasterPassword, this.adminPort, this.instancePort, this.hazelcastDasPort, this.hazelcastStartPort, this.hazelcastAutoIncrement, domainProperties);
            domainConfig.put("domain.validatePorts", this.checkPorts);
            domainConfig.put("keytooloptions", this.keytoolOptions);
            domainConfig.put("template.name", this.template);
            domainConfig.put(PORTBASE_OPTION, this.portBase);
            domainConfig.put("domain.admin.groups", Version.getInitialAdminGroups());
            this.initSecureAdminSettings(domainConfig);
            try {
                DomainBuilder domainBuilder = new DomainBuilder(domainConfig);
                domainBuilder.validateTemplate();
                domainBuilder.run();
            }
            catch (Exception e) {
                throw new DomainException(e.getMessage(), e);
            }
        } else {
            throw new DomainException(STRINGS.get("InvalidTemplateValue", new Object[]{this.template}));
        }
        logger.info(STRINGS.get("DomainCreated", new Object[]{this.domainName}));
        Integer aPort = (Integer)domainConfig.get("domain.adminPort");
        logger.info(STRINGS.get("DomainPort", new Object[]{this.domainName, Integer.toString(aPort)}));
        if (this.adminPassword != null && this.adminPassword.equals("")) {
            logger.info(STRINGS.get("DomainAllowsUnauth", new Object[]{this.domainName, this.adminUser}));
        } else {
            logger.info(STRINGS.get("DomainAdminUser", new Object[]{this.domainName, this.adminUser}));
        }
        if (this.saveLoginOpt) {
            this.saveLogin(aPort, this.adminUser, this.adminPassword != null ? this.adminPassword.toCharArray() : null, this.domainName);
        }
    }

    private void saveLogin(int port, String user, char[] password, String dn) {
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            LoginInfo login = new LoginInfo("localhost", port, user, password);
            if (store.exists(login.getHost(), login.getPort())) {
                logger.info(STRINGS.get("OverwriteLoginMsgCreateDomain", new Object[]{login.getHost(), "" + login.getPort()}));
            }
            store.store(login, true);
            logger.info(STRINGS.get("LoginInfoStoredCreateDomain", new Object[]{user, dn, store.getName()}));
        }
        catch (Throwable e) {
            logger.warning(STRINGS.get("LoginInfoNotStoredCreateDomain", new Object[]{user, dn}));
            this.printExceptionStackTrace(e);
        }
    }

    private boolean usePortBase() throws CommandValidationException {
        if (this.portBase == null) {
            return false;
        }
        if (this.adminPort != null) {
            throw new CommandValidationException(STRINGS.get("MutuallyExclusiveOption", new Object[]{ADMIN_PORT, PORTBASE_OPTION}));
        }
        if (this.instancePort != null) {
            throw new CommandValidationException(STRINGS.get("MutuallyExclusiveOption", new Object[]{INSTANCE_PORT, PORTBASE_OPTION}));
        }
        if (this.domainProperties != null) {
            throw new CommandValidationException(STRINGS.get("MutuallyExclusiveOption", new Object[]{DOMAIN_PROPERTIES, PORTBASE_OPTION}));
        }
        return true;
    }

    private void initSecureAdminSettings(DomainConfig config) {
        config.put("domain.admin.cert.dn", KeystoreManager.getDASCertDN(config));
        config.put("domain.instance.cert.dn", KeystoreManager.getInstanceCertDN(config));
        config.put("domain.indicator", this.secureAdminIdentifier());
    }

    private String secureAdminIdentifier() {
        return UUID.randomUUID().toString();
    }
}

