/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.MasterPasswordFileManager;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import org.glassfish.security.common.FileRealmStorageManager;

public class DomainSecurity
extends MasterPasswordFileManager {
    private static final StringManager STRING_MANAGER = StringManager.getManager(DomainSecurity.class);

    void processAdminKeyFile(File keyFile, String user, String password, String[] adminUserGroups) throws IOException {
        FileRealmStorageManager fileStorageManager = new FileRealmStorageManager(keyFile.getAbsolutePath());
        fileStorageManager.addUser(user, password.toCharArray(), adminUserGroups);
        fileStorageManager.persist();
    }

    void createPasswordAliasKeystore(File passwordFile, String password) throws RepositoryException {
        try {
            new PasswordAdapter(passwordFile.getAbsolutePath(), password.toCharArray()).writeStore();
        }
        catch (Exception ex) {
            throw new RepositoryException(STRING_MANAGER.getString("passwordAliasKeystoreNotCreated", (Object)passwordFile), ex);
        }
    }

    void createSSLCertificateDatabase(File configDir, DomainConfig config, String masterPassword) throws RepositoryException {
        File trustStore = new File(configDir, "cacerts.p12");
        File keyStore = new File(configDir, "keystore.p12");
        this.createKeyStore(keyStore, config, masterPassword);
        this.changeKeyStorePassword("changeit", masterPassword, trustStore);
        this.copyCertificates(keyStore, trustStore, config, masterPassword);
        this.updateCertificates(trustStore, masterPassword);
    }

    void changeMode(String args, File file) throws IOException {
        super.chmod(args, file);
    }
}

