/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.cli.ListDomainsCommand;
import com.sun.enterprise.admin.servermgmt.cli.StopDomainCommand;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-all-domains")
@PerLookup
public class StopAllDomainsCommand
extends StopDomainCommand {
    @Param(name="force", optional=true, defaultValue="true")
    Boolean force;
    @Param(optional=true, defaultValue="false")
    Boolean kill;
    @Param(optional=true, defaultValue="600")
    private int timeout;
    @Param(optional=true, defaultValue="60")
    private int domainTimeout;
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListDomainsCommand.class);

    protected void prevalidate() throws CommandException {
        if (this.operands != null && this.operands.size() > 0) {
            throw new CommandException(strings.get("StopAllDomains.tooManyOperands"));
        }
        super.prevalidate();
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.timeout < 1 || this.domainTimeout < 1) {
            throw new CommandValidationException("Timeout must be at least 1 second long.");
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        Future<Integer> future = executorService.submit(() -> {
            MultiException allExceptions = new MultiException();
            try {
                String[] domainsList;
                for (String domain : domainsList = this.getDomains()) {
                    this.setConfig(domain);
                    ParameterMap parameterMap = new ParameterMap();
                    parameterMap.insert("timeout", String.valueOf(this.domainTimeout));
                    this.programOpts.updateOptions(parameterMap);
                    RemoteCLICommand cmd = new RemoteCLICommand("stop-domain", this.programOpts, this.env);
                    cmd.setReadTimeout(this.domainTimeout * 1000);
                    logger.log(Level.FINE, "Stopping domain {0}", domain);
                    try {
                        cmd.executeAndReturnOutput(new String[]{"stop-domain", "--force", this.force.toString()});
                    }
                    catch (Exception e) {
                        allExceptions.addError((Throwable)e);
                    }
                    logger.fine("Stopped domain");
                }
                Integer n = 0;
                return n;
            }
            catch (Exception ex) {
                allExceptions.addError((Throwable)ex);
                Integer n = 1;
                return n;
            }
            finally {
                if (!allExceptions.getErrors().isEmpty()) {
                    throw new CommandException(allExceptions.getMessage());
                }
            }
        });
        long startTime = System.currentTimeMillis();
        while (!this.timedOut(startTime)) {
            if (!future.isDone()) continue;
            return 0;
        }
        throw new CommandException("Command Timed Out");
    }

    private String[] getDomains() throws DomainException, IOException {
        PEDomainsManager manager = new PEDomainsManager();
        File domainsDirFile = StopAllDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
        DomainConfig domainConfig = new DomainConfig(null, domainsDirFile.getAbsolutePath());
        String[] domainsList = manager.listDomains(domainConfig);
        if (domainsList.length == 0) {
            logger.fine(strings.get("NoDomainsToList"));
        }
        return domainsList;
    }

    private int setConfig(String domain) throws CommandException {
        this.setDomainName(domain);
        super.initDomain();
        if (this.isLocal()) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.dasNotRunning();
            }
            this.programOpts.setHostAndPort(this.getAdminAddress());
            logger.log(Level.FINER, "Stopping local domain on port {0}", this.programOpts.getPort());
            this.programOpts.setInteractive(false);
            if (!this.isThisDAS(this.getDomainRootDir())) {
                return this.dasNotRunning();
            }
            logger.finer("It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
                return this.dasNotRunning();
            }
            logger.finer("DAS is running");
            this.programOpts.setInteractive(false);
        }
        return 0;
    }

    @Override
    protected int dasNotRunning() throws CommandException {
        if (this.kill.booleanValue() && this.isLocal()) {
            return this.kill();
        }
        return 0;
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > (long)(this.timeout * 1000);
    }
}

