/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RoleReference;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContextException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.security.common.Role;

public class JaccEJBConstraintsTranslator {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.core.security");

    private JaccEJBConstraintsTranslator() {
    }

    public static void translateConstraintsToPermissions(EjbDescriptor ejbDescriptor, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        JaccEJBConstraintsTranslator.createEJBMethodPermissions(ejbDescriptor, policyConfiguration);
        JaccEJBConstraintsTranslator.createEJBRoleRefPermissions(ejbDescriptor, policyConfiguration);
    }

    private static void createEJBMethodPermissions(EjbDescriptor ejbDescriptor, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        String ejbName = ejbDescriptor.getName();
        Permissions uncheckedPermissions = null;
        Permissions excludedPermissions = null;
        Map<String, Permissions> perRolePermissions = null;
        Map methodPermissions = ejbDescriptor.getMethodPermissionsFromDD();
        if (methodPermissions != null) {
            for (Map.Entry permissionEntry : methodPermissions.entrySet()) {
                MethodPermission methodPermission = (MethodPermission)permissionEntry.getKey();
                for (MethodDescriptor methodDescriptor : (List)permissionEntry.getValue()) {
                    String methodName = methodDescriptor.getName().equals("*") ? null : methodDescriptor.getName();
                    String methodInterface = methodDescriptor.getEjbClassSymbol();
                    String[] methodParams = methodDescriptor.getStyle() == 3 ? methodDescriptor.getParameterClassNames() : null;
                    EJBMethodPermission ejbMethodPermission = new EJBMethodPermission(ejbName, methodName, methodInterface, methodParams);
                    perRolePermissions = JaccEJBConstraintsTranslator.addToRolePermissions(perRolePermissions, methodPermission, ejbMethodPermission);
                    uncheckedPermissions = JaccEJBConstraintsTranslator.addToUncheckedPermissions(uncheckedPermissions, methodPermission, ejbMethodPermission);
                    excludedPermissions = JaccEJBConstraintsTranslator.addToExcludedPermissions(excludedPermissions, methodPermission, ejbMethodPermission);
                }
            }
        }
        for (MethodDescriptor methodDescriptor : ejbDescriptor.getMethodDescriptors()) {
            Method method = methodDescriptor.getMethod(ejbDescriptor);
            if (method == null) continue;
            String methodInterface = methodDescriptor.getEjbClassSymbol();
            if (methodInterface == null || methodInterface.equals("")) {
                _logger.log(Level.SEVERE, "method_descriptor_not_defined", new Object[]{ejbName, methodDescriptor.getName(), methodDescriptor.getParameterClassNames()});
                continue;
            }
            EJBMethodPermission ejbMethodPermission = new EJBMethodPermission(ejbName, methodInterface, method);
            for (MethodPermission methodPermission : ejbDescriptor.getMethodPermissionsFor(methodDescriptor)) {
                perRolePermissions = JaccEJBConstraintsTranslator.addToRolePermissions(perRolePermissions, methodPermission, ejbMethodPermission);
                uncheckedPermissions = JaccEJBConstraintsTranslator.addToUncheckedPermissions(uncheckedPermissions, methodPermission, ejbMethodPermission);
                excludedPermissions = JaccEJBConstraintsTranslator.addToExcludedPermissions(excludedPermissions, methodPermission, ejbMethodPermission);
            }
        }
        if (uncheckedPermissions != null) {
            policyConfiguration.addToUncheckedPolicy(uncheckedPermissions);
        }
        if (excludedPermissions != null) {
            policyConfiguration.addToExcludedPolicy(excludedPermissions);
        }
        if (perRolePermissions != null) {
            for (Map.Entry entry : perRolePermissions.entrySet()) {
                policyConfiguration.addToRole((String)entry.getKey(), (PermissionCollection)entry.getValue());
            }
        }
    }

    private static void createEJBRoleRefPermissions(EjbDescriptor ejbDescriptor, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        ArrayList<Role> ejbScopedRoleNames = new ArrayList<Role>();
        Set allRoles = ejbDescriptor.getEjbBundleDescriptor().getRoles();
        Role anyAuthUserRole = new Role("**");
        boolean rolesetContainsAnyAuthUserRole = allRoles.contains(anyAuthUserRole);
        String ejbName = ejbDescriptor.getName();
        JaccEJBConstraintsTranslator.writeOutPermissionsForRoleRefRoles(ejbDescriptor.getRoleReferences(), ejbScopedRoleNames, ejbName, policyConfiguration);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JACC: Converting role-ref: Going through the list of roles not present in RoleRef elements and creating EJBRoleRefPermissions ");
        }
        JaccEJBConstraintsTranslator.writeOutPermissionsForNonRoleRefRoles(allRoles, ejbScopedRoleNames, ejbName, policyConfiguration);
        if (!ejbScopedRoleNames.contains(anyAuthUserRole) && !rolesetContainsAnyAuthUserRole) {
            JaccEJBConstraintsTranslator.addAnyAuthenticatedUserRoleRef(policyConfiguration, ejbName);
        }
    }

    private static void writeOutPermissionsForRoleRefRoles(Collection<RoleReference> roleReferences, List<Role> ejbScopedRoleNames, String ejbName, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        for (RoleReference roleReference : roleReferences) {
            String ejbScopedRoleName = roleReference.getRoleName();
            ejbScopedRoleNames.add(new Role(ejbScopedRoleName));
            String globalRoleName = roleReference.getSecurityRoleLink().getName();
            policyConfiguration.addToRole(globalRoleName, (Permission)new EJBRoleRefPermission(ejbName, ejbScopedRoleName));
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JACC: Converting role-ref -> " + roleReference.toString() + " to permission with name(" + ejbName + ") and actions (" + ejbScopedRoleName + ") mapped to role (" + globalRoleName + ")");
        }
    }

    private static void writeOutPermissionsForNonRoleRefRoles(Collection<Role> allRoles, Collection<Role> ejbScopedRoleNames, String ejbName, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        for (Role role : allRoles) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: Converting role-ref: Looking at Role =  " + role.getName());
            }
            if (ejbScopedRoleNames.contains(role)) continue;
            String roleName = role.getName();
            policyConfiguration.addToRole(roleName, (Permission)new EJBRoleRefPermission(ejbName, roleName));
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JACC: Converting role-ref: Role =  " + role.getName() + " is added as a permission with name(" + ejbName + ") and actions (" + roleName + ") mapped to role (" + roleName + ")");
        }
    }

    private static void addAnyAuthenticatedUserRoleRef(PolicyConfiguration policyConfiguration, String ejbName) throws PolicyContextException {
        String rolename = "**";
        policyConfiguration.addToRole(rolename, (Permission)new EJBRoleRefPermission(ejbName, rolename));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: Converting role-ref: Adding any authenticated user role-ref  to permission with name(" + ejbName + ") and actions (" + rolename + ") mapped to role (" + rolename + ")");
        }
    }

    private static Map<String, Permissions> addToRolePermissions(Map<String, Permissions> perRolePermissions, MethodPermission methodPermission, EJBMethodPermission ejbMethodPermission) {
        if (methodPermission.isRoleBased()) {
            if (perRolePermissions == null) {
                perRolePermissions = new HashMap<String, Permissions>();
            }
            String roleName = methodPermission.getRole().getName();
            perRolePermissions.computeIfAbsent(roleName, e -> new Permissions()).add((Permission)ejbMethodPermission);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbMethodPermission.getName() + " " + ejbMethodPermission.getActions() + ")protected by role -> " + roleName);
            }
        }
        return perRolePermissions;
    }

    private static Permissions addToUncheckedPermissions(Permissions permissions, MethodPermission methodPermission, EJBMethodPermission ejbMethodPermission) {
        if (methodPermission.isUnchecked()) {
            if (permissions == null) {
                permissions = new Permissions();
            }
            permissions.add((Permission)ejbMethodPermission);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbMethodPermission.getName() + " " + ejbMethodPermission.getActions() + ") is (unchecked)");
            }
        }
        return permissions;
    }

    private static Permissions addToExcludedPermissions(Permissions permissions, MethodPermission methodPermission, EJBMethodPermission ejbMethodPermission) {
        if (methodPermission.isExcluded()) {
            if (permissions == null) {
                permissions = new Permissions();
            }
            permissions.add((Permission)ejbMethodPermission);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbMethodPermission.getName() + " " + ejbMethodPermission.getActions() + ") is (excluded)");
            }
        }
        return permissions;
    }
}

