/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jaspic.config;

import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.security.jaspic.AuthMessagePolicy;
import com.sun.enterprise.security.jaspic.WebServicesDelegate;
import com.sun.enterprise.security.jaspic.config.ConfigParser;
import com.sun.logging.LogDomains;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.AuthConfig;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ClientAuthModule;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.internal.api.Globals;

public class GFServerConfigProvider
implements AuthConfigProvider {
    private static final Logger logger = LogDomains.getLogger(GFServerConfigProvider.class, (String)"javax.enterprise.system.core.security");
    public static final String SOAP = "SOAP";
    public static final String HTTPSERVLET = "HttpServlet";
    protected static final String CLIENT = "client";
    protected static final String SERVER = "server";
    protected static final String MANAGES_SESSIONS_OPTION = "managessessions";
    private static final String DEFAULT_PARSER_CLASS = "com.sun.enterprise.security.jaspic.config.ConfigDomainParser";
    private static final ThreadLocal<Subject> subjectLocal = new ThreadLocal();
    protected static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected static final Map<String, String> layerDefaultRegisIDMap = new HashMap<String, String>();
    static int epoch;
    static String parserClassName;
    static ConfigParser parser;
    static boolean parserInitialized;
    static AuthConfigFactory slaveFactory;
    static AuthConfigProvider slaveProvider;
    protected AuthConfigFactory factory;
    private WebServicesDelegate wsdelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFServerConfigProvider(Map properties, AuthConfigFactory factory) {
        this.factory = factory;
        this.initializeParser();
        if (factory != null) {
            boolean hasSlaveFactory = false;
            try {
                rwLock.readLock().lock();
                hasSlaveFactory = slaveFactory != null;
            }
            finally {
                rwLock.readLock().unlock();
            }
            if (!hasSlaveFactory) {
                try {
                    rwLock.writeLock().lock();
                    if (slaveFactory == null) {
                        slaveFactory = factory;
                    }
                }
                finally {
                    rwLock.writeLock().unlock();
                }
            }
        }
        boolean hasSlaveProvider = false;
        try {
            rwLock.readLock().lock();
            hasSlaveProvider = slaveProvider != null;
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (!hasSlaveProvider) {
            try {
                rwLock.writeLock().lock();
                if (slaveProvider == null) {
                    slaveProvider = this;
                }
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
        this.wsdelegate = (WebServicesDelegate)Globals.get(WebServicesDelegate.class);
    }

    private void initializeParser() {
        try {
            rwLock.readLock().lock();
            if (parserInitialized) {
                return;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        try {
            rwLock.writeLock().lock();
            if (!parserInitialized) {
                parserClassName = System.getProperty("config.parser", DEFAULT_PARSER_CLASS);
                GFServerConfigProvider.loadParser(this, this.factory, null);
                parserInitialized = true;
            }
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    static ModuleInfo createModuleInfo(Entry entry, CallbackHandler handler, String type, Map<String, Object> properties) throws AuthException {
        try {
            Object newModule = entry.newInstance();
            Map<String, Object> map = properties;
            Map<String, Object> entryOptions = entry.getOptions();
            if (entryOptions != null) {
                map = map == null ? new HashMap<String, Object>() : new HashMap<String, Object>(map);
                map.putAll(entryOptions);
            }
            if (SERVER.equals(type)) {
                ServerAuthModule sam = (ServerAuthModule)newModule;
                sam.initialize(entry.getRequestPolicy(), entry.getResponsePolicy(), handler, map);
            } else {
                ClientAuthModule cam = (ClientAuthModule)newModule;
                cam.initialize(entry.getRequestPolicy(), entry.getResponsePolicy(), handler, map);
            }
            return new ModuleInfo(newModule, map);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                throw (AuthException)e;
            }
            throw (AuthException)new AuthException().initCause((Throwable)e);
        }
    }

    private static Object createObject(String className) {
        ClassLoader loader = GFServerConfigProvider.getClassLoader();
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(() -> Class.forName(className, true, loader).newInstance());
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
        }
        try {
            return Class.forName(className, true, loader).newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry getEntry(String intercept, String id, MessagePolicy requestPolicy, MessagePolicy responsePolicy, String type) {
        MessagePolicy respP;
        Map<String, InterceptEntry> configMap;
        try {
            rwLock.readLock().lock();
            configMap = parser.getConfigMap();
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (configMap == null) {
            return null;
        }
        InterceptEntry intEntry = configMap.get(intercept);
        if (intEntry == null || intEntry.idMap == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("module config has no IDs configured for [" + intercept + "]");
            }
            return null;
        }
        IDEntry idEntry = null;
        if (id == null || (idEntry = intEntry.idMap.get(id)) == null) {
            String defaultID;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DD did not specify ID, or DD-specified ID for [" + intercept + "] not found in config -- attempting to look for default ID");
            }
            if ((idEntry = intEntry.idMap.get(defaultID = CLIENT.equals(type) ? intEntry.defaultClientID : intEntry.defaultServerID)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("no default config ID for [" + intercept + "]");
                }
                return null;
            }
        }
        if (idEntry.type.indexOf(type) < 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("request type [" + type + "] does not match config type [" + idEntry.type + "]");
            }
            return null;
        }
        MessagePolicy reqP = requestPolicy != null || responsePolicy != null ? requestPolicy : idEntry.requestPolicy;
        MessagePolicy messagePolicy = respP = requestPolicy != null || responsePolicy != null ? responsePolicy : idEntry.responsePolicy;
        if (reqP == null && respP == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("no policy applies");
            }
            return null;
        }
        Entry entry = new Entry(idEntry.moduleClassName, reqP, respP, idEntry.options);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getEntry for: " + intercept + " -- " + id + "\n    module class: " + entry.moduleClassName + "\n    options: " + entry.options + "\n    request policy: " + entry.requestPolicy + "\n    response policy: " + entry.responsePolicy);
        }
        return entry;
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new GFClientAuthConfig(this, layer, appContext, handler);
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new GFServerAuthConfig(this, layer, appContext, handler);
    }

    public void refresh() {
        GFServerConfigProvider.loadParser(this, this.factory, null);
    }

    public static void loadConfigContext(Object config) {
        boolean hasSlaveFactory = false;
        rwLock.readLock().lock();
        try {
            hasSlaveFactory = slaveFactory != null;
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (slaveProvider == null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("unableToLoad.noSlaveProvider");
            }
            return;
        }
        if (!hasSlaveFactory) {
            rwLock.writeLock().lock();
            try {
                if (slaveFactory == null) {
                    slaveFactory = AuthConfigFactory.getFactory();
                }
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
        GFServerConfigProvider.loadParser(slaveProvider, slaveFactory, config);
    }

    protected static void loadParser(AuthConfigProvider aProvider, AuthConfigFactory aFactory, Object config) {
        rwLock.writeLock().lock();
        try {
            int next = epoch + 1;
            ConfigParser nextParser = (ConfigParser)GFServerConfigProvider.createObject(parserClassName);
            nextParser.initialize(config);
            if (aFactory != null && aProvider != null) {
                String regisID;
                Set<String> layerSet = nextParser.getLayersWithDefault();
                for (String layer : layerDefaultRegisIDMap.keySet()) {
                    if (layerSet.contains(layer)) continue;
                    regisID = layerDefaultRegisIDMap.remove(layer);
                    aFactory.removeRegistration(regisID);
                }
                for (String layer : layerSet) {
                    if (layerDefaultRegisIDMap.containsKey(layer)) continue;
                    regisID = aFactory.registerConfigProvider(aProvider, layer, null, "GFServerConfigProvider: self registration");
                    layerDefaultRegisIDMap.put(layer, regisID);
                }
            }
            epoch = next == 0 ? 1 : next;
            parser = nextParser;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    protected static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void setValidateRequestSubject(Subject subject) {
        subjectLocal.set(subject);
    }

    protected static class ModuleInfo {
        private final Object module;
        private final Map<String, Object> map;

        ModuleInfo(Object module, Map<String, Object> map) {
            this.module = module;
            this.map = map;
        }

        <T> T getModule() {
            return (T)this.module;
        }

        Map<String, Object> getMap() {
            return this.map;
        }
    }

    public static class IDEntry {
        private String type;
        private String moduleClassName;
        private MessagePolicy requestPolicy;
        private MessagePolicy responsePolicy;
        private Map<String, Object> options;

        public IDEntry(String type, String moduleClassName, MessagePolicy requestPolicy, MessagePolicy responsePolicy, Map<String, Object> options) {
            this.type = type;
            this.moduleClassName = moduleClassName;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
            this.options = options;
        }

        public String getModuleClassName() {
            return this.moduleClassName;
        }

        public Map<String, Object> getOptions() {
            return this.options;
        }

        public MessagePolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        public MessagePolicy getResponsePolicy() {
            return this.responsePolicy;
        }

        public String getType() {
            return this.type;
        }
    }

    protected static class GFClientAuthContext
    implements ClientAuthContext {
        private final ClientAuthModule module;

        GFClientAuthContext(ClientAuthModule module) {
            this.module = module;
        }

        public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            return this.module.secureRequest(messageInfo, clientSubject);
        }

        public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            return this.module.validateResponse(messageInfo, clientSubject, serviceSubject);
        }

        public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            this.module.cleanSubject(messageInfo, subject);
        }
    }

    protected static class GFServerAuthContext
    implements ServerAuthContext {
        private final ServerAuthModule module;

        GFServerAuthContext(ServerAuthModule module) {
            this.module = module;
        }

        public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            return this.module.validateRequest(messageInfo, clientSubject, serviceSubject);
        }

        public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            return this.module.secureResponse(messageInfo, serviceSubject);
        }

        public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            this.module.cleanSubject(messageInfo, subject);
        }
    }

    class GFClientAuthConfig
    extends GFAuthConfig
    implements ClientAuthConfig {
        protected GFClientAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler) {
            super(provider, layer, appContext, handler, GFServerConfigProvider.CLIENT);
        }

        public ClientAuthContext getAuthContext(String authContextID, Subject clientSubject, Map properties) throws AuthException {
            ModuleInfo moduleInfo = this.getModuleInfo(authContextID, properties);
            if (moduleInfo != null && moduleInfo.getModule() != null) {
                return new GFClientAuthContext((ClientAuthModule)moduleInfo.getModule());
            }
            return null;
        }
    }

    class GFServerAuthConfig
    extends GFAuthConfig
    implements ServerAuthConfig {
        protected GFServerAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler) {
            super(provider, layer, appContext, handler, GFServerConfigProvider.SERVER);
        }

        public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
            ModuleInfo moduleInfo = this.getModuleInfo(authContextID, properties);
            if (moduleInfo != null && moduleInfo.getModule() != null) {
                return new GFServerAuthContext((ServerAuthModule)moduleInfo.getModule());
            }
            return null;
        }
    }

    class GFAuthConfig
    implements AuthConfig {
        protected AuthConfigProvider provider;
        protected String layer;
        protected String appContext;
        protected CallbackHandler handler;
        protected String type;
        protected String providerID;
        protected boolean init;
        protected boolean onePolicy;
        protected MessageSecurityBindingDescriptor binding;
        protected SunWebApp sunWebApp;

        protected GFAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler, String type) {
            this.provider = provider;
            this.layer = layer;
            this.appContext = appContext;
            this.handler = handler != null ? handler : AuthMessagePolicy.getDefaultCallbackHandler();
            this.type = type;
        }

        public String getMessageLayer() {
            return this.layer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getAuthContextID(MessageInfo messageInfo) {
            if (GFServerConfigProvider.HTTPSERVLET.equals(this.layer)) {
                return Boolean.valueOf((String)messageInfo.getMap().get("jakarta.security.auth.message.MessagePolicy.isMandatory")).toString();
            }
            if (GFServerConfigProvider.SOAP.equals(this.layer) && GFServerConfigProvider.this.wsdelegate != null) {
                return GFServerConfigProvider.this.wsdelegate.getAuthContextID(messageInfo);
            }
            return null;
        }

        public void refresh() {
            GFServerConfigProvider.loadParser(this.provider, GFServerConfigProvider.this.factory, null);
        }

        public boolean isProtected() {
            return true;
        }

        CallbackHandler getCallbackHandler() {
            return this.handler;
        }

        protected ModuleInfo getModuleInfo(String authContextID, Map<String, Object> properties) throws AuthException {
            if (!this.init) {
                this.initialize(properties);
            }
            MessagePolicy[] policies = null;
            policies = GFServerConfigProvider.HTTPSERVLET.equals(this.layer) ? AuthMessagePolicy.getHttpServletPolicies(authContextID) : AuthMessagePolicy.getSOAPPolicies(this.binding, authContextID, this.onePolicy);
            MessagePolicy requestPolicy = policies[0];
            MessagePolicy responsePolicy = policies[1];
            Entry entry = GFServerConfigProvider.this.getEntry(this.layer, this.providerID, requestPolicy, responsePolicy, this.type);
            return entry != null ? GFServerConfigProvider.createModuleInfo(entry, this.handler, this.type, properties) : null;
        }

        private void initialize(Map<String, ?> properties) {
            if (!this.init) {
                if (GFServerConfigProvider.HTTPSERVLET.equals(this.layer)) {
                    this.sunWebApp = AuthMessagePolicy.getSunWebApp(properties);
                    this.providerID = AuthMessagePolicy.getProviderID(this.sunWebApp);
                    this.onePolicy = true;
                } else {
                    this.binding = AuthMessagePolicy.getMessageSecurityBinding(this.layer, properties);
                    this.providerID = AuthMessagePolicy.getProviderID(this.binding);
                    this.onePolicy = AuthMessagePolicy.oneSOAPPolicy(this.binding);
                }
                this.init = true;
            }
        }
    }

    public static class InterceptEntry {
        String defaultClientID;
        String defaultServerID;
        Map<String, IDEntry> idMap;

        public InterceptEntry(String defaultClientID, String defaultServerID, Map<String, IDEntry> idMap) {
            this.defaultClientID = defaultClientID;
            this.defaultServerID = defaultServerID;
            this.idMap = idMap;
        }

        public Map<String, IDEntry> getIdMap() {
            return this.idMap;
        }

        public void setIdMap(Map<String, IDEntry> map) {
            this.idMap = map;
        }

        public String getDefaultClientID() {
            return this.defaultClientID;
        }

        public String getDefaultServerID() {
            return this.defaultServerID;
        }
    }

    static class Entry {
        private static final Class<?>[] PARAMS = new Class[0];
        private static final Object[] ARGS = new Object[0];
        private String moduleClassName;
        private MessagePolicy requestPolicy;
        private MessagePolicy responsePolicy;
        private Map<String, Object> options;

        Entry(String moduleClassName, MessagePolicy requestPolicy, MessagePolicy responsePolicy, Map<String, Object> options) {
            this.moduleClassName = moduleClassName;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
            this.options = options;
        }

        MessagePolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        MessagePolicy getResponsePolicy() {
            return this.responsePolicy;
        }

        String getModuleClassName() {
            return this.moduleClassName;
        }

        Map<String, Object> getOptions() {
            return this.options;
        }

        Object newInstance() throws AuthException {
            try {
                return Class.forName(this.moduleClassName, true, GFServerConfigProvider.getClassLoader()).getConstructor(PARAMS).newInstance(ARGS);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "jaspic.provider_unable_to_load_authmodule", new String[]{this.moduleClassName, e.toString()});
                }
                AuthException ae = new AuthException();
                ae.initCause((Throwable)e);
                throw ae;
            }
        }
    }
}

