/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.security.jacc.JaccWebAuthorizationManager;
import com.sun.enterprise.security.jacc.context.PolicyContextHandlerImpl;
import com.sun.enterprise.security.jacc.context.PolicyContextRegistration;
import jakarta.inject.Singleton;
import jakarta.security.jacc.PolicyContextException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class WebSecurityManagerFactory
extends SecurityManagerFactory {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private final WebSecurityDeployerProbeProvider probeProvider = new WebSecurityDeployerProbeProvider();
    public final PolicyContextHandlerImpl pcHandlerImpl = (PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance();
    public final Map<String, Principal> adminPrincipalsPerApp = new ConcurrentHashMap<String, Principal>();
    public final Map<String, Principal> adminGroupsPerApp = new ConcurrentHashMap<String, Principal>();
    private final Map<String, List<String>> CONTEXT_IDS = new HashMap<String, List<String>>();
    private final Map<String, Map<String, JaccWebAuthorizationManager>> SECURITY_MANAGERS = new HashMap<String, Map<String, JaccWebAuthorizationManager>>();

    public WebSecurityManagerFactory() {
        PolicyContextRegistration.registerPolicyHandlers();
    }

    public JaccWebAuthorizationManager createManager(WebBundleDescriptor webBundleDescriptor, boolean register, ServerContext context) {
        String contextId = JaccWebAuthorizationManager.getContextID(webBundleDescriptor);
        JaccWebAuthorizationManager manager = null;
        if (register) {
            manager = this.getManager(contextId, null, false);
        }
        if (manager == null || !register) {
            try {
                this.probeProvider.securityManagerCreationStartedEvent(webBundleDescriptor.getModuleID());
                manager = new JaccWebAuthorizationManager(webBundleDescriptor, context, this, register);
                this.probeProvider.securityManagerCreationEndedEvent(webBundleDescriptor.getModuleID());
                if (register) {
                    this.addManagerToApp(contextId, null, webBundleDescriptor.getApplication().getRegistrationName(), manager);
                    this.probeProvider.securityManagerCreationEvent(contextId);
                }
            }
            catch (PolicyContextException e) {
                throw new IllegalStateException("Unable to create WebSecurityManager", e);
            }
        }
        return manager;
    }

    public JaccWebAuthorizationManager getManager(String ctxId, String name, boolean remove) {
        return (JaccWebAuthorizationManager)this.getManager(this.SECURITY_MANAGERS, ctxId, name, remove);
    }

    public <T> ArrayList<JaccWebAuthorizationManager> getManagers(String ctxId, boolean remove) {
        return this.getManagers(this.SECURITY_MANAGERS, ctxId, remove);
    }

    public <T> List<JaccWebAuthorizationManager> getManagersForApp(String appName, boolean remove) {
        return this.getManagersForApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, appName, remove);
    }

    public <T> String[] getContextsForApp(String appName, boolean remove) {
        return this.getContextsForApp(this.CONTEXT_IDS, appName, remove);
    }

    public <T> void addManagerToApp(String contextId, String name, String appName, JaccWebAuthorizationManager manager) {
        this.addManagerToApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, contextId, name, appName, manager);
    }

    public void addAdminPrincipal(String username, String realmName, Principal principal) {
        this.adminPrincipalsPerApp.put(realmName + username, principal);
    }

    public void addAdminGroup(String group, String realmName, Principal principal) {
        this.adminGroupsPerApp.put(realmName + group, principal);
    }

    public Principal getAdminPrincipal(String username, String realmName) {
        return this.adminPrincipalsPerApp.get(realmName + username);
    }

    public Principal getAdminGroup(String group, String realmName) {
        return this.adminGroupsPerApp.get(realmName + group);
    }
}

