/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth.jaspic.provider.config;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.ee.authorize.EJBPolicyContextDelegate;
import com.sun.enterprise.security.jaspic.AuthMessagePolicy;
import com.sun.enterprise.security.jaspic.WebServicesDelegate;
import com.sun.enterprise.security.jaspic.config.GFServerConfigProvider;
import com.sun.enterprise.security.jaspic.config.HandlerContext;
import com.sun.enterprise.security.jaspic.config.PayaraJaspicServices;
import com.sun.enterprise.security.webservices.PipeConstants;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.jaspic.services.RegistrationWrapperRemover;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.ws.WebServiceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.internal.api.Globals;

public class PipeHelper
extends PayaraJaspicServices {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PipeConstants.class);
    private AppServerAuditManager auditManager;
    private boolean isEjbEndpoint;
    private SEIModel seiModel;
    private SOAPVersion soapVersion;
    private InvocationManager invManager;
    private EJBPolicyContextDelegate ejbDelegate;

    public PipeHelper(String layer, Map<String, Object> properties, CallbackHandler callbackHandler) {
        WSEndpoint endPoint;
        this.init(layer, PipeHelper.getAppCtxt(properties), properties, callbackHandler, (RegistrationWrapperRemover)Globals.get(WebServicesDelegate.class));
        this.isEjbEndpoint = this.processSunDeploymentDescriptor();
        this.seiModel = (SEIModel)properties.get("SEI_MODEL");
        WSBinding binding = (WSBinding)properties.get("BINDING");
        if (binding == null && (endPoint = (WSEndpoint)properties.get("ENDPOINT")) != null) {
            binding = endPoint.getBinding();
        }
        this.soapVersion = binding != null ? binding.getSOAPVersion() : SOAPVersion.SOAP_11;
        AuditManager am = SecurityServicesUtil.getInstance() != null ? SecurityServicesUtil.getInstance().getAuditManager() : null;
        this.auditManager = am instanceof AppServerAuditManager ? (AppServerAuditManager)am : new AppServerAuditManager();
        this.invManager = SecurityServicesUtil.getInstance() != null ? (InvocationManager)SecurityServicesUtil.getInstance().getHabitat().getService(InvocationManager.class, new Annotation[0]) : null;
        this.ejbDelegate = new EJBPolicyContextDelegate();
    }

    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject subject) throws AuthException {
        ClientAuthConfig clientConfig = (ClientAuthConfig)this.getAuthConfig(false);
        if (clientConfig == null) {
            return null;
        }
        PipeHelper.addModel(info, this.map);
        return clientConfig.getAuthContext(clientConfig.getAuthContextID(info), subject, this.map);
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject subject) throws AuthException {
        ServerAuthConfig serverConfig = (ServerAuthConfig)this.getAuthConfig(true);
        if (serverConfig == null) {
            return null;
        }
        PipeHelper.addModel(info, this.map);
        PipeHelper.addPolicy(info, this.map);
        return serverConfig.getAuthContext(serverConfig.getAuthContextID(info), subject, this.map);
    }

    public static Subject getClientSubject() {
        Subject subject = null;
        if (SecurityServicesUtil.getInstance() == null || SecurityServicesUtil.getInstance().isACC()) {
            ClientSecurityContext clientSecurityContext = ClientSecurityContext.getCurrent();
            if (clientSecurityContext != null) {
                subject = clientSecurityContext.getSubject();
            }
            if (subject == null) {
                subject = Subject.getSubject(AccessController.getContext());
            }
        } else {
            SecurityContext securityContext = SecurityContext.getCurrent();
            if (securityContext != null && !securityContext.didServerGenerateCredentials()) {
                subject = securityContext.getSubject();
            }
        }
        if (subject == null) {
            subject = new Subject();
        }
        return subject;
    }

    public void getSessionToken(Map<String, Object> map, MessageInfo info, Subject subject) throws AuthException {
        ClientAuthConfig clientAuthConfig = (ClientAuthConfig)this.getAuthConfig(false);
        if (clientAuthConfig != null) {
            map.putAll(map);
            PipeHelper.addModel(info, map);
            clientAuthConfig.getAuthContext(clientAuthConfig.getAuthContextID(info), subject, map);
        }
    }

    public void authorize(Packet request) throws Exception {
        Subject s = (Subject)request.invocationProperties.get("CLIENT_SUBJECT");
        if (s == null || s.getPrincipals().isEmpty() && s.getPublicCredentials().isEmpty()) {
            SecurityContext.setUnauthenticatedContext();
        } else {
            SecurityContext sC = new SecurityContext(s);
            SecurityContext.setCurrent((SecurityContext)sC);
        }
        if (this.isEjbEndpoint) {
            if (this.invManager == null) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.webservice.noEjbInvocationManager", "Cannot validate request : invocation manager null for EJB WebService"));
            }
            ComponentInvocation inv = this.invManager.getCurrentInvocation();
            if (this.ejbDelegate != null) {
                this.ejbDelegate.setSOAPMessage((Object)request.getMessage(), inv);
            }
            Method m = null;
            if (this.seiModel != null) {
                JavaMethod jm = request.getMessage().getMethod(this.seiModel);
                m = jm != null ? jm.getMethod() : null;
            } else {
                String ejbImplClassName;
                WebServiceEndpoint endpoint = (WebServiceEndpoint)this.map.get("SERVICE_ENDPOINT");
                EjbDescriptor ejbDescriptor = endpoint.getEjbComponentImpl();
                if (ejbDescriptor != null && (ejbImplClassName = ejbDescriptor.getEjbImplClassName()) != null) {
                    try {
                        m = (Method)AppservAccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                Class<?> clazz = Class.forName(ejbImplClassName, true, loader);
                                return clazz.getMethod("invoke", Object.class);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw new RuntimeException(pae.getException());
                    }
                }
            }
            if (m != null && this.ejbDelegate != null) {
                try {
                    if (!this.ejbDelegate.authorize(inv, m)) {
                        throw new Exception(localStrings.getLocalString("enterprise.webservice.methodNotAuth", "Client not authorized for invocation of {0}", new Object[]{m}));
                    }
                }
                catch (UnmarshalException e) {
                    String errorMsg = localStrings.getLocalString("enterprise.webservice.errorUnMarshalMethod", "Error unmarshalling method for ejb {0}", new Object[]{this.ejbName()});
                    UnmarshalException ie = new UnmarshalException(errorMsg);
                    ie.initCause(e);
                    throw ie;
                }
                catch (Exception e) {
                    Exception ie = new Exception(localStrings.getLocalString("enterprise.webservice.methodNotAuth", "Client not authorized for invocation of {0}", new Object[]{m}));
                    ie.initCause(e);
                    throw ie;
                }
            }
        }
    }

    public void auditInvocation(Packet request, AuthStatus status) {
        if (this.auditManager.isAuditOn()) {
            WebServiceEndpoint endpoint;
            String uri = null;
            if (!this.isEjbEndpoint && request != null && request.supports((Object)"jakarta.xml.ws.servlet.request")) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request.get((Object)"jakarta.xml.ws.servlet.request");
                uri = httpServletRequest.getRequestURI();
            }
            String endpointName = null;
            if (this.map != null && (endpoint = (WebServiceEndpoint)this.map.get("SERVICE_ENDPOINT")) != null) {
                endpointName = endpoint.getEndpointName();
            }
            if (endpointName == null) {
                endpointName = "(no endpoint)";
            }
            if (this.isEjbEndpoint) {
                this.auditManager.ejbAsWebServiceInvocation(endpointName, AuthStatus.SUCCESS.equals(status));
            } else {
                this.auditManager.webServiceInvocation(uri == null ? "(no uri)" : uri, endpointName, AuthStatus.SUCCESS.equals(status));
            }
        }
    }

    public Object getModelName() {
        WSDLPort wsdlModel = (WSDLPort)this.getProperty("WSDL_MODEL");
        return wsdlModel == null ? "unknown" : wsdlModel.getName();
    }

    @Deprecated
    public void addModelAndPolicy(Packet request) {
    }

    public Packet makeFaultResponse(Packet response, Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        if (response == null) {
            response = new Packet();
        }
        try {
            return response.createResponse(Messages.create((Throwable)t, (SOAPVersion)this.soapVersion));
        }
        catch (Exception e) {
            response = new Packet();
            return response.createResponse(Messages.create((Throwable)t, (SOAPVersion)this.soapVersion));
        }
    }

    public boolean isTwoWay(boolean twoWayIsDefault, Packet request) {
        WSDLPort wsdlModel;
        boolean twoWay = twoWayIsDefault;
        Message m = request.getMessage();
        if (m != null && (wsdlModel = (WSDLPort)this.getProperty("WSDL_MODEL")) != null) {
            twoWay = !m.isOneWay(wsdlModel);
        }
        return twoWay;
    }

    public Packet getFaultResponse(Packet request, Packet response, Throwable t) {
        boolean twoWay = true;
        try {
            twoWay = this.isTwoWay(true, request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (twoWay) {
            return this.makeFaultResponse(response, t);
        }
        return new Packet();
    }

    public void disable() {
        this.getRegistrationWrapper().disableWithRefCount();
    }

    protected HandlerContext getHandlerContext(Map map) {
        String realmName = null;
        WebServiceEndpoint wSE = (WebServiceEndpoint)map.get("SERVICE_ENDPOINT");
        if (wSE != null) {
            Application app = wSE.getBundleDescriptor().getApplication();
            if (app != null) {
                realmName = app.getRealm();
            }
            if (realmName == null) {
                realmName = wSE.getRealm();
            }
        }
        final String fRealmName = realmName;
        return new HandlerContext(){

            public String getRealmName() {
                return fRealmName;
            }
        };
    }

    private boolean processSunDeploymentDescriptor() {
        WebServiceEndpoint webServiceEndpoint;
        if (factory == null) {
            return false;
        }
        MessageSecurityBindingDescriptor binding = AuthMessagePolicy.getMessageSecurityBinding((String)"SOAP", (Map)this.map);
        if (binding != null && !this.hasExactMatchAuthProvider()) {
            String jaspicProviderRegisID = factory.registerConfigProvider((AuthConfigProvider)new GFServerConfigProvider(null, null), this.layer, this.appCtxt, "GF AuthConfigProvider bound by Sun Specific Descriptor");
            this.setRegistrationId(jaspicProviderRegisID);
        }
        return (webServiceEndpoint = (WebServiceEndpoint)this.map.get("SERVICE_ENDPOINT")) == null ? false : webServiceEndpoint.implementedByEjbComponent();
    }

    private static String getAppCtxt(Map map) {
        String rvalue;
        WebServiceEndpoint wse = (WebServiceEndpoint)map.get("SERVICE_ENDPOINT");
        if (wse != null) {
            rvalue = PipeHelper.getServerName(wse) + " " + PipeHelper.getEndpointURI(wse);
        } else {
            ServiceReferenceDescriptor srd = (ServiceReferenceDescriptor)map.get("SERVICE_REF");
            rvalue = PipeHelper.getClientModuleID(srd) + " " + PipeHelper.getRefName(srd, map);
        }
        return rvalue;
    }

    private static String getServerName(WebServiceEndpoint wse) {
        String hostname = "localhost";
        return hostname;
    }

    private static String getRefName(ServiceReferenceDescriptor srd, Map map) {
        URL url;
        EndpointAddress ea;
        String name = null;
        if (srd != null) {
            name = srd.getName();
        }
        if (name == null && (ea = (EndpointAddress)map.get("ENDPOINT_ADDRESS")) != null && (url = ea.getURL()) != null) {
            name = url.toString();
        }
        if (name == null) {
            name = "#default-ref-name#";
        }
        return name;
    }

    private static String getEndpointURI(WebServiceEndpoint wse) {
        Object uri = "#default-endpoint-context#";
        if (wse != null) {
            Object contextRoot;
            WebBundleDescriptor wbd;
            uri = wse.getEndpointAddressUri();
            if (uri != null && !((String)uri).startsWith("/")) {
                uri = "/" + (String)uri;
            }
            if (wse.implementedByWebComponent() && (wbd = (WebBundleDescriptor)wse.getBundleDescriptor()) != null && (contextRoot = wbd.getContextRoot()) != null) {
                if (!((String)contextRoot).startsWith("/")) {
                    contextRoot = "/" + (String)contextRoot;
                }
                uri = (String)contextRoot + (String)uri;
            }
        }
        return uri;
    }

    private static String getClientModuleID(ServiceReferenceDescriptor srd) {
        String rvalue = "#default-client-context#";
        if (srd != null) {
            Application a;
            ModuleDescriptor md = null;
            BundleDescriptor bd = srd.getBundleDescriptor();
            if (bd != null) {
                md = bd.getModuleDescriptor();
            }
            Application application = a = bd == null ? null : bd.getApplication();
            if (a != null) {
                if (a.isVirtual()) {
                    rvalue = a.getRegistrationName();
                } else if (md != null) {
                    rvalue = FileUtils.makeFriendlyFilename((String)md.getArchiveUri());
                }
            } else if (md != null) {
                rvalue = FileUtils.makeFriendlyFilename((String)md.getArchiveUri());
            }
        }
        return rvalue;
    }

    private static void addModel(MessageInfo info, Map map) {
        Object model = map.get("WSDL_MODEL");
        if (model != null) {
            info.getMap().put("WSDL_MODEL", model);
        }
    }

    private static void addPolicy(MessageInfo info, Map map) {
        Object pol = map.get("POLICY");
        if (pol != null) {
            info.getMap().put("POLICY", pol);
        }
    }

    private String ejbName() {
        WebServiceEndpoint wSE = (WebServiceEndpoint)this.getProperty("SERVICE_ENDPOINT");
        return wSE == null ? "unknown" : wSE.getEjbComponentImpl().getName();
    }
}

