/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.jaspic.WebServicesDelegate;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.jaspic.provider.PacketMessageInfo;
import com.sun.enterprise.security.jauth.jaspic.provider.SOAPAuthParam;
import com.sun.enterprise.security.webservices.ClientPipeCloser;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.jaspic.services.AuthConfigRegistrationWrapper;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import jakarta.inject.Singleton;
import jakarta.security.auth.message.MessageInfo;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.api.invocation.ComponentInvocation;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class WebServicesDelegateImpl
implements WebServicesDelegate {
    protected static final Logger _logger = LogUtils.getLogger();
    private static final String DEFAULT_WEBSERVICES_PROVIDER = "com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider";

    public MessageSecurityBindingDescriptor getBinding(ServiceReferenceDescriptor svcRef, Map<String, ?> properties) {
        ServiceRefPortInfo i;
        MessageSecurityBindingDescriptor binding = null;
        WSDLPort p = (WSDLPort)properties.get("WSDL_MODEL");
        QName portName = null;
        if (p != null) {
            portName = p.getName();
        }
        if (portName != null && (i = svcRef.getPortInfoByPort(portName)) != null) {
            binding = i.getMessageSecurityBinding();
        }
        return binding;
    }

    public void removeListener(AuthConfigRegistrationWrapper listener) {
        ClientPipeCloser.getInstance().removeListenerWrapper(listener);
    }

    public String getDefaultWebServicesProvider() {
        return DEFAULT_WEBSERVICES_PROVIDER;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        String rvalue = null;
        if (messageInfo instanceof PacketMessageInfo) {
            QName n;
            WSDLBoundOperation w;
            WSDLPort port;
            Message m;
            PacketMessageInfo pmi = (PacketMessageInfo)messageInfo;
            Packet p = pmi.getRequestPacket();
            if (p != null && (m = p.getMessage()) != null && (port = (WSDLPort)messageInfo.getMap().get("WSDL_MODEL")) != null && (w = m.getOperation(port)) != null && (n = w.getName()) != null) {
                rvalue = n.getLocalPart();
            }
            return rvalue;
        }
        return this.getOpName((SOAPMessage)messageInfo.getRequestMessage());
    }

    public AuthParam newSOAPAuthParam(MessageInfo messageInfo) {
        return new SOAPAuthParam((SOAPMessage)messageInfo.getRequestMessage(), (SOAPMessage)messageInfo.getResponseMessage());
    }

    private String getOpName(SOAPMessage message) {
        Name name;
        String[] actions;
        if (message == null) {
            return null;
        }
        String rvalue = null;
        MimeHeaders headers = message.getMimeHeaders();
        if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0 && (rvalue = actions[0]) != null && rvalue.equals("\"\"")) {
            rvalue = null;
        }
        if (rvalue == null && (name = this.getName(message)) != null) {
            rvalue = name.getLocalName();
        }
        return rvalue;
    }

    private Name getName(SOAPMessage message) {
        Name rvalue;
        block4: {
            rvalue = null;
            SOAPPart soap = message.getSOAPPart();
            if (soap != null) {
                try {
                    SOAPBody body;
                    SOAPEnvelope envelope = soap.getEnvelope();
                    if (envelope == null || (body = envelope.getBody()) == null) break block4;
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SOAPElement)) continue;
                        rvalue = ((SOAPElement)o).getElementName();
                        break;
                    }
                }
                catch (SOAPException se) {
                    if (!_logger.isLoggable(Level.FINE)) break block4;
                    _logger.log(Level.FINE, "WSS: Unable to get SOAP envelope", se);
                }
            }
        }
        return rvalue;
    }

    public Object getSOAPMessage(ComponentInvocation inv) {
        return null;
    }
}

