/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class PayaraApplicationHandlers {
    private static final String CLUSTER = "/clusters/cluster/";
    private static final String SERVER = "/servers/server/";
    private static final String DEPLOYMENT_GROUP = "/deployment-groups/deployment-group/";
    private static final String APPLICATION_REF = "/application-ref/";
    private static final String RESOURCE_REF = "/resource-ref/";
    private static final String REST_URL = "REST_URL";
    private static final String RESOURCE_NAME = "resourceName";

    public static void getTargetListInfo(HandlerContext handlerCtx) {
        String applicationName = (String)handlerCtx.getInputValue("appName");
        String prefix = (String)GuiUtil.getSessionValue(REST_URL);
        List<String> clusters = TargetUtil.getClusters();
        List<String> standalone = TargetUtil.getStandaloneInstances();
        List<String> deploymentGroup = TargetUtil.getDeploymentGroups();
        standalone.add("server");
        List<String> targetList = DeployUtil.getApplicationTarget(applicationName, "application-ref");
        ArrayList result = new ArrayList();
        Map<String, Object> attributes = null;
        Object endpoint = "";
        List<String> instancesInDeploymentGroup = PayaraApplicationHandlers.getInstancesInDeploymentGroup(targetList);
        for (String oneTarget : targetList) {
            Boolean addToResult = false;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (clusters.contains(oneTarget)) {
                endpoint = prefix + CLUSTER + oneTarget + APPLICATION_REF + applicationName;
                attributes = RestUtil.getAttributesMap((String)endpoint);
                addToResult = true;
            } else if (standalone.contains(oneTarget) && !instancesInDeploymentGroup.contains(oneTarget)) {
                endpoint = prefix + SERVER + oneTarget + APPLICATION_REF + applicationName;
                attributes = RestUtil.getAttributesMap((String)endpoint);
                addToResult = true;
            } else if (deploymentGroup.contains(oneTarget)) {
                endpoint = prefix + DEPLOYMENT_GROUP + oneTarget + APPLICATION_REF + applicationName;
                attributes = RestUtil.getAttributesMap((String)endpoint);
                addToResult = true;
            }
            if (!addToResult.booleanValue()) continue;
            oneRow.put("name", applicationName);
            oneRow.put("selected", false);
            oneRow.put("endpoint", ((String)endpoint).replaceAll("/application-ref/.*", "/update-application-ref"));
            oneRow.put("targetName", oneTarget);
            oneRow.put("enabled", attributes.get("enabled"));
            oneRow.put("lbEnabled", attributes.get("lbEnabled"));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static List<String> getInstancesInDeploymentGroup(List<String> targetList) {
        ArrayList<String> listOfInstancesInDeploymentGroup = new ArrayList<String>();
        for (String oneTarget : targetList) {
            if (!TargetUtil.isDeploymentGroup(oneTarget)) continue;
            List<String> instancesInDeploymentGroup = TargetUtil.getDGInstances(oneTarget);
            for (String instance : instancesInDeploymentGroup) {
                listOfInstancesInDeploymentGroup.add(instance);
            }
        }
        return listOfInstancesInDeploymentGroup;
    }

    public static void getAllSelectedTarget(HandlerContext handlerCtx) {
        String prefix = (String)GuiUtil.getSessionValue(REST_URL);
        List targetList = (List)handlerCtx.getInputValue("targetList");
        String resourceName = (String)handlerCtx.getInputValue(RESOURCE_NAME);
        ArrayList<String> selectedTargetList = new ArrayList<String>();
        for (String targetName : targetList) {
            String endpoint = prefix + CLUSTER + targetName + RESOURCE_REF + resourceName;
            boolean existsInCluster = PayaraApplicationHandlers.isEndpointValid(endpoint);
            if (!existsInCluster) {
                boolean existsInServer;
                endpoint = prefix + DEPLOYMENT_GROUP + targetName + RESOURCE_REF + resourceName;
                boolean existsInDeploymentGroup = PayaraApplicationHandlers.isEndpointValid(endpoint);
                if (!existsInDeploymentGroup && (existsInServer = PayaraApplicationHandlers.isEndpointValid(endpoint = prefix + SERVER + targetName + RESOURCE_REF + resourceName))) {
                    selectedTargetList.add(targetName);
                }
                if (existsInDeploymentGroup) {
                    selectedTargetList.add(targetName);
                }
            }
            if (!existsInCluster) continue;
            selectedTargetList.add(targetName);
        }
        handlerCtx.setOutputValue("selectedTarget", selectedTargetList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEndpointValid(String endpoint) {
        boolean result = false;
        try (RestResponse response = null;){
            response = RestUtil.get(endpoint);
            result = response.isSuccess();
        }
        return result;
    }

    public static void isResourceInInstance(HandlerContext handlerCtx) {
        Map childResources;
        ArrayList listOfResources;
        Map extraProperties;
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String resourceName = (String)handlerCtx.getInputValue(RESOURCE_NAME);
        String prefix = (String)GuiUtil.getSessionValue(REST_URL);
        String endpoint = prefix + SERVER + instanceName + RESOURCE_REF;
        boolean isPresent = false;
        Map<String, Object> responseMap = RestUtil.restRequest(endpoint, null, "GET", handlerCtx, false, true);
        Map data = (Map)responseMap.get("data");
        if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null && (listOfResources = new ArrayList((childResources = (Map)extraProperties.get("childResources")).keySet())).contains(resourceName)) {
            isPresent = true;
        }
        handlerCtx.setOutputValue("isPresent", (Object)isPresent);
    }

    public static void isInstanceInDeploymentGroupWithResource(HandlerContext handlerCtx) {
        List selectedTargetList = (List)handlerCtx.getInputValue("selectedTarget");
        String target = (String)handlerCtx.getInputValue("target");
        String prefix = (String)GuiUtil.getSessionValue(REST_URL);
        String resourceName = (String)handlerCtx.getInputValue(RESOURCE_NAME);
        boolean isPresent = false;
        block0: for (String selectedTarget : selectedTargetList) {
            if (!TargetUtil.isDeploymentGroup(selectedTarget)) continue;
            List<String> instancesInDeploymentGroup = TargetUtil.getDGInstances(selectedTarget);
            for (String instance : instancesInDeploymentGroup) {
                String endpoint;
                if (!instance.equals(target) || !PayaraApplicationHandlers.isEndpointValid(endpoint = prefix + DEPLOYMENT_GROUP + selectedTarget + RESOURCE_REF + resourceName)) continue;
                isPresent = true;
                continue block0;
            }
        }
        handlerCtx.setOutputValue("isPresent", (Object)isPresent);
    }
}

