/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.aws.client;

import com.nimbusds.jose.util.StandardCharset;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AuthUtils {
    private AuthUtils() {
    }

    protected static String generateHex(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data.getBytes(StandardCharset.UTF_8));
            byte[] digest = messageDigest.digest();
            return String.format("%064x", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String bytesToHex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes).toLowerCase();
    }

    protected static byte[] HmacSHA256(byte[] key, String data) throws Exception {
        String algorithm = "HmacSHA256";
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(data.getBytes(StandardCharset.UTF_8));
    }

    protected static byte[] getSignatureKey(String key, String date, String regionName, String serviceName) throws Exception {
        byte[] kSecret = ("AWS4" + key).getBytes(StandardCharset.UTF_8);
        byte[] kDate = AuthUtils.HmacSHA256(kSecret, date);
        byte[] kRegion = AuthUtils.HmacSHA256(kDate, regionName);
        byte[] kService = AuthUtils.HmacSHA256(kRegion, serviceName);
        byte[] kSigning = AuthUtils.HmacSHA256(kService, "aws4_request");
        return kSigning;
    }

    protected static String getTimestamp(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }
}

