/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.aws.client;

import fish.payara.microprofile.config.extensions.aws.client.AuthUtils;
import fish.payara.microprofile.config.extensions.aws.client.AwsAuthFeature;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.logging.LoggingFeature;

public class AwsRequestBuilder {
    private static final Logger LOGGER = Logger.getLogger(AwsRequestBuilder.class.getName());
    private final Client client;
    private String serviceName;
    private String region;
    private String method;
    private String action;
    private String version;
    private String contentType;
    private JsonObject data;

    public AwsRequestBuilder(String accessKey, String secretKey) {
        this.client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register((Object)new AwsAuthFeature(accessKey, secretKey))).register((Object)new LoggingFeature(LOGGER, Level.FINE, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(100)))).build();
    }

    public AwsRequestBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public AwsRequestBuilder region(String region) {
        this.region = region;
        return this;
    }

    public AwsRequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    public AwsRequestBuilder action(String action) {
        this.action = action;
        return this;
    }

    public AwsRequestBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AwsRequestBuilder ContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public AwsRequestBuilder data(JsonObject data) {
        this.data = data;
        return this;
    }

    public Invocation build() {
        Date creationTime = new Date();
        String query = MessageFormat.format("Action={0}&Version={1}", this.action, this.version);
        String payload = this.data.toString();
        String host = MessageFormat.format("{0}.{1}.amazonaws.com", this.serviceName.toLowerCase(), this.region);
        String endpoint = "https://" + host;
        Object serviceNameValue = this.serviceName.equals("DynamoDB") ? this.serviceName + "_20120810" : this.serviceName;
        String xAmzTarget = (String)serviceNameValue + "." + this.action;
        String xAmzContentSha256 = AuthUtils.generateHex(payload);
        return this.client.target(endpoint + "?" + query).request().header("X-Amz-Content-Sha256", (Object)xAmzContentSha256).header("X-Amz-Date", (Object)AuthUtils.getTimestamp(creationTime)).header("X-Amz-Target", (Object)xAmzTarget).build(this.method, Entity.entity((Object)payload, (String)this.contentType));
    }

    public static AwsRequestBuilder builder(String accessKey, String secretKey) {
        return new AwsRequestBuilder(accessKey, secretKey);
    }
}

