/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.azure;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import fish.payara.microprofile.config.extensions.azure.AzureSecretsConfigSourceConfiguration;
import fish.payara.microprofile.config.extensions.azure.model.Secret;
import fish.payara.microprofile.config.extensions.azure.model.SecretHolder;
import fish.payara.microprofile.config.extensions.azure.model.SecretsResponse;
import fish.payara.microprofile.config.extensions.oauth.OAuth2Client;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.DatatypeConverter;
import java.io.File;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Service;

@Service(name="azure-secrets-config-source")
public class AzureSecretsConfigSource
extends ConfiguredExtensionConfigSource<AzureSecretsConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(AzureSecretsConfigSource.class.getName());
    private OAuth2Client authClient;
    private Client client = ClientBuilder.newClient();
    private static final String AUTH_URL = "https://login.microsoftonline.com/%s/oauth2/v2.0/token";
    private static final String SCOPE_URL = "https://vault.azure.net/.default";
    private static final String SECRETS_ENDPOINT = "https://%s.vault.azure.net/secrets";
    private static final String API_VERSION = "?api-version=7.1";
    @Inject
    private ServerEnvironment env;
    @Inject
    MicroprofileConfigConfiguration mpconfig;

    @Override
    public void bootstrap() {
        StringBuilder contentBuilder;
        block13: {
            contentBuilder = new StringBuilder();
            try {
                File tokenFile = this.getPrivateKeyFile();
                if (tokenFile == null) {
                    LOGGER.warning("Couldn't find private key file, make sure it's configured.");
                    break block13;
                }
                try (Stream<String> stream = Files.lines(tokenFile.toPath());){
                    stream.forEach(s -> contentBuilder.append((String)s));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Couldn't find or read the private key file, make sure it exists.", ex);
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        String tenantId = ((AzureSecretsConfigSourceConfiguration)this.configuration).getTenantId();
        String clientId = ((AzureSecretsConfigSourceConfiguration)this.configuration).getClientId();
        if (tenantId == null || clientId == null) {
            LOGGER.warning("An error occurred while authenticating Azure to get a token, makes sure Azure Config Source has been configured with correct  configuration options.");
        } else {
            data.put("grant_type", "client_credentials");
            data.put("client_id", clientId);
            data.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            data.put("scope", SCOPE_URL);
            try {
                SignedJWT jwt = AzureSecretsConfigSource.buildJwt(clientId, String.format(AUTH_URL, tenantId), ((AzureSecretsConfigSourceConfiguration)this.configuration).getThumbprint());
                jwt.sign((JWSSigner)new RSASSASigner(AzureSecretsConfigSource.parsePrivateKey(contentBuilder.toString())));
                data.put("client_assertion", jwt.serialize());
            }
            catch (JOSEException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOGGER.log(Level.WARNING, "An error occurred while signing the Azure auth token", e);
            }
            this.authClient = new OAuth2Client(String.format(AUTH_URL, tenantId), data);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> results = new HashMap<String, String>();
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return results;
        }
        WebTarget secretsTarget = this.client.target(String.format(SECRETS_ENDPOINT, ((AzureSecretsConfigSourceConfiguration)this.configuration).getKeyVaultName()) + API_VERSION);
        Response secretsResponse = secretsTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
        if (secretsResponse.getStatus() != 200) {
            return results;
        }
        List<Secret> secrets = ((SecretsResponse)secretsResponse.readEntity(SecretsResponse.class)).getValue();
        for (Secret secret : secrets) {
            String secretName = secret.getId().replace(String.format(SECRETS_ENDPOINT, ((AzureSecretsConfigSourceConfiguration)this.configuration).getKeyVaultName()) + "/", "");
            results.put(secretName, this.getValue(secretName));
        }
        return results;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    @Override
    public String getValue(String propertyName) {
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return null;
        }
        WebTarget secretTarget = this.client.target(String.format(SECRETS_ENDPOINT, ((AzureSecretsConfigSourceConfiguration)this.configuration).getKeyVaultName()) + "/" + propertyName + API_VERSION);
        Response secretResponse = secretTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
        int status = secretResponse.getStatus();
        if (status != 200) {
            if (status != 400) {
                LOGGER.log(Level.WARNING, "Failed to get Azure secret. {0}", secretResponse.readEntity(String.class));
            }
            return null;
        }
        String value = ((Secret)secretResponse.readEntity(Secret.class)).getValue();
        return value;
    }

    @Override
    public boolean setValue(String secretName, String secretValue) {
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return false;
        }
        WebTarget setSecretTarget = this.client.target(String.format(SECRETS_ENDPOINT, ((AzureSecretsConfigSourceConfiguration)this.configuration).getKeyVaultName()) + "/" + secretName + API_VERSION);
        Response setSecretResponse = setSecretTarget.request().accept(new String[]{"application/json"}).header("Content-Type", (Object)"application/json").header("Authorization", (Object)("Bearer " + accessToken)).put(Entity.entity((Object)new SecretHolder(secretValue), (String)"application/json"));
        if (setSecretResponse.getStatus() == 200) {
            return true;
        }
        LOGGER.log(Level.WARNING, "Failed to set Azure secret. {0}", setSecretResponse.readEntity(String.class));
        return false;
    }

    @Override
    public boolean deleteValue(String secretName) {
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return false;
        }
        WebTarget secretTarget = this.client.target(String.format(SECRETS_ENDPOINT, ((AzureSecretsConfigSourceConfiguration)this.configuration).getKeyVaultName()) + "/" + secretName + API_VERSION);
        Response secretResponse = secretTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).delete();
        if (secretResponse.getStatus() == 200) {
            return true;
        }
        LOGGER.log(Level.WARNING, "Failed to delete Azure secret. {0}", secretResponse.readEntity(String.class));
        return false;
    }

    @Override
    public String getSource() {
        return "cloud";
    }

    @Override
    public String getName() {
        return "azure";
    }

    @Override
    public int getOrdinal() {
        return Integer.parseInt(this.mpconfig.getCloudOrdinality());
    }

    private File getPrivateKeyFile() {
        String fileName = ((AzureSecretsConfigSourceConfiguration)this.configuration).getPrivateKeyFilePath();
        if (fileName != null) {
            return this.env.getConfigDirPath().toPath().resolve(((AzureSecretsConfigSourceConfiguration)this.configuration).getPrivateKeyFilePath()).toFile();
        }
        return null;
    }

    private static SignedJWT buildJwt(String issuer, String audience, String thumbprint) {
        Instant now = Instant.now();
        Instant expiry = now.plus(1L, ChronoUnit.MINUTES);
        JWTClaimsSet claims = new JWTClaimsSet.Builder().subject(issuer).audience(audience).expirationTime(Date.from(expiry)).issueTime(Date.from(now)).issuer(issuer).build();
        byte[] bytes = DatatypeConverter.parseHexBinary((String)thumbprint);
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).x509CertThumbprint(Base64URL.encode((byte[])bytes)).build();
        return new SignedJWT(header, claims);
    }

    private static PrivateKey parsePrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String privateKeyContent = privateKey.replaceAll("\\n", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(new Base64(privateKeyContent).decode());
        return kf.generatePrivate(keySpecPKCS8);
    }

    private String authenticate() {
        if (this.authClient == null) {
            LOGGER.log(Level.WARNING, "Couldn't authenticate with Azure. Check your configuration options are correct.");
        } else {
            Response response = this.authClient.authenticate();
            int status = response.getStatus();
            if (status == 200) {
                JsonObject data = (JsonObject)response.readEntity(JsonObject.class);
                Integer expirySeconds = data.getInt("expires_in");
                this.authClient.expire(Duration.ofSeconds(expirySeconds.intValue()));
                return data.getString("access_token");
            }
            if (status == 400) {
                LOGGER.log(Level.WARNING, "Couldn't authenticate with Azure. Check your configuration options are correct.");
            }
        }
        return null;
    }
}

