/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import fish.payara.cdi.jsr107.AbstractJSR107Interceptor;
import fish.payara.cdi.jsr107.implementation.PayaraCacheKeyInvocationContext;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;

@CacheResult
@Interceptor
@Priority(value=4000)
public class CacheResultInterceptor
extends AbstractJSR107Interceptor {
    @AroundInvoke
    public Object cacheResult(InvocationContext ctx) throws Throwable {
        if (!this.isEnabled()) {
            return ctx.proceed();
        }
        CacheResult annotation = ctx.getMethod().getAnnotation(CacheResult.class);
        PayaraCacheKeyInvocationContext<CacheResult> pctx = new PayaraCacheKeyInvocationContext<CacheResult>(ctx, annotation);
        CacheResolverFactory resolverF = pctx.getFactory();
        CacheResolver cacheResolver = resolverF.getCacheResolver(pctx);
        Cache cache = cacheResolver.resolveCache(pctx);
        boolean cacheExceptions = annotation.exceptionCacheName() != null && annotation.exceptionCacheName().length() > 0;
        CacheKeyGenerator generator = pctx.getGenerator();
        GeneratedCacheKey key = generator.generateCacheKey(pctx);
        if (!annotation.skipGet()) {
            Cache exceptionCache;
            Throwable e;
            Object cacheResult = cache.get((Object)key);
            if (cacheResult != null) {
                return cacheResult;
            }
            if (cacheExceptions && (e = (Throwable)(exceptionCache = resolverF.getExceptionCacheResolver(pctx).resolveCache(pctx)).get((Object)key)) != null) {
                throw e;
            }
        }
        Object result = null;
        try {
            result = ctx.proceed();
            cache.put((Object)key, result);
        }
        catch (Throwable e) {
            if (cacheExceptions) {
                Cache exceptionCache = resolverF.getExceptionCacheResolver(pctx).resolveCache(pctx);
                if (this.shouldICache(annotation.cachedExceptions(), annotation.nonCachedExceptions(), e, true)) {
                    exceptionCache.put((Object)key, (Object)e);
                }
            }
            throw e;
        }
        return result;
    }
}

