/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.record;

import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.CompactUtil;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.record.ComponentReaderWriter;
import com.hazelcast.internal.serialization.impl.compact.record.JavaRecordReader;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriter;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriters;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class JavaRecordSerializer
implements CompactSerializer<Object> {
    private final Method isRecordMethod;
    private final Method getRecordComponentsMethod;
    private final Method getTypeMethod;
    private final Method getNameMethod;
    private final Method getGenericTypeMethod;
    private final CompactStreamSerializer compactStreamSerializer;
    private final Map<Class<?>, JavaRecordReader> readersCache = new ConcurrentHashMap();
    private final Map<Class<?>, ComponentReaderWriter[]> readerWritersCache = new ConcurrentHashMap();

    public JavaRecordSerializer(CompactStreamSerializer compactStreamSerializer) {
        Method getGenericTypeMethod;
        Method getNameMethod;
        Method getTypeMethod;
        Method getRecordComponentsMethod;
        Method isRecordMethod;
        this.compactStreamSerializer = compactStreamSerializer;
        try {
            isRecordMethod = Class.class.getMethod("isRecord", new Class[0]);
            getRecordComponentsMethod = Class.class.getMethod("getRecordComponents", new Class[0]);
            Class<?> recordComponentClass = Class.forName("java.lang.reflect.RecordComponent");
            getTypeMethod = recordComponentClass.getMethod("getType", new Class[0]);
            getNameMethod = recordComponentClass.getMethod("getName", new Class[0]);
            getGenericTypeMethod = recordComponentClass.getMethod("getGenericType", new Class[0]);
        }
        catch (Throwable t) {
            isRecordMethod = null;
            getRecordComponentsMethod = null;
            getTypeMethod = null;
            getNameMethod = null;
            getGenericTypeMethod = null;
        }
        this.isRecordMethod = isRecordMethod;
        this.getRecordComponentsMethod = getRecordComponentsMethod;
        this.getTypeMethod = getTypeMethod;
        this.getNameMethod = getNameMethod;
        this.getGenericTypeMethod = getGenericTypeMethod;
    }

    public boolean isRecord(Class<?> clazz) {
        if (this.isRecordMethod == null) {
            return false;
        }
        try {
            return (Boolean)this.isRecordMethod.invoke(clazz, new Object[0]);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    @Nonnull
    public Object read(@Nonnull CompactReader reader) {
        DefaultCompactReader compactReader = (DefaultCompactReader)reader;
        Class associatedClass = Objects.requireNonNull(compactReader.getAssociatedClass(), "AssociatedClass is required for JavaRecordSerializer");
        JavaRecordReader recordReader = this.readersCache.get(associatedClass);
        if (recordReader == null) {
            this.populateReadersWriters(associatedClass);
            recordReader = this.readersCache.get(associatedClass);
        }
        return recordReader.readRecord(compactReader, compactReader.getSchema());
    }

    @Override
    public void write(@Nonnull CompactWriter writer, @Nonnull Object object) {
        Class<?> clazz = object.getClass();
        ComponentReaderWriter[] readerWriters = this.readerWritersCache.get(clazz);
        if (readerWriters == null) {
            this.populateReadersWriters(clazz);
            readerWriters = this.readerWritersCache.get(clazz);
        }
        try {
            for (ComponentReaderWriter readerWriter : readerWriters) {
                readerWriter.writeComponent(writer, object);
            }
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to write the Java record", e);
        }
    }

    @Override
    @Nonnull
    public String getTypeName() {
        throw new IllegalStateException("getTypeName should not be called for the record serializer");
    }

    @Override
    @Nonnull
    public Class<Object> getCompactClass() {
        throw new IllegalStateException("getCompactClass should not be called for the record serializer");
    }

    private void populateReadersWriters(Class<?> clazz) {
        CompactUtil.verifyClassIsCompactSerializable(clazz);
        try {
            Object[] recordComponents = (Object[])this.getRecordComponentsMethod.invoke(clazz, new Object[0]);
            Class[] componentTypes = new Class[recordComponents.length];
            ComponentReaderWriter[] componentReaderWriters = new ComponentReaderWriter[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                Object recordComponent = recordComponents[i];
                Class type = (Class)this.getTypeMethod.invoke(recordComponent, new Object[0]);
                Type genericType = (Type)this.getGenericTypeMethod.invoke(recordComponent, new Object[0]);
                String name = (String)this.getNameMethod.invoke(recordComponent, new Object[0]);
                componentTypes[i] = type;
                Method componentGetter = clazz.getDeclaredMethod(name, new Class[0]);
                componentGetter.setAccessible(true);
                componentReaderWriters[i] = new ComponentReaderWriterAdapter(ValueReaderWriters.readerWriterFor(this.compactStreamSerializer, clazz, type, genericType, name), componentGetter);
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(componentTypes);
            constructor.setAccessible(true);
            JavaRecordReader recordReader = new JavaRecordReader(constructor, componentReaderWriters);
            this.readersCache.put(clazz, recordReader);
            this.readerWritersCache.put(clazz, componentReaderWriters);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to construct the readers/writers for the Java record", e);
        }
    }

    private static final class ComponentReaderWriterAdapter
    implements ComponentReaderWriter {
        private final ValueReaderWriter readerWriter;
        private final Method componentGetter;

        private ComponentReaderWriterAdapter(ValueReaderWriter readerWriter, Method componentGetter) {
            this.readerWriter = readerWriter;
            this.componentGetter = componentGetter;
        }

        @Override
        public Object readComponent(CompactReader compactReader, Schema schema) {
            return this.readerWriter.read(compactReader, schema);
        }

        @Override
        public void writeComponent(CompactWriter compactWriter, Object recordObject) throws Exception {
            this.readerWriter.write(compactWriter, this.componentGetter.invoke(recordObject, new Object[0]));
        }
    }
}

