/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.metroglue;

import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.tx.dev.WSATRuntimeConfig;
import com.sun.xml.wss.impl.config.SecurityConfigProvider;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.File;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.webservices.WebServiceDeploymentListener;
import org.glassfish.webservices.WebServicesDeployer;
import org.glassfish.webservices.metroglue.LogUtils;
import org.glassfish.webservices.metroglue.MetroDeployer;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="org.glassfish.webservices.metroglue.MetroContainer")
@Singleton
public class MetroContainer
implements PostConstruct,
Container,
WebServiceDeploymentListener {
    private static final Logger logger = LogUtils.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final String WSTX_SERVICES_APP_NAME = "wstx-services";
    private static final String METRO_APPS_INSTALL_ROOT = "lib/install/applications/metro";
    private static final Object lock = new Object();
    private final AtomicBoolean wstxServicesDeployed = new AtomicBoolean(false);
    private final AtomicBoolean wstxServicesDeploying = new AtomicBoolean(false);
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ServerContext serverContext;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject
    private RecoveryResourceRegistry recoveryRegistry;
    @Inject
    JavaEETransactionManager txManager;
    @Inject
    HazelcastCore hazelcastCore;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private AvailabilityService availabilityService;
    @Inject
    @Named(value="default-instance-name")
    private SecurityService securityService;

    public void postConstruct() {
        Property maxNonceAgeProperty;
        WebServicesDeployer.getDeploymentNotifier().addListener((WebServiceDeploymentListener)this);
        logger.info("AS-WSMETROGLUE-10010");
        if (this.isCluster() && this.isHaEnabled()) {
            HighAvailabilityProvider.INSTANCE.initHaEnvironment(this.hazelcastCore.getMemberGroup(), this.hazelcastCore.getMemberName());
            logger.info("AS-WSMETROGLUE-10020");
        }
        if ((maxNonceAgeProperty = this.securityService.getProperty("MAX_NONCE_AGE")) != null) {
            SecurityConfigProvider.INSTANCE.init(Long.parseLong(maxNonceAgeProperty.getValue()));
        }
    }

    public Class<? extends Deployer> getDeployer() {
        return MetroDeployer.class;
    }

    public String getName() {
        return "metro";
    }

    public void onDeployed(WebServiceEndpoint endpoint) {
        logger.finest("AS-WSMETROGLUE-10011");
        if (!this.wstxServicesDeployed.get() && !this.wstxServicesDeploying.get()) {
            this.deployWsTxServices();
            this.initializeWsTxRuntime();
        }
    }

    public void onUndeployed(WebServiceEndpoint endpoint) {
        logger.finest("AS-WSMETROGLUE-10012");
    }

    public void deployWsTxServices() {
        this.deployWsTxServices(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployWsTxServices(String target) {
        Object object = lock;
        synchronized (object) {
            if (this.wstxServicesDeployed.get() || !this.wstxServicesDeploying.compareAndSet(false, true)) {
                return;
            }
            Deployment deployment = (Deployment)this.serviceLocator.getService(Deployment.class, new Annotation[0]);
            boolean isRegistered = deployment.isRegistered(WSTX_SERVICES_APP_NAME);
            if (isRegistered) {
                logger.log(Level.WARNING, "AS-WSMETROGLUE-10003");
            } else {
                logger.log(Level.INFO, "AS-WSMETROGLUE-10001");
                File root = this.serverContext.getInstallRoot();
                File app = null;
                try {
                    app = FileUtils.getManagedFile("wstx-services.war", new File(root, METRO_APPS_INSTALL_ROOT));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "AS-WSMETROGLUE-19999", e);
                }
                if (app == null || !app.exists()) {
                    logger.log(Level.WARNING, this.format("AS-WSMETROGLUE-10004", "Required WAR file (wstx-services.war) is not installed"));
                } else {
                    String appName;
                    ActionReport report = (ActionReport)this.serviceLocator.getService(ActionReport.class, "plain", new Annotation[0]);
                    DeployCommandParameters params = new DeployCommandParameters(app);
                    params.name = appName = WSTX_SERVICES_APP_NAME;
                    try {
                        File rootScratchDir = this.env.getApplicationStubPath();
                        File appScratchDir = new File(rootScratchDir, appName);
                        if (this.isDas() && appScratchDir.createNewFile()) {
                            params.origin = OpsParams.Origin.deploy;
                            if (target != null) {
                                params.target = target;
                            }
                        } else {
                            params.origin = OpsParams.Origin.load;
                            params.target = this.env.getInstanceName();
                        }
                        ExtendedDeploymentContext dc = deployment.getBuilder(logger, (OpsParams)params, report).source(app).build();
                        Properties appProps = dc.getAppProps();
                        appProps.setProperty("object-type", "system-all");
                        deployment.deploy(dc);
                        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                            logger.log(Level.WARNING, this.format("AS-WSMETROGLUE-10004", report.getMessage()), report.getFailureCause());
                        }
                        logger.log(Level.INFO, "AS-WSMETROGLUE-10002");
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, this.format("AS-WSMETROGLUE-10004", ex.getLocalizedMessage()), ex);
                    }
                }
            }
            this.wstxServicesDeployed.set(true);
            this.wstxServicesDeploying.set(false);
        }
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(rb.getString(key), values);
    }

    private boolean isDas() {
        return this.env.isDas() || this.env.isEmbedded();
    }

    private boolean isCluster() {
        return !this.env.isDas() && !this.env.isEmbedded() && this.hazelcastCore.isEnabled();
    }

    private boolean isHaEnabled() {
        boolean haEnabled = false;
        if (this.availabilityService != null) {
            haEnabled = Boolean.valueOf(this.availabilityService.getAvailabilityEnabled());
        }
        return haEnabled;
    }

    private void initializeWsTxRuntime() {
        String serverName = this.serverContext.getInstanceName();
        Config config = this.serverContext.getConfigBean().getConfig();
        WSATRuntimeConfig.TxlogLocationProvider txlogLocationProvider = new WSATRuntimeConfig.TxlogLocationProvider(){

            public String getTxLogLocation() {
                return MetroContainer.this.txManager.getTxLogLocation();
            }
        };
        WSATRuntimeConfig.initializer().hostName(this.getHostName()).httpPort(this.getHttpPort(false, serverName, config)).httpsPort(this.getHttpPort(true, serverName, config)).txLogLocation(txlogLocationProvider).done();
        WSATRuntimeConfig.WSATRecoveryEventListener metroListener = new WSATRuntimeConfig.WSATRecoveryEventListener(WSATRuntimeConfig.getInstance());
        this.recoveryRegistry.addEventListener(new RecoveryEventListener((WSATRuntimeConfig.RecoveryEventListener)metroListener){
            final /* synthetic */ WSATRuntimeConfig.RecoveryEventListener val$metroListener;
            {
                this.val$metroListener = recoveryEventListener;
            }

            public void beforeRecovery(boolean delegated, String instance) {
                this.val$metroListener.beforeRecovery(delegated, instance);
            }

            public void afterRecovery(boolean success, boolean delegated, String instance) {
                this.val$metroListener.afterRecovery(success, delegated, instance);
            }
        });
    }

    private String getHostName() {
        return System.getProperty("com.sun.aas.hostName");
    }

    private String getHttpPort(boolean secure, String serverName, Config config) {
        try {
            String networkListeners = config.getHttpService().getVirtualServerByName(serverName).getNetworkListeners();
            if (networkListeners == null || networkListeners.isEmpty()) {
                return null;
            }
            for (String listenerName : networkListeners.split(",")) {
                NetworkListener listener;
                if (listenerName == null || listenerName.isEmpty() || secure != Boolean.valueOf((listener = config.getNetworkConfig().getNetworkListener(listenerName.trim())).findHttpProtocol().getSecurityEnabled())) continue;
                return listener.getPort();
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINEST, "AS-WSMETROGLUE-19998", t);
        }
        return null;
    }
}

