/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.cdi.MetricUtils;
import fish.payara.microprofile.metrics.impl.ConfigurationProperties;
import fish.payara.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import fish.payara.microprofile.metrics.impl.MetricsConfigParserUtil;
import fish.payara.microprofile.metrics.impl.MetricsCustomBuckets;
import fish.payara.microprofile.metrics.impl.MetricsCustomPercentiles;
import jakarta.enterprise.inject.Vetoed;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;

@Vetoed
public class HistogramImpl
implements Histogram {
    private final ExponentiallyDecayingReservoir reservoir;
    private final LongAdder count;
    private final AtomicLong sum;
    private ConfigurationProperties configurationProperties;

    public HistogramImpl(String metricName, Map<String, Collection<MetricsCustomPercentiles>> percentilesConfigMap, Map<String, Collection<MetricsCustomBuckets>> bucketsConfigMap) {
        this();
        this.validateMetricsConfiguration(metricName, percentilesConfigMap, bucketsConfigMap);
    }

    public HistogramImpl() {
        this(new ExponentiallyDecayingReservoir());
    }

    public HistogramImpl(ExponentiallyDecayingReservoir reservoir) {
        this.reservoir = reservoir;
        this.count = new LongAdder();
        this.sum = new AtomicLong();
    }

    @Override
    public void update(int value) {
        this.update((long)value);
    }

    @Override
    public void update(long value) {
        this.count.increment();
        this.sum.getAndAdd(value);
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.sum();
    }

    @Override
    public long getSum() {
        return this.sum.get();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    public String toString() {
        return "Histogram[" + this.getCount() + "]";
    }

    void validateMetricsConfiguration(String metricName, Map<String, Collection<MetricsCustomPercentiles>> percentilesConfigMap, Map<String, Collection<MetricsCustomBuckets>> bucketsConfigMap) {
        Collection computedPercentiles = percentilesConfigMap.computeIfAbsent(metricName, MetricsConfigParserUtil::processPercentileMap);
        Collection computedBuckets = bucketsConfigMap.computeIfAbsent(metricName, this::processHistogramBucketMap);
        MetricsCustomPercentiles resultPercentile = null;
        MetricsCustomBuckets resultBuckets = null;
        this.configurationProperties = new ConfigurationProperties();
        if (computedPercentiles != null && !computedPercentiles.isEmpty()) {
            resultPercentile = MetricsCustomPercentiles.matches(computedPercentiles, metricName);
        }
        if (resultPercentile != null && resultPercentile.getPercentiles() != null && resultPercentile.getPercentiles().length > 0) {
            this.configurationProperties.setPercentilesFromConfig(resultPercentile.getPercentiles());
        } else if (resultPercentile == null || resultPercentile.getPercentiles() != null || !resultPercentile.isDisabled()) {
            Double[] percentiles = new Double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
            this.configurationProperties.setPercentilesFromConfig(percentiles);
        }
        if (computedBuckets != null && computedBuckets.size() != 0) {
            resultBuckets = MetricsCustomBuckets.matches(computedBuckets, metricName);
        }
        if (resultBuckets != null && resultBuckets.getBuckets() != null && resultBuckets.getBuckets().length > 0) {
            this.configurationProperties.setBucketValuesFromConfig(resultBuckets.getBuckets());
        }
        this.reservoir.setConfigAdapter(this.configurationProperties);
    }

    private Collection<MetricsCustomBuckets> processHistogramBucketMap(String appName) {
        Config config = MetricUtils.getConfigProvider();
        if (config != null) {
            Optional<String> customBuckets = config.getOptionalValue("mp.metrics.distribution.histogram.buckets", String.class);
            return customBuckets.isPresent() ? MetricsConfigParserUtil.parseHistogramBuckets(customBuckets.get()) : null;
        }
        return null;
    }
}

