/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import fish.payara.microprofile.metrics.impl.CounterImpl;
import fish.payara.microprofile.metrics.impl.HistogramImpl;
import fish.payara.microprofile.metrics.impl.MetricRegistrationListener;
import fish.payara.microprofile.metrics.impl.MetricsCustomBuckets;
import fish.payara.microprofile.metrics.impl.MetricsCustomPercentiles;
import fish.payara.microprofile.metrics.impl.TimerImpl;
import jakarta.enterprise.inject.Vetoed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
public class MetricRegistryImpl
implements MetricRegistry {
    private static final Logger LOGGER = Logger.getLogger(MetricRegistryImpl.class.getName());
    private final String scope;
    private final ConcurrentMap<String, MetricFamily<?>> metricsFamiliesByName = new ConcurrentHashMap();
    private final Clock clock;
    private final List<MetricRegistrationListener> listeners = new ArrayList<MetricRegistrationListener>();
    public static final String METRIC_PERCENTILES_PROPERTY = "mp.metrics.distribution.percentiles";
    public static final String METRIC_HISTOGRAM_BUCKETS_PROPERTY = "mp.metrics.distribution.histogram.buckets";
    public static final String METRIC_TIMER_BUCKETS_PROPERTY = "mp.metrics.distribution.timer.buckets";
    private Map<String, Collection<MetricsCustomPercentiles>> percentilesConfigMap = new HashMap<String, Collection<MetricsCustomPercentiles>>();
    private Map<String, Collection<MetricsCustomBuckets>> histogramBucketsConfigMap = new HashMap<String, Collection<MetricsCustomBuckets>>();
    private Map<String, Collection<MetricsCustomBuckets>> timerBucketsConfigMap = new HashMap<String, Collection<MetricsCustomBuckets>>();

    public MetricRegistryImpl() {
        this.scope = null;
        this.clock = Clock.defaultClock();
    }

    public MetricRegistryImpl(String registryScope) {
        this(registryScope, Clock.defaultClock());
    }

    public MetricRegistryImpl(String type, Clock clock) {
        this.scope = type;
        this.clock = clock;
    }

    public MetricRegistryImpl addListener(MetricRegistrationListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public Counter counter(String name) {
        return this.findMetricOrCreate(name, Counter.class.getTypeName(), new CounterImpl(), new Tag[0]);
    }

    @Override
    public Counter counter(Metadata metadata) {
        return (Counter)this.findMetricOrCreate(metadata, Counter.class.getTypeName(), new Tag[0]);
    }

    @Override
    public Counter counter(String name, Tag ... tags) {
        return this.findMetricOrCreate(name, Counter.class.getTypeName(), new CounterImpl(), tags);
    }

    @Override
    public Counter counter(Metadata metadata, Tag ... tags) {
        return (Counter)this.findMetricOrCreate(metadata, Counter.class.getTypeName(), tags);
    }

    @Override
    public Counter counter(MetricID metricID) {
        return this.findMetricOrCreate(metricID.getName(), Counter.class.getTypeName(), new CounterImpl(), metricID.getTagsAsArray());
    }

    @Override
    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T object, Function<T, R> func, Tag ... tags) {
        return this.gauge(metadata, () -> (Number)func.apply(object), tags);
    }

    @Override
    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        return this.gauge(metricID.getName(), supplier, metricID.getTagsAsArray());
    }

    @Override
    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T object, Function<T, R> func) {
        return this.gauge(metricID, () -> (Number)func.apply(object));
    }

    @Override
    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> supplier, Tag ... tags) {
        return this.findMetricOrCreate(metadata, Gauge.class.getTypeName(), MetricRegistryImpl.createGauge(supplier), tags);
    }

    @Override
    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> supplier, Tag ... tags) {
        return this.findMetricOrCreate(name, Gauge.class.getTypeName(), MetricRegistryImpl.createGauge(supplier), tags);
    }

    private static <T extends Number> Gauge<T> createGauge(Supplier<T> supplier) {
        return supplier instanceof Gauge ? (Gauge<Number>)((Object)supplier) : () -> (Number)supplier.get();
    }

    @Override
    public <T, R extends Number> Gauge<R> gauge(String name, T object, Function<T, R> func, Tag ... tags) {
        return this.gauge(name, () -> (Number)func.apply(object), tags);
    }

    @Override
    public Histogram histogram(String name, Tag ... tags) {
        return this.findMetricOrCreate(name, Histogram.class.getTypeName(), new HistogramImpl(name, this.percentilesConfigMap, this.histogramBucketsConfigMap), tags);
    }

    @Override
    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.findMetricOrCreate(metadata, Histogram.class.getTypeName(), new HistogramImpl(metadata.getName(), this.percentilesConfigMap, this.histogramBucketsConfigMap), tags);
    }

    @Override
    public Histogram histogram(String name) {
        return this.findMetricOrCreate(name, Histogram.class.getTypeName(), new HistogramImpl(name, this.percentilesConfigMap, this.histogramBucketsConfigMap), new Tag[0]);
    }

    @Override
    public Histogram histogram(Metadata metadata) {
        return (Histogram)this.findMetricOrCreate(metadata, Histogram.class.getTypeName(), new Tag[0]);
    }

    @Override
    public Histogram histogram(MetricID metricID) {
        return this.findMetricOrCreate(metricID.getName(), Histogram.class.getTypeName(), new HistogramImpl(metricID.getName(), this.percentilesConfigMap, this.histogramBucketsConfigMap), metricID.getTagsAsArray());
    }

    @Override
    public Timer timer(String name, Tag ... tags) {
        return this.findMetricOrCreate(name, Timer.class.getTypeName(), null, tags);
    }

    @Override
    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.findMetricOrCreate(metadata, Timer.class.getTypeName(), (Metric)null, tags);
    }

    @Override
    public Timer timer(String name) {
        return this.findMetricOrCreate(name, Timer.class.getTypeName(), null, new Tag[0]);
    }

    @Override
    public Timer timer(Metadata metadata) {
        return (Timer)this.findMetricOrCreate(metadata, Timer.class.getTypeName(), new Tag[0]);
    }

    @Override
    public Timer timer(MetricID metricID) {
        return this.findMetricOrCreate(metricID.getName(), Timer.class.getTypeName(), null, metricID.getTagsAsArray());
    }

    @Override
    public Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, Counter.class);
    }

    @Override
    public Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, Gauge.class);
    }

    @Override
    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    @Override
    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    @Override
    public Metric getMetric(MetricID metricID) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(metricID.getName());
        return family == null ? null : (Metric)family.get(metricID);
    }

    @Override
    public SortedSet<MetricID> getMetricIDs() {
        TreeSet<MetricID> ids = new TreeSet<MetricID>();
        for (MetricFamily e : this.metricsFamiliesByName.values()) {
            ids.addAll(e.metrics.keySet());
        }
        return ids;
    }

    @Override
    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metricsFamiliesByName.keySet());
    }

    @Override
    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.findMetrics(Gauge.class, filter);
    }

    @Override
    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.findMetrics(Counter.class, filter);
    }

    @Override
    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.findMetrics(Histogram.class, filter);
    }

    @Override
    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.findMetrics(Timer.class, filter);
    }

    @Override
    public Map<MetricID, Metric> getMetrics() {
        return this.findMetrics((id, metric) -> true);
    }

    @Override
    public Map<String, Metadata> getMetadata() {
        return this.metricsFamiliesByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MetricFamily)e.getValue()).metadata));
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean remove(String name) {
        return this.metricsFamiliesByName.remove(name) != null;
    }

    @Override
    public boolean remove(MetricID metricID) {
        AtomicBoolean removed = new AtomicBoolean();
        this.metricsFamiliesByName.computeIfPresent(metricID.getName(), (name, family) -> {
            if (family.remove(metricID)) {
                removed.set(true);
            }
            return family.metrics.isEmpty() ? null : family;
        });
        return removed.get();
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        if (filter == MetricFilter.ALL) {
            this.metricsFamiliesByName.clear();
        }
        for (MetricFamily family : this.metricsFamiliesByName.values()) {
            for (Map.Entry entry : family.metrics.entrySet()) {
                if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
                this.remove((MetricID)entry.getKey());
            }
        }
    }

    private <T extends Metric> SortedMap<MetricID, T> findMetrics(Class<T> metricClass, MetricFilter filter) {
        return this.findMetrics((id, metric) -> metricClass.isInstance(metric) && filter.matches(id, metric));
    }

    private <T extends Metric> SortedMap<MetricID, T> findMetrics(MetricFilter filter) {
        TreeMap<MetricID, Metric> matches = new TreeMap<MetricID, Metric>();
        for (MetricFamily family : this.metricsFamiliesByName.values()) {
            for (Map.Entry entry : family.metrics.entrySet()) {
                if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
                matches.put((MetricID)entry.getKey(), (Metric)entry.getValue());
            }
        }
        return matches;
    }

    private <T extends Metric> T findMetricOrCreate(String name, String typeName, T metric, Tag ... tags) {
        MetricRegistryImpl.checkNameIsNotNullOrEmpty(name);
        Metadata metadata = null;
        metadata = Timer.class.getTypeName().equals(typeName) ? Metadata.builder().withName(name).withUnit("seconds").build() : Metadata.builder().withName(name).build();
        return this.findMetricOrCreate(metadata, true, typeName, metric, tags);
    }

    private <T extends Metric> T findMetricOrCreate(Metadata metadata, String typeName, Tag ... tags) {
        return this.findMetricOrCreate(metadata, typeName, (T)null, tags);
    }

    private <T extends Metric> T findMetricOrCreate(Metadata metadata, String typeName, T metric, Tag ... tags) {
        return this.findMetricOrCreate(MetricRegistryImpl.withType(metadata), false, typeName, metric, tags);
    }

    private <T extends Metric> T findMetricOrCreate(Metadata metadata, boolean useExistingMetadata, String metricType, T metric, Tag ... tags) {
        MetricRegistryImpl.validateTags(tags);
        MetricID metricID = new MetricID(metadata.getName(), tags);
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(metricID.getName());
        if (family == null) {
            return this.register(metadata, useExistingMetadata, metricType, metric, tags);
        }
        Object existing = family.get(metricID);
        if (existing == null) {
            this.checkSameType(metricID, metricType, family.metrics);
            if (useExistingMetadata && this.hasSameTagNames(metricID) || this.hasSameTagNames(metricID)) {
                return this.register(metadata, useExistingMetadata, metricType, metric, tags);
            }
            throw new IllegalArgumentException(String.format("Tried to lookup a metric id with conflicting tags,  %s", metricID.toString()));
        }
        return existing;
    }

    private boolean hasSameTagNames(MetricID metricID) {
        Optional<MetricID> optSameNameDifferentTags = this.getMetrics(metricID.getName()).keySet().stream().filter(m -> m.getTags().size() != metricID.getTags().size()).findAny();
        if (optSameNameDifferentTags.isPresent()) {
            return false;
        }
        Optional<MetricID> optSameNameSameTagsDifferentContent = this.getMetrics(metricID.getName()).keySet().stream().filter(m -> m.getTags().size() == metricID.getTags().size()).filter(m -> !m.getTagsAsString().equals(metricID.getTagsAsString())).findAny();
        if (optSameNameSameTagsDifferentContent.isPresent()) {
            List metrics = this.getMetrics(metricID.getName()).keySet().stream().filter(m -> m.getTags().size() == metricID.getTags().size()).collect(Collectors.toList());
            for (Tag t : metricID.getTagsAsArray()) {
                Optional<MetricID> result = metrics.stream().filter(m -> m.getTags().containsKey(t.getTagName())).findAny();
                if (!result.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static void validateTags(Tag[] tags) {
        Optional<Tag> result;
        if (tags != null && (result = Arrays.stream(tags).filter(t -> t.getTagName().equals("mp_scope") || t.getTagName().equals("mp_app")).findFirst()).isPresent()) {
            throw new IllegalArgumentException("invalid tags: " + tags + ", tags must not contain following reserved tag names: mp_scope and mp_app");
        }
    }

    public <T extends Metric> T register(Metadata metadata, String metricType, T metric, Tag ... tags) throws IllegalArgumentException {
        return this.register(metadata, false, metricType, metric, tags);
    }

    private <T extends Metric> T register(Metadata metadata, boolean useExistingMetadata, String metricType, T metric, Tag ... tags) {
        Metadata existingMetadata;
        String name = metadata.getName();
        MetricRegistryImpl.checkNameIsNotNullOrEmpty(name);
        if (useExistingMetadata && (existingMetadata = this.getMetadata(name)) != null) {
            metadata = existingMetadata;
        }
        Metadata newMetadata = metadata;
        Metric newMetric = metric != null ? metric : this.createMetricInstance(newMetadata, metricType);
        MetricFamily family = this.metricsFamiliesByName.computeIfAbsent(name, key -> new MetricFamily(newMetadata));
        MetricID metricID = new MetricID(name, tags);
        if (family.metadata != newMetadata) {
            this.checkSameType(metricID, metricType, family.metrics);
            MetricRegistryImpl.checkReusableMetadata(name, newMetadata, family.metadata);
        }
        Metric current = family.metrics.computeIfAbsent(metricID, key -> newMetric);
        this.notifyRegistrationListeners(metricID);
        return (T)current;
    }

    private void notifyRegistrationListeners(MetricID metricID) {
        for (MetricRegistrationListener l : this.listeners) {
            try {
                l.onRegistration(metricID, this.scope);
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "Registration listener threw exception:", ex);
            }
        }
    }

    private static void checkNameIsNotNullOrEmpty(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Metric name must not be null or empty");
        }
    }

    private static void checkReusableMetadata(String name, Metadata newMetadata, Metadata existingMetadata) {
        if (!existingMetadata.equals(newMetadata)) {
            throw new IllegalArgumentException(String.format("Metadata ['%s'] already registered, does not match provided ['%s']", existingMetadata.toString(), newMetadata.toString()));
        }
    }

    public <T extends Metric> void checkSameType(MetricID metricID, String metricType, ConcurrentMap<MetricID, ?> metrics) {
        Optional<Object> optResult = Optional.empty();
        Optional<Class[]> interfacesArrayOpt = metrics.values().stream().map(c -> c.getClass().getInterfaces()).findAny();
        if (interfacesArrayOpt.isPresent()) {
            optResult = Arrays.stream(interfacesArrayOpt.get()).filter(i -> !i.getTypeName().contains(Supplier.class.getName())).filter(i -> !i.getTypeName().equals(metricType)).findAny();
        }
        if (optResult.isPresent()) {
            throw new IllegalArgumentException(String.format("Metric ['%s'] type['%s'] does not match with existing type['%s']", metricID.getName(), this.getMetricClassName(metricType), this.getMetricClassName(((Class)optResult.get()).getName())));
        }
    }

    public String getMetricClassName(String name) {
        String[] parts = name.split("\\.");
        if (parts != null && parts.length > 0) {
            return parts[parts.length - 1];
        }
        return name;
    }

    private Metric createMetricInstance(Metadata metadata, String metricType) {
        String name = MetricRegistry.name(metadata.getName(), new String[0]);
        if (Counter.class.getName().equals(metricType)) {
            return new CounterImpl();
        }
        if (Gauge.class.getName().equals(metricType)) {
            throw new IllegalArgumentException(String.format("Unsupported operation for Gauge ['%s']", name));
        }
        if (Histogram.class.getName().equals(metricType)) {
            return new HistogramImpl();
        }
        if (Timer.class.getName().equals(metricType)) {
            return new TimerImpl(name, this.percentilesConfigMap, this.timerBucketsConfigMap, this.clock);
        }
        throw new IllegalArgumentException("Invalid metric type : " + metricType);
    }

    public <T extends Metric> T getMetricCustomScope(MetricID metricID, Class<T> ofType, String scope) {
        return this.getMetric(metricID, ofType);
    }

    @Override
    public <T extends Metric> T getMetric(MetricID metricID, Class<T> ofType) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(metricID.getName());
        if (family == null) {
            return null;
        }
        Object metric = family.get(metricID);
        if (metric != null && !ofType.isAssignableFrom(metric.getClass())) {
            throw new IllegalArgumentException("Invalid metric type : " + ofType);
        }
        if (metric == null) {
            metric = this.verifyMetrics(metricID, family);
        }
        return metric;
    }

    public <T extends Metric> T verifyMetrics(MetricID metricID, MetricFamily<?> family) {
        Optional<MetricID> metricOptional;
        T m = null;
        List metricList = this.getMetrics().entrySet().stream().filter(e -> ((MetricID)e.getKey()).getName().equals(metricID.getName())).filter(e -> ((MetricID)e.getKey()).getTags().size() == metricID.getTags().size()).map(e -> (MetricID)e.getKey()).collect(Collectors.toList());
        if (metricList.size() > 0 && (metricOptional = metricList.stream().filter(l -> l.getTags().equals(metricID.getTags())).findAny()).isPresent()) {
            m = (T)family.get(metricOptional.get());
        }
        return m;
    }

    @Override
    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.findMetrics((metricID, metric) -> filter.matches(metricID, metric) && ofType.isAssignableFrom(metric.getClass()));
    }

    @Override
    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        return this.findMetrics(filter);
    }

    @Override
    public Metadata getMetadata(String name) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(name);
        return family == null ? null : family.metadata;
    }

    public Set<MetricID> getMetricsIDs(String name) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(name);
        return family == null ? Collections.emptySet() : Collections.unmodifiableSet(family.metrics.keySet());
    }

    public Map<MetricID, Metric> getMetrics(String name) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(name);
        return family == null ? Collections.emptyMap() : Collections.unmodifiableMap(family.metrics);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry family : this.metricsFamiliesByName.entrySet()) {
            str.append((String)family.getKey()).append(": ").append(((MetricFamily)family.getValue()).metadata).append('\n');
            for (Map.Entry entry : ((MetricFamily)family.getValue()).metrics.entrySet()) {
                str.append('\t').append(entry.getKey()).append(": ").append(MetricRegistryImpl.toString((Metric)entry.getValue())).append('\n');
            }
        }
        return str.toString();
    }

    private static String toString(Metric metric) {
        if (MetricRegistryImpl.isLambda(metric) && metric instanceof Gauge) {
            return "Gauge[" + ((Gauge)metric).getValue() + "]";
        }
        return metric.toString();
    }

    public static boolean isLambda(Object obj) {
        return obj.getClass().toString().contains("$$Lambda$");
    }

    private static Metadata withType(Metadata metadata) {
        return Metadata.builder(metadata).build();
    }

    static final class MetricFamily<T extends Metric> {
        final Metadata metadata;
        final ConcurrentMap<MetricID, T> metrics = new ConcurrentHashMap<MetricID, T>();

        MetricFamily(Metadata metadata) {
            this.metadata = metadata;
        }

        boolean remove(MetricID metricID) {
            return this.metrics.remove(metricID) != null;
        }

        T get(MetricID metricID) {
            return (T)((Metric)this.metrics.get(metricID));
        }
    }
}

