/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import fish.payara.microprofile.metrics.MetricUnitsUtils;
import fish.payara.microprofile.metrics.impl.HistogramImpl;
import fish.payara.microprofile.metrics.impl.TimerImpl;
import fish.payara.microprofile.metrics.impl.WeightedSnapshot;
import fish.payara.microprofile.metrics.writer.MetricExporter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Sampling;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class OpenMetricsExporter
implements MetricExporter {
    protected final String scope;
    protected final PrintWriter out;
    protected final Set<String> typeWrittenByGlobalName;
    protected final Set<String> helpWrittenByGlobalName;
    private static final String GC_TOTAL_ID = "gc_total";
    private static final String GC_TIME_SECONDS_TOTAL_ID = "gc_time_seconds_total";
    private static final BigDecimal NANOS_IN_SECOND = BigDecimal.valueOf(1000000000L);

    public OpenMetricsExporter(Writer out) {
        this(null, out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out), new HashSet<String>(), new HashSet<String>());
    }

    protected OpenMetricsExporter(String scope, PrintWriter out, Set<String> typeWrittenByGlobalName, Set<String> helpWrittenByGlobalName) {
        this.scope = scope;
        this.out = out;
        this.typeWrittenByGlobalName = typeWrittenByGlobalName;
        this.helpWrittenByGlobalName = helpWrittenByGlobalName;
    }

    @Override
    public MetricExporter in(String scope, boolean asNode) {
        return new OpenMetricsExporter(scope, this.out, this.typeWrittenByGlobalName, this.helpWrittenByGlobalName);
    }

    @Override
    public void exportComplete() {
    }

    @Override
    public void export(MetricID metricID, Counter counter, Metadata metadata) {
        String total = this.globalName(metricID, metadata, "_total");
        this.appendTYPE(total, OpenMetricsType.counter);
        this.appendHELP(total, metadata);
        this.appendValue(total, metricID.getTagsAsArray(), MetricUnitsUtils.scaleToBaseUnit((Number)counter.getCount(), metadata));
    }

    @Override
    public void export(MetricID metricID, Gauge<?> gauge, Metadata metadata) {
        Object value = null;
        try {
            value = gauge.getValue();
        }
        catch (IllegalStateException ex) {
            return;
        }
        if (!(value instanceof Number)) {
            LOGGER.log(Level.FINER, "Skipping OpenMetrics output for Gauge: {0} of type {1}", new Object[]{metricID, value.getClass()});
            return;
        }
        String valueName = this.globalName(metricID, metadata);
        this.appendTYPE(valueName, OpenMetricsType.gauge);
        this.appendHELP(valueName, metadata);
        this.appendValue(valueName, metricID.getTagsAsArray(), MetricUnitsUtils.scaleToBaseUnit((Number)value, metadata));
    }

    @Override
    public void export(MetricID metricID, Histogram histogram, Metadata metadata) {
        this.exportSampling(metricID, histogram, histogram::getCount, histogram::getSum, metadata);
    }

    private void exportSampling(MetricID metricID, Sampling sampling, LongSupplier count, Supplier<Number> sum, Metadata metadata) {
        Tag[] tags = metricID.getTagsAsArray();
        Snapshot snapshot = sampling.getSnapshot();
        String mean = this.globalName(metricID, metadata, "_mean");
        this.appendTYPE(mean, OpenMetricsType.gauge);
        this.appendValue(mean, tags, MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getMean(), metadata));
        String max = this.globalName(metricID, metadata, "_max");
        this.appendTYPE(max, OpenMetricsType.gauge);
        this.appendHELP(max, metadata);
        this.appendValue(max, tags, MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getMax(), metadata));
        String summary = this.globalName(metricID, metadata);
        this.appendHELP(summary, metadata);
        Snapshot.PercentileValue[] percentileValues = snapshot.percentileValues();
        if (snapshot instanceof WeightedSnapshot) {
            WeightedSnapshot w = (WeightedSnapshot)snapshot;
            if (w.getConfigAdapter() != null) {
                if (w.bucketValues() != null && w.bucketValues().length > 0) {
                    this.appendTYPE(summary, OpenMetricsType.histogram);
                    this.printCustomPercentile(percentileValues, summary, tags, metadata);
                    this.printBuckets(snapshot.bucketValues(), this.globalName(metricID, metadata, "_bucket"), tags, metadata, sampling, count);
                } else {
                    this.appendTYPE(summary, OpenMetricsType.summary);
                    this.printCustomPercentile(percentileValues, summary, tags, metadata);
                }
            } else {
                this.appendTYPE(summary, OpenMetricsType.summary);
                this.printMedian(percentileValues, summary, tags, metadata);
            }
        } else {
            this.appendTYPE(summary, OpenMetricsType.summary);
            this.printMedian(percentileValues, summary, tags, metadata);
        }
        this.appendValue(this.globalName(metricID, metadata, "_count"), tags, (double)count.getAsLong());
        this.appendValue(this.globalName(metricID, metadata, "_sum"), tags, sum.get().doubleValue());
    }

    public void printCustomPercentile(Snapshot.PercentileValue[] pencentileValues, String summary, Tag[] tags, Metadata metadata) {
        for (Snapshot.PercentileValue value : pencentileValues) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", Double.toString(value.getPercentile()), tags), value.getValue());
        }
    }

    public void printBuckets(Snapshot.HistogramBucket[] buckets, String summary, Tag[] tags, Metadata metadata, Sampling sampling, LongSupplier count) {
        if (sampling != null && sampling instanceof HistogramImpl) {
            for (Snapshot.HistogramBucket b : buckets) {
                this.appendValue(summary, OpenMetricsExporter.tags("le", Double.toString(b.getBucket()), tags), (double)this.evaluateBucketCount(b.getBucket(), sampling));
            }
        } else {
            List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
            Iterator iterator = bucketsList.iterator();
            while (iterator.hasNext()) {
                long b = (Long)iterator.next();
                double seconds = (double)b / 1000.0;
                this.appendValue(summary, OpenMetricsExporter.tags("le", Double.toString(seconds), tags), (double)this.evaluateBucketCount(seconds, sampling));
            }
        }
        this.appendValue(summary, OpenMetricsExporter.tags("le", "+Inf", tags), (double)count.getAsLong());
    }

    public long evaluateBucketCount(double bucket, Sampling sampling) {
        Snapshot snapshot = sampling.getSnapshot();
        if (snapshot instanceof WeightedSnapshot) {
            WeightedSnapshot weightedSnapshot = (WeightedSnapshot)snapshot;
            double[] conversionArray = null;
            long[] values = weightedSnapshot.getValues();
            conversionArray = sampling instanceof TimerImpl ? Arrays.stream(values).mapToDouble(l -> (double)l / 1.0E9).toArray() : Arrays.stream(values).mapToDouble(l -> Long.valueOf(l).doubleValue()).toArray();
            return Arrays.stream(conversionArray).filter(s -> s <= bucket).count();
        }
        return 0L;
    }

    public void printMedian(Snapshot.PercentileValue[] pencentileValues, String summary, Tag[] tags, Metadata metadata) {
        Optional<Snapshot.PercentileValue> median = Arrays.stream(pencentileValues).filter(p -> p.getPercentile() == 0.5).findFirst();
        Optional<Snapshot.PercentileValue> percentile75th = Arrays.stream(pencentileValues).filter(p -> p.getPercentile() == 0.75).findFirst();
        Optional<Snapshot.PercentileValue> percentile95th = Arrays.stream(pencentileValues).filter(p -> p.getPercentile() == 0.95).findFirst();
        Optional<Snapshot.PercentileValue> percentile98th = Arrays.stream(pencentileValues).filter(p -> p.getPercentile() == 0.98).findFirst();
        Optional<Snapshot.PercentileValue> percentile99th = Arrays.stream(pencentileValues).filter(p -> p.getPercentile() == 0.99).findFirst();
        Optional<Snapshot.PercentileValue> percentile999th = Arrays.stream(pencentileValues).filter(p -> p.getPercentile() == 0.999).findFirst();
        if (median.isPresent()) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.5", tags), MetricUnitsUtils.scaleToBaseUnit((Number)median.get().getValue(), metadata));
        }
        if (percentile75th.isPresent()) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.75", tags), MetricUnitsUtils.scaleToBaseUnit((Number)percentile75th.get().getValue(), metadata));
        }
        if (percentile95th.isPresent()) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.95", tags), MetricUnitsUtils.scaleToBaseUnit((Number)percentile95th.get().getValue(), metadata));
        }
        if (percentile98th.isPresent()) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.98", tags), MetricUnitsUtils.scaleToBaseUnit((Number)percentile98th.get().getValue(), metadata));
        }
        if (percentile99th.isPresent()) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.99", tags), MetricUnitsUtils.scaleToBaseUnit((Number)percentile99th.get().getValue(), metadata));
        }
        if (percentile999th.isPresent()) {
            this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.999", tags), MetricUnitsUtils.scaleToBaseUnit((Number)percentile999th.get().getValue(), metadata));
        }
    }

    @Override
    public void export(MetricID metricID, Timer timer, Metadata metadata) {
        this.exportSampling(metricID, timer, timer::getCount, () -> OpenMetricsExporter.toSeconds(timer.getElapsedTime()), metadata);
    }

    protected void appendTYPE(String globalName, OpenMetricsType type) {
        if (this.typeWrittenByGlobalName.contains(globalName)) {
            return;
        }
        this.typeWrittenByGlobalName.add(globalName);
        this.out.append("# TYPE ").append(globalName).append(' ').append(type.name()).append('\n');
    }

    protected void appendHELP(String globalName, Metadata metadata) {
        if (!this.helpWrittenByGlobalName.contains(globalName)) {
            this.helpWrittenByGlobalName.add(globalName);
        }
        Optional<String> description = metadata.description();
        this.out.append("# HELP ").append(globalName).append(' ').append(description.isPresent() ? (CharSequence)description.get() : "").append('\n');
    }

    protected void appendValue(String globalName, Tag[] tags, Number value) {
        this.out.append(globalName);
        this.out.append(OpenMetricsExporter.tagsToString(tags));
        if (globalName.equals(GC_TOTAL_ID) || globalName.equals(GC_TIME_SECONDS_TOTAL_ID)) {
            this.out.append(' ').append(value.toString()).append('\n');
        } else {
            this.out.append(' ').append(value == null ? "NaN" : this.roundValue(value)).append('\n');
        }
    }

    private void appendValue(String globalName, Tag[] tags, long value) {
        this.appendValue(globalName, tags, (Number)value);
    }

    private void appendValue(String globalName, Tag[] tags, double value) {
        this.appendValue(globalName, tags, (Number)value);
    }

    protected String roundValue(Number value) {
        String valString = value.toString();
        if (valString.endsWith("000000001")) {
            valString = valString.substring(0, valString.length() - 9);
        }
        if (valString.contains("000000001E")) {
            valString = valString.replace("000000001E", "E");
        }
        return valString;
    }

    protected static String tagsToString(Tag[] tags) {
        if (tags.length == 0) {
            return "";
        }
        Object result = "";
        result = (String)result + "{";
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                result = (String)result + ",";
            }
            result = (String)result + OpenMetricsExporter.sanitizeMetricName(tags[i].getTagName()) + "=\"" + OpenMetricsExporter.escapeTagValue(tags[i].getTagValue()) + "\"";
        }
        result = (String)result + "}";
        return result;
    }

    private String globalName(MetricID metricID, Metadata unit) {
        return this.globalName(metricID, "", unit, "");
    }

    private String globalName(MetricID metricID, String infix, Metadata unit) {
        return this.globalName(metricID, infix, unit, "");
    }

    private String globalName(MetricID metricID, Metadata unit, String suffix) {
        return this.globalName(metricID, "", unit, suffix);
    }

    private String globalName(MetricID metricID, String infix, Metadata metadata, String suffix) {
        String unit;
        if (!metadata.unit().isPresent()) {
            return this.globalName(metricID, infix + suffix);
        }
        switch (unit = metadata.getUnit()) {
            case "nanoseconds": 
            case "microseconds": 
            case "milliseconds": 
            case "seconds": 
            case "minutes": 
            case "hours": 
            case "days": {
                return this.globalName(metricID, infix + "_seconds" + suffix);
            }
            case "bits": 
            case "bytes": 
            case "kilobits": 
            case "megabits": 
            case "gigabits": 
            case "mebibits": 
            case "gibibits": 
            case "kilobytes": 
            case "megabytes": {
                return this.globalName(metricID, infix + "_bytes" + suffix);
            }
            case "percent": {
                return this.globalName(metricID, infix + "_ratio" + suffix);
            }
            case "per_second": {
                return this.globalName(metricID, infix + "_per_second" + suffix);
            }
            case "none": {
                return this.globalName(metricID, infix + suffix);
            }
        }
        return this.globalName(metricID, infix + "_" + unit + suffix);
    }

    private String globalName(MetricID metricID, String suffix) {
        String name = metricID.getName();
        return OpenMetricsExporter.sanitizeMetricName((String)(!suffix.isEmpty() && (name.endsWith(suffix) || name.contains(".total")) ? name : name + suffix));
    }

    private static CharSequence escapeTagValue(String name) {
        StringBuilder str = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\n') {
                str.append("\\n");
                continue;
            }
            if (c == '\\' || c == '\"') {
                str.append('\\');
            }
            str.append(c);
        }
        return str;
    }

    public static String sanitizeMetricName(String name) {
        String out = name.replaceAll("[^a-zA-Z0-9_]+", "_");
        return out.replaceAll(":_", ":");
    }

    private static Tag[] tags(String name, String value, Tag[] rest) {
        Tag tag = new Tag(name, value);
        if (rest.length == 0) {
            return new Tag[]{tag};
        }
        Tag[] res = Arrays.copyOf(rest, rest.length + 1);
        res[rest.length] = tag;
        return res;
    }

    private static Number toSeconds(Duration d) {
        if (d == null) {
            return null;
        }
        if (d.getNano() == 0) {
            return (double)d.getSeconds() / 1000.0;
        }
        BigDecimal nanos = BigDecimal.valueOf(d.getSeconds()).multiply(NANOS_IN_SECOND).add(BigDecimal.valueOf(d.getNano()));
        return nanos.divide(NANOS_IN_SECOND).doubleValue();
    }

    protected static enum OpenMetricsType {
        counter,
        gauge,
        summary,
        histogram;

    }
}

