/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc;

import com.sun.gjc.util.SQLTraceLogger;
import com.sun.logging.LogDomains;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;
import org.glassfish.internal.api.Globals;

public class RequestTracingListener
implements SQLTraceListener {
    private RequestTracingService requestTracing;
    private static final Logger logger = LogDomains.getLogger(SQLTraceLogger.class, (String)"javax.enterprise.resource.sqltrace");

    public RequestTracingListener() {
        try {
            this.requestTracing = (RequestTracingService)Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving Request Tracing service during initialisation of RequestTracingListener - NullPointerException");
        }
    }

    public void sqlTrace(SQLTraceRecord record) {
        RequestTraceSpanLog spanLog = this.constructJDBCSpanLog(record);
        if (this.requestTracing != null) {
            this.requestTracing.addSpanLog(spanLog);
        }
    }

    private RequestTraceSpanLog constructJDBCSpanLog(SQLTraceRecord record) {
        RequestTraceSpanLog spanLog = new RequestTraceSpanLog("jdbcContextEvent");
        spanLog.addLogEntry("Method Name", record.getMethodName());
        spanLog.addLogEntry("Parameters", Arrays.toString(record.getParams()));
        spanLog.addLogEntry("Pool Name", record.getPoolName());
        spanLog.addLogEntry("Thread ID", Long.toString(record.getThreadID()));
        spanLog.addLogEntry("Thread Name", record.getThreadName());
        spanLog.addLogEntry("Execution Time", Long.toString(record.getExecutionTime()));
        return spanLog;
    }
}

