/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm;

import fish.payara.security.api.CertificateCredential;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.credential.AbstractClearableCredential;
import java.security.cert.X509Certificate;

public class CertificateCredentialImpl
extends AbstractClearableCredential
implements CertificateCredential {
    private X509Certificate[] certificates;

    public CertificateCredentialImpl(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            throw new IllegalArgumentException("Certificates can't be empty.");
        }
        this.certificates = certs;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public CallerPrincipal getPrincipal() {
        return new CallerPrincipal(this.certificates[0].getIssuerX500Principal().getName("RFC2253"));
    }

    public void clearCredential() {
        this.certificates = null;
    }
}

