/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm.identitystores;

import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.auth.login.ClientCertificateLoginModule;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import fish.payara.security.api.CertificateCredential;
import fish.payara.security.realm.config.CertificateRealmIdentityStoreConfiguration;
import jakarta.enterprise.inject.Typed;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.glassfish.security.common.Group;

@Typed(value={CertificateRealmIdentityStore.class})
public class CertificateRealmIdentityStore
implements IdentityStore {
    private CertificateRealmIdentityStoreConfiguration configuration;
    public static final Class<CertificateRealm> REALM_CLASS = CertificateRealm.class;
    public static final Class<ClientCertificateLoginModule> REALM_LOGIN_MODULE_CLASS = ClientCertificateLoginModule.class;

    public void init(CertificateRealmIdentityStoreConfiguration configuration) {
        this.configuration = configuration;
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof CertificateCredential) {
            return CertificateRealmIdentityStore.validate((CertificateCredential)credential, this.configuration.getName());
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    public static CredentialValidationResult validate(CertificateCredential credential, String realmName) {
        try {
            Subject subject = CertificateRealmIdentityStore.login(credential, realmName);
            Set groups = subject.getPrincipals(Group.class).stream().map(g -> g.getName()).collect(Collectors.toSet());
            return new CredentialValidationResult(credential.getPrincipal(), groups);
        }
        catch (LoginException ex) {
            return CredentialValidationResult.INVALID_RESULT;
        }
    }

    private static Subject login(CertificateCredential credential, String realmName) {
        Subject subject = CertificateRealmIdentityStore.createSubjectWithCerts(credential.getCertificates());
        WebAndEjbToJaasBridge.doX500Login((Subject)subject, (String)realmName, null);
        return subject;
    }

    private static Subject createSubjectWithCerts(X509Certificate[] certificates) {
        Subject subject = new Subject();
        subject.getPublicCredentials().add(certificates[0].getSubjectX500Principal());
        subject.getPublicCredentials().add(Arrays.asList(certificates));
        return subject;
    }
}

