/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferInputStream;
import aQute.lib.io.ByteBufferOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;

public class TextActionImpl
extends ActionImpl {
    public TextActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public String getName() {
        return "Text Action";
    }

    @Override
    public ActionType getActionType() {
        return ActionType.TEXT;
    }

    @Override
    public String getAcceptExtension() {
        throw new UnsupportedOperationException("Text does not use this API");
    }

    @Override
    public boolean accept(String resourceName, File resourceFile) {
        return this.signatureRule.getTextSubstitutions(resourceName) != null;
    }

    @Override
    public ByteData apply(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        String outputName = inputName;
        this.setResourceNames(inputName, outputName);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBytes, 0, inputLength);
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(inputReader);
        ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputBytes.length);
        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        BufferedWriter writer = new BufferedWriter(outputWriter);
        try {
            this.transform(inputName, reader, writer);
        }
        catch (IOException e) {
            this.error("Failed to transform [ {} ]", e, inputName);
            return null;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            this.error("Failed to flush [ {} ]", e, inputName);
            return null;
        }
        if (!this.hasNonResourceNameChanges()) {
            return null;
        }
        byte[] outputBytes = outputStream.toByteArray();
        return new ByteData(inputName, outputBytes, 0, outputBytes.length);
    }

    protected void transform(String inputName, BufferedReader reader, BufferedWriter writer) throws IOException {
        String inputLine;
        while ((inputLine = reader.readLine()) != null) {
            String outputLine = this.replaceText(inputName, inputLine);
            if (outputLine == null) {
                outputLine = inputLine;
            } else {
                this.addReplacement();
            }
            writer.write(outputLine);
            writer.write(10);
        }
    }
}

