/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.theme;

import com.sun.webui.jsf.theme.JSFThemeContext;
import com.sun.webui.theme.ServletThemeContext;
import com.sun.webui.theme.ThemeContext;
import jakarta.faces.context.FacesContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class AdminguiThemeContext
extends ServletThemeContext {
    private static final Logger LOG = Logger.getLogger(AdminguiThemeContext.class.getName());
    public static final String THEME_NAME_KEY = "com.sun.webui.theme.DEFAULT_THEME";
    public static final String THEME_VERSION_KEY = "com.sun.webui.theme.DEFAULT_THEME_VERSION";
    private ThemeContext jsfThemeCtx = JSFThemeContext.getInstance((FacesContext)FacesContext.getCurrentInstance());

    protected AdminguiThemeContext(String themeName, String themeVersion) {
        super(AdminguiThemeContext.setThemeParams(themeName, themeVersion));
        this.jsfThemeCtx.setThemeServletContext("/theme");
    }

    public static synchronized ThemeContext getInstance(FacesContext context, String themeName, String themeVersion) {
        LOG.finest(() -> String.format("getInstance(context=%s, themeName=%s, themeVersion=%s)", context, themeName, themeVersion));
        Map map = context.getExternalContext().getApplicationMap();
        String themeKey = "com.sun.webui.theme.THEME_CONTEXT" + themeName + themeVersion;
        Object themeContext = (ThemeContext)map.get(themeKey);
        if (themeContext == null) {
            themeContext = new AdminguiThemeContext(themeName, themeVersion);
            map.put(themeKey, themeContext);
        }
        return themeContext;
    }

    public static synchronized ThemeContext getInstance(FacesContext context, Properties propMap) {
        Map map = context.getExternalContext().getApplicationMap();
        String themeName = (String)propMap.get(THEME_NAME_KEY);
        String themeVersion = (String)propMap.get(THEME_VERSION_KEY);
        String themeKey = "com.sun.webui.theme.THEME_CONTEXT" + themeName + themeVersion;
        LOG.finest(() -> "theme context key: " + themeKey);
        Object themeContext = (ThemeContext)map.get(themeKey);
        if (themeContext == null) {
            themeContext = new AdminguiThemeContext(themeName, themeVersion);
            map.put(themeKey, themeContext);
        }
        return themeContext;
    }

    private static Map<String, String> setThemeParams(String theme, String version) {
        LOG.finest(() -> String.format("setThemeParams(theme=%s, version=%s)", theme, version));
        HashMap<String, String> map = new HashMap<String, String>();
        String themeForMap = theme == null ? "suntheme" : theme;
        map.put(THEME_NAME_KEY, themeForMap);
        String versionForMap = version == null ? "4.2" : version;
        map.put(THEME_VERSION_KEY, versionForMap);
        return map;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.jsfThemeCtx.getDefaultClassLoader();
    }

    public void setDefaultClassLoader(ClassLoader classLoader) {
        this.jsfThemeCtx.setDefaultClassLoader(classLoader);
    }

    public String getRequestContextPath() {
        return this.jsfThemeCtx.getRequestContextPath();
    }

    public void setRequestContextPath(String path) {
        this.jsfThemeCtx.setRequestContextPath(path);
    }

    public String getResourcePath(String path) {
        return this.jsfThemeCtx.getResourcePath(path);
    }
}

