/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyPlaceholderHelper {
    public static final String ENV_REGEX = "([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)";
    private final Pattern pattern;
    private final Map<String, String> properties;
    private final int MAX_SUBSTITUTION_DEPTH = 100;

    public PropertyPlaceholderHelper(Map<String, String> properties, String regex) {
        this.properties = properties;
        this.pattern = Pattern.compile(regex);
    }

    public String getPropertyValue(String key) {
        return this.properties.get(key);
    }

    public Properties replacePropertiesPlaceholder(Properties properties) {
        Properties p = new Properties();
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            p.setProperty(key, this.replacePlaceholder(properties.getProperty(key)));
        }
        return p;
    }

    public String replacePlaceholder(String value) {
        if (value != null && value.indexOf(36) != -1) {
            int i;
            String origValue = value;
            Matcher m = this.getPattern().matcher(value);
            for (i = 0; m.find() && i < 100; ++i) {
                String matchValue = m.group(2).trim();
                String newValue = this.getPropertyValue(matchValue);
                if (newValue == null) continue;
                value = m.replaceFirst(Matcher.quoteReplacement(m.group(1) + newValue + m.group(3)));
                m.reset(value);
            }
            if (i >= 100) {
                Logger.getLogger(PropertyPlaceholderHelper.class.getName()).log(Level.SEVERE, "System property substitution exceeded maximum of {0}", 100);
            }
        }
        return value;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

