/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.Hashtable;
import java.util.List;

public class ShutdownHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ShutdownHandler.getDEBUG();

    public ShutdownHandler(AdminDataHandler parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        Packet reply;
        boolean failover;
        Integer time;
        boolean shouldRestart;
        block21: {
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": Shutting down broker: " + cmd_props);
            }
            shouldRestart = true;
            time = null;
            Boolean kill = (Boolean)cmd_props.get("JMQKill");
            Boolean noFailover = (Boolean)cmd_props.get("JMQNoFailover");
            failover = noFailover == null || noFailover == false;
            time = (Integer)cmd_props.get("JMQTime");
            Boolean restart = (Boolean)cmd_props.get("JMQRestart");
            boolean bl = shouldRestart = restart != null && restart != false;
            if (shouldRestart) {
                failover = false;
            }
            reply = new Packet(con.useDirectBuffers());
            reply.setPacketType(5);
            if (Broker.isInProcess() && !shouldRestart && this.hasDirectConnections()) {
                String error = this.rb.getString("B3220");
                ShutdownHandler.setProperties(reply, 39, 500, error);
                this.parent.sendReply(con, cmd_msg, reply);
                return true;
            }
            if (Broker.isInProcess() && shouldRestart) {
                String error = this.rb.getString("B3253");
                ShutdownHandler.setProperties(reply, 39, 500, error);
                this.parent.sendReply(con, cmd_msg, reply);
                return true;
            }
            if (kill != null && kill.booleanValue()) {
                Broker.getBroker().removeBrokerShutdownHook();
                System.exit(1);
            }
            Globals.getAuditSession().brokerOperation(con.getUserName(), con.remoteHostString(), shouldRestart ? "broker restart" : "broker shutdown");
            try {
                Globals.getServiceManager().stopNewConnections(0);
                if (time != null && time != 0) break block21;
                Globals.getServiceManager().stopNewConnections(1);
            }
            catch (Exception ex) {
                try {
                    this.logger.logStack(16, "B3100", "unable to shutdown", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    ShutdownHandler.setProperties(reply, 39, 200, null);
                    this.parent.sendReply(con, cmd_msg, reply);
                    if (con instanceof IMQBasicConnection) {
                        IMQBasicConnection ipCon = (IMQBasicConnection)con;
                        ipCon.flushControl(1000L);
                    }
                    BrokerStateHandler bsh = Globals.getBrokerStateHandler();
                    if (time == null || time == 0) {
                        BrokerStateHandler.setShuttingDown(true);
                        bsh.prepareShutdown(failover, false);
                    }
                    this.waitForHandlersToComplete(20);
                    if (shouldRestart) {
                        this.logger.log(8, "B1094");
                    } else {
                        this.logger.log(8, "B1093");
                    }
                    bsh.initiateShutdown("admin", (time == null ? 0L : time.longValue()) * 1000L, failover, shouldRestart ? BrokerStateHandler.getRestartCode() : 0, true);
                    throw throwable;
                }
                ShutdownHandler.setProperties(reply, 39, 200, null);
                this.parent.sendReply(con, cmd_msg, reply);
                if (con instanceof IMQBasicConnection) {
                    IMQBasicConnection ipCon = (IMQBasicConnection)con;
                    ipCon.flushControl(1000L);
                }
                BrokerStateHandler bsh = Globals.getBrokerStateHandler();
                if (time == null || time == 0) {
                    BrokerStateHandler.setShuttingDown(true);
                    bsh.prepareShutdown(failover, false);
                }
                this.waitForHandlersToComplete(20);
                if (shouldRestart) {
                    this.logger.log(8, "B1094");
                } else {
                    this.logger.log(8, "B1093");
                }
                bsh.initiateShutdown("admin", (time == null ? 0L : time.longValue()) * 1000L, failover, shouldRestart ? BrokerStateHandler.getRestartCode() : 0, true);
            }
        }
        ShutdownHandler.setProperties(reply, 39, 200, null);
        this.parent.sendReply(con, cmd_msg, reply);
        if (con instanceof IMQBasicConnection) {
            IMQBasicConnection ipCon = (IMQBasicConnection)con;
            ipCon.flushControl(1000L);
        }
        BrokerStateHandler bsh = Globals.getBrokerStateHandler();
        if (time == null || time == 0) {
            BrokerStateHandler.setShuttingDown(true);
            bsh.prepareShutdown(failover, false);
        }
        this.waitForHandlersToComplete(20);
        if (shouldRestart) {
            this.logger.log(8, "B1094");
        } else {
            this.logger.log(8, "B1093");
        }
        bsh.initiateShutdown("admin", (time == null ? 0L : time.longValue()) * 1000L, failover, shouldRestart ? BrokerStateHandler.getRestartCode() : 0, true);
        return true;
    }

    private boolean hasDirectConnections() {
        List connections = ConnectionUtil.getConnectionInfoList(null);
        if (connections.size() == 0) {
            return false;
        }
        for (ConnectionInfo cxnInfo : connections) {
            if (!cxnInfo.service.equals("jmsdirect")) continue;
            return true;
        }
        return false;
    }
}

