/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IThreadRootController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.JobListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ListenerFactory;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.impl.ExecutionTransitioner;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import jakarta.batch.api.listener.JobListener;
import jakarta.batch.runtime.BatchStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JobThreadRootControllerImpl
implements IThreadRootController {
    private static final String CLASSNAME = JobThreadRootControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected RuntimeJobExecution jobExecution;
    protected JobContextImpl jobContext;
    protected long rootJobExecutionId;
    protected long jobInstanceId;
    protected IJobStatusManagerService jobStatusService;
    protected IPersistenceManagerService persistenceService;
    private ListenerFactory listenerFactory = null;
    private ExecutionTransitioner transitioner;
    protected final ModelNavigator<JSLJob> jobNavigator;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;

    public JobThreadRootControllerImpl(RuntimeJobExecution jobExecution, long rootJobExecutionId) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.rootJobExecutionId = rootJobExecutionId;
        this.jobInstanceId = jobExecution.getInstanceId();
        this.jobStatusService = ServicesManagerImpl.getInstance().getJobStatusManagerService();
        this.persistenceService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
        this.jobNavigator = jobExecution.getJobNavigator();
        this.setupListeners();
    }

    public JobThreadRootControllerImpl(RuntimeJobExecution jobExecution, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this(jobExecution, rootJobExecutionId);
        this.analyzerQueue = analyzerQueue;
    }

    public JobThreadRootControllerImpl(RuntimeJobExecution jobExecution, BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this(jobExecution, jobExecution.getExecutionId());
        this.analyzerQueue = analyzerQueue;
    }

    @Override
    public ExecutionStatus originateExecutionOnThread() {
        String methodName = "executeJob";
        logger.entering(CLASSNAME, methodName);
        ExecutionStatus retVal = null;
        try {
            if (!this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.markJobStarted();
                this.jobListenersBeforeJob();
                this.transitioner = new ExecutionTransitioner(this.jobExecution, this.rootJobExecutionId, this.jobNavigator, this.analyzerQueue);
                retVal = this.transitioner.doExecutionLoop();
                ExtendedBatchStatus extBatchStatus = retVal.getExtendedBatchStatus();
                switch (extBatchStatus) {
                    case JSL_STOP: {
                        this.jslStop();
                        break;
                    }
                    case JSL_FAIL: {
                        this.updateJobBatchStatus(BatchStatus.FAILED);
                        break;
                    }
                    case EXCEPTION_THROWN: {
                        this.updateJobBatchStatus(BatchStatus.FAILED);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logWarning("Caught throwable in main execution loop", t);
            this.batchStatusFailedFromException();
        }
        this.endOfJob();
        logger.exiting(CLASSNAME, methodName);
        return retVal;
    }

    protected void setContextProperties() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getRootModelElement();
        JSLProperties jslProps = jobModel.getProperties();
        if (jslProps != null) {
            Properties contextProps = this.jobContext.getJSLProperties();
            for (Property property : jslProps.getPropertyList()) {
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
    }

    protected void jslStop() {
        String restartOn = this.jobContext.getRestartOn();
        logger.fine("Logging JSL stop(): exitStatus = " + this.jobContext.getExitStatus() + ", restartOn = " + restartOn);
        this.batchStatusStopping();
        this.jobStatusService.updateJobStatusFromJSLStop(this.jobInstanceId, restartOn);
    }

    protected void markJobStarted() {
        this.updateJobBatchStatus(BatchStatus.STARTED);
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.jobExecution.setStartTime(timestamp);
        this.persistenceService.markJobStarted(this.jobExecution.getExecutionId(), timestamp);
    }

    protected void endOfJob() {
        try {
            this.jobListenersAfterJob();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            logger.warning("Error invoking jobListener.afterJob(). Stack trace: " + sw.toString());
            this.batchStatusFailedFromException();
        }
        this.transitionToFinalBatchStatus();
        if (this.jobContext.getExitStatus() == null) {
            logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + (Object)((Object)this.jobContext.getBatchStatus()));
            this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
        }
        logger.fine("Job complete for job id=" + this.jobExecution.getJobInstance().getJobName() + ", executionId=" + this.jobExecution.getExecutionId() + ", batchStatus=" + (Object)((Object)this.jobContext.getBatchStatus()) + ", exitStatus=" + this.jobContext.getExitStatus());
        this.persistJobBatchAndExitStatus();
    }

    private void persistJobBatchAndExitStatus() {
        BatchStatus batchStatus = this.jobContext.getBatchStatus();
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.jobStatusService.updateJobBatchStatus(this.jobInstanceId, batchStatus);
        this.jobStatusService.updateJobExecutionStatus(this.jobExecution.getInstanceId(), this.jobContext.getBatchStatus(), this.jobContext.getExitStatus());
        if (!(batchStatus.equals((Object)BatchStatus.COMPLETED) || batchStatus.equals((Object)BatchStatus.STOPPED) || batchStatus.equals((Object)BatchStatus.FAILED))) {
            throw new IllegalStateException("Not expected to encounter batchStatus of " + (Object)((Object)batchStatus) + " at this point.  Aborting.");
        }
        this.jobExecution.setEndTime(timestamp);
        this.persistenceService.updateWithFinalExecutionStatusesAndTimestamps(this.jobExecution.getExecutionId(), batchStatus, this.jobContext.getExitStatus(), timestamp);
    }

    private void transitionToFinalBatchStatus() {
        BatchStatus currentBatchStatus = this.jobContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
            this.updateJobBatchStatus(BatchStatus.COMPLETED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
            this.updateJobBatchStatus(BatchStatus.STOPPED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
            this.updateJobBatchStatus(BatchStatus.FAILED);
        } else {
            throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
        }
    }

    protected void updateJobBatchStatus(BatchStatus batchStatus) {
        logger.fine("Setting job batch status to: " + (Object)((Object)batchStatus));
        this.jobContext.setBatchStatus(batchStatus);
    }

    protected void logWarning(String msg, Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        logger.warning(msg + " with Throwable message: " + t.getMessage() + ", and stack trace: " + sw.toString());
    }

    protected void batchStatusStopping() {
        this.updateJobBatchStatus(BatchStatus.STOPPING);
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.persistenceService.updateBatchStatusOnly(this.jobExecution.getExecutionId(), BatchStatus.STOPPING, timestamp);
    }

    private void setupListeners() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getRootModelElement();
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        this.listenerFactory = new ListenerFactory(jobModel, injectionRef);
        this.jobExecution.setListenerFactory(this.listenerFactory);
    }

    @Override
    public void stop() {
        if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTED) || this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTING)) {
            IController stoppableElementController;
            this.batchStatusStopping();
            if (this.transitioner != null && (stoppableElementController = this.transitioner.getCurrentStoppableElementController()) != null) {
                stoppableElementController.stop();
            }
        } else {
            logger.info("Stop ignored since batch status for job is already set to: " + (Object)((Object)this.jobContext.getBatchStatus()));
        }
    }

    protected void jobListenersBeforeJob() {
        List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
        for (JobListenerProxy listenerProxy : jobListeners) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Invoking beforeJob() on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
            }
            listenerProxy.beforeJob();
        }
    }

    private void jobListenersAfterJob() {
        List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
        for (JobListenerProxy listenerProxy : jobListeners) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Invoking afterJob() on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
            }
            listenerProxy.afterJob();
        }
    }

    protected void batchStatusFailedFromException() {
        this.updateJobBatchStatus(BatchStatus.FAILED);
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        return this.transitioner.getStepExecIds();
    }
}

