/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.concurrent.config.ContextService;
import org.glassfish.concurrent.runtime.deployer.BaseConfig;

public class ContextServiceConfig
extends BaseConfig {
    private final Set<String> propagatedContexts;
    private final Set<String> clearedContexts;
    private final Set<String> uchangedContexts;

    public ContextServiceConfig(String jndiName) {
        super(jndiName, null, "true");
        this.propagatedContexts = ContextServiceConfig.parseContextInfo(this.contextInfo, this.isContextInfoEnabledBoolean());
        this.clearedContexts = new HashSet<String>();
        this.uchangedContexts = new HashSet<String>(Arrays.asList("Remaining"));
    }

    public ContextServiceConfig(ContextService config) {
        super(config.getJndiName(), config.getContextInfo(), config.getContextInfoEnabled());
        this.propagatedContexts = ContextServiceConfig.parseContextInfo(this.contextInfo, this.isContextInfoEnabledBoolean());
        this.clearedContexts = new HashSet<String>();
        this.uchangedContexts = new HashSet<String>(Arrays.asList("Remaining"));
    }

    public ContextServiceConfig(String jndiName, String contextInfo, String contextInfoEnabled, Set<String> propagatedContexts, Set<String> clearedContexts, Set<String> uchangedContexts) {
        super(jndiName, contextInfo, contextInfoEnabled);
        this.propagatedContexts = propagatedContexts;
        this.clearedContexts = clearedContexts;
        this.uchangedContexts = uchangedContexts;
    }

    @Override
    public BaseConfig.TYPE getType() {
        return BaseConfig.TYPE.CONTEXT_SERVICE;
    }

    public Set<String> getPropagatedContexts() {
        return this.propagatedContexts;
    }

    public Set<String> getClearedContexts() {
        return this.clearedContexts;
    }

    public Set<String> getUchangedContexts() {
        return this.uchangedContexts;
    }

    public static Set<String> parseContextInfo(String contextInfo, boolean isContextInfoEnabled) {
        HashSet<String> contextTypeArray = new HashSet<String>();
        if (contextInfo == null) {
            contextTypeArray.add("CLASSLOADING");
            contextTypeArray.add("NAMING");
            contextTypeArray.add("SECURITY");
            contextTypeArray.add("WORKAREA");
        } else if (isContextInfoEnabled) {
            StringTokenizer st = new StringTokenizer(contextInfo, ",", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if ("Classloader".equalsIgnoreCase(token)) {
                    contextTypeArray.add("CLASSLOADING");
                    continue;
                }
                if ("JNDI".equalsIgnoreCase(token)) {
                    contextTypeArray.add("NAMING");
                    continue;
                }
                if ("Security".equalsIgnoreCase(token)) {
                    contextTypeArray.add("SECURITY");
                    continue;
                }
                if ("WorkArea".equalsIgnoreCase(token)) {
                    contextTypeArray.add("WORKAREA");
                    continue;
                }
                contextTypeArray.add(token);
            }
        }
        return contextTypeArray;
    }
}

