/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ContextServiceDefinitionDescriptor;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ContextServiceConfig;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ContextServiceDefinitionDescriptor.class)
public class ContextServiceDefinitionDescriptorDeployer
implements ResourceDeployer {
    private static final Logger logger = Logger.getLogger(ContextServiceDefinitionDescriptorDeployer.class.getName());
    @Inject
    private ResourceNamingService namingService;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    ConcurrentRuntime concurrentRuntime;

    public void deployResource(Object resource) throws Exception {
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        this.deployResource(resource, applicationName, moduleName);
    }

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ContextServiceDefinitionDescriptor descriptor = (ContextServiceDefinitionDescriptor)resource;
        this.validateContextServiceDescriptor(descriptor);
        String propageContexts = this.renameBuiltinContexts(descriptor.getPropagated()).stream().collect(Collectors.joining(", "));
        ContextServiceConfig contextServiceConfig = new ContextServiceConfig(descriptor.getName(), propageContexts, "true", this.renameBuiltinContexts(descriptor.getPropagated()), this.renameBuiltinContexts(descriptor.getCleared()), this.renameBuiltinContexts(descriptor.getUnchanged()));
        String customNameOfResource = ConnectorsUtil.deriveResourceName((String)descriptor.getResourceId(), (String)descriptor.getName(), (JavaEEResourceType)descriptor.getResourceType());
        ResourceInfo resourceInfo = new ResourceInfo(customNameOfResource, applicationName, moduleName);
        ContextServiceImpl contextService = this.concurrentRuntime.createContextService(resourceInfo, contextServiceConfig);
        this.namingService.publishObject((GenericResourceInfo)resourceInfo, customNameOfResource, (Object)contextService, true);
    }

    public void undeployResource(Object resource) throws Exception {
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        ContextServiceDefinitionDescriptor concurrentDefinitionDescriptor = (ContextServiceDefinitionDescriptor)resource;
        this.undeployResource(resource, applicationName, moduleName);
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ContextServiceDefinitionDescriptor concurrentDefinitionDescriptor = (ContextServiceDefinitionDescriptor)resource;
        String jndiName = concurrentDefinitionDescriptor.getName();
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, jndiName);
        this.concurrentRuntime.shutdownContextService(jndiName);
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ContextServiceDefinitionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private void validateContextServiceDescriptor(ContextServiceDefinitionDescriptor descriptor) {
        if (descriptor.getCleared() == null) {
            HashSet<String> defaultSetCleared = new HashSet<String>();
            defaultSetCleared.add("Transaction");
            descriptor.setCleared(defaultSetCleared);
        }
        if (descriptor.getPropagated() == null) {
            HashSet<String> defaultSetPropagated = new HashSet<String>();
            defaultSetPropagated.add("Remaining");
            descriptor.setPropagated(defaultSetPropagated);
        }
        if (descriptor.getUnchanged() == null) {
            descriptor.setUnchanged(new HashSet());
        }
    }

    private Set<String> renameBuiltinContexts(Set<String> definitions) {
        HashSet<String> contexts = new HashSet<String>();
        HashSet<String> unusedDefinitions = new HashSet<String>(definitions);
        if (unusedDefinitions.contains("Transaction")) {
            contexts.add("WORKAREA");
            unusedDefinitions.remove("Transaction");
        }
        if (unusedDefinitions.contains("Security")) {
            contexts.add("SECURITY");
            unusedDefinitions.remove("Security");
        }
        if (unusedDefinitions.contains("Application")) {
            contexts.add("CLASSLOADING");
            contexts.add("NAMING");
            unusedDefinitions.remove("Application");
        }
        contexts.addAll(unusedDefinitions);
        return contexts;
    }
}

