/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import jakarta.inject.Inject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.appclient.server.connector.CarType;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AppClientGroupFacadeGenerator {
    private static final String GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME = "org.glassfish.appclient.client.AppClientGroupFacade";
    private static final Attributes.Name GLASSFISH_APPCLIENT_GROUP = new Attributes.Name("GlassFish-AppClient-Group");
    private static final String GF_CLIENT_MODULE_NAME = "fish.payara.server.appclient.gf-client-module";
    private static final String GROUP_FACADE_ALREADY_GENERATED = "groupFacadeAlreadyGenerated";
    private static final String PERMISSIONS_XML_PATH = "META-INF/permissions.xml";
    private DeploymentContext dc;
    private AppClientDeployerHelper helper;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private CarType carType;

    void run(AppClientDeployerHelper helper) {
        this.dc = helper.dc();
        this.helper = helper;
        if (!this.groupFacadeAlreadyGenerated().get()) {
            this.generateGroupFacade();
        }
    }

    private AtomicBoolean groupFacadeAlreadyGenerated() {
        AtomicBoolean groupFacadeAlreadyGenerated = (AtomicBoolean)this.dc.getTransientAppMetaData(GROUP_FACADE_ALREADY_GENERATED, AtomicBoolean.class);
        if (groupFacadeAlreadyGenerated == null) {
            groupFacadeAlreadyGenerated = new AtomicBoolean(false);
            this.dc.addTransientAppMetaData(GROUP_FACADE_ALREADY_GENERATED, (Object)groupFacadeAlreadyGenerated);
        }
        return groupFacadeAlreadyGenerated;
    }

    private void recordGroupFacadeGeneration() {
        ((AtomicBoolean)this.dc.getTransientAppMetaData(GROUP_FACADE_ALREADY_GENERATED, AtomicBoolean.class)).set(true);
    }

    private void generateGroupFacade() {
        Application application = (Application)this.dc.getModuleMetaData(Application.class);
        Collection<ModuleDescriptor<BundleDescriptor>> appClients = application.getModuleDescriptorsByType((ArchiveType)this.carType);
        StringBuilder appClientGroupListSB = new StringBuilder();
        for (ModuleDescriptor<BundleDescriptor> md : appClients) {
            appClientGroupListSB.append(appClientGroupListSB.length() > 0 ? " " : "").append(this.earDirUserURIText(this.dc)).append(this.appClientFacadeUserURI(md.getArchiveUri()));
        }
        try {
            this.addTopLevelContentToGroupFacade();
            this.generateAndRecordEARFacadeContents(this.dc, appClientGroupListSB.toString());
            this.recordGroupFacadeGeneration();
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void addTopLevelContentToGroupFacade() throws IOException {
        this.helper.addClientPolicyFiles(null);
    }

    private String earDirUserURIText(DeploymentContext dc) {
        DeployCommandParameters deployParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String appName = deployParams.name();
        try {
            return VersioningUtils.getUntaggedName((String)appName) + "Client/";
        }
        catch (VersioningSyntaxException ex) {
            Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages").log(Level.SEVERE, null, ex);
            return appName;
        }
    }

    private String appClientFacadeUserURI(String appClientModuleURIText) {
        if (((String)appClientModuleURIText).endsWith("_jar")) {
            appClientModuleURIText = ((String)appClientModuleURIText).substring(0, ((String)appClientModuleURIText).lastIndexOf("_jar")) + ".jar";
        }
        int dotJar = ((String)appClientModuleURIText).lastIndexOf(".jar");
        String appClientFacadePath = ((String)appClientModuleURIText).substring(0, dotJar) + "Client.jar";
        return appClientFacadePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAndRecordEARFacadeContents(DeploymentContext dc, String appClientGroupList) throws IOException {
        ClientArtifactsManager clientArtifactsManager = ClientArtifactsManager.get((DeploymentContext)dc);
        Manifest manifest = new Manifest();
        Attributes mainAttrs = manifest.getMainAttributes();
        mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrs.put(Attributes.Name.MAIN_CLASS, GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME);
        mainAttrs.put(GLASSFISH_APPCLIENT_GROUP, appClientGroupList);
        File manifestFile = File.createTempFile("groupMF", ".MF");
        try (BufferedOutputStream manifestOutputStream = new BufferedOutputStream(new FileOutputStream(manifestFile));){
            manifest.write(manifestOutputStream);
        }
        clientArtifactsManager.add(manifestFile, "META-INF/MANIFEST.MF", true);
        this.writeMainClass(clientArtifactsManager);
        File permissionsFile = this.getPermissionsFile();
        if (permissionsFile.canRead()) {
            clientArtifactsManager.add(permissionsFile, PERMISSIONS_XML_PATH, false);
        }
    }

    private File getPermissionsFile() {
        return new File(new File(this.dc.getSource().getParentArchive().getURI()), PERMISSIONS_XML_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMainClass(ClientArtifactsManager clientArtifactsManager) throws IOException {
        String mainClassResourceName = GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME.replace('.', '/') + ".class";
        File mainClassJAR = new File(AppClientDeployerHelper.getModulesDir(this.serviceLocator), "gf-client-module.jar");
        File mainClassFile = File.createTempFile("main", ".class");
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mainClassFile));
        InputStream is = null;
        JarFile jf = null;
        try {
            jf = new JarFile(mainClassJAR);
            JarEntry entry = jf.getJarEntry(mainClassResourceName);
            is = jf.getInputStream(entry);
            DeploymentUtils.copyStream((InputStream)is, (OutputStream)os);
            is.close();
            clientArtifactsManager.add(mainClassFile, mainClassResourceName, true);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    if (jf != null) {
                        jf.close();
                    }
                }
            }
        }
    }
}

