/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import jakarta.servlet.http.HttpServletRequest;

public class LogoutConfiguration {
    private boolean notifyProvider;
    private String redirectURI;
    private boolean accessTokenExpiry;
    private boolean identityTokenExpiry;

    public boolean isNotifyProvider() {
        return this.notifyProvider;
    }

    public LogoutConfiguration setNotifyProvider(boolean notifyProvider) {
        this.notifyProvider = notifyProvider;
        return this;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public LogoutConfiguration setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return this;
    }

    public String buildRedirectURI(HttpServletRequest request) {
        if (this.redirectURI.contains("${baseURL}")) {
            String baseURL = request.getRequestURL().substring(0, request.getRequestURL().length() - request.getRequestURI().length()) + request.getContextPath();
            return this.redirectURI.replace("${baseURL}", baseURL);
        }
        return this.redirectURI;
    }

    public boolean isAccessTokenExpiry() {
        return this.accessTokenExpiry;
    }

    public LogoutConfiguration setAccessTokenExpiry(boolean accessTokenExpiry) {
        this.accessTokenExpiry = accessTokenExpiry;
        return this;
    }

    public boolean isIdentityTokenExpiry() {
        return this.identityTokenExpiry;
    }

    public LogoutConfiguration setIdentityTokenExpiry(boolean identityTokenExpiry) {
        this.identityTokenExpiry = identityTokenExpiry;
        return this;
    }

    public String toString() {
        return "LogoutConfiguration{notifyProvider=" + this.notifyProvider + ", redirectURI=" + this.redirectURI + ", accessTokenExpiry=" + this.accessTokenExpiry + ", identityTokenExpiry=" + this.identityTokenExpiry + "}";
    }
}

