/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.injection;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSPasswordCredential;
import jakarta.jms.JMSSessionMode;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.jms.injection.AbstractJMSContextManager;
import org.glassfish.jms.injection.ForwardingJMSContext;
import org.glassfish.jms.injection.JMSContextMetadata;
import org.glassfish.jms.injection.RequestedJMSContextManager;
import org.glassfish.jms.injection.TransactedJMSContextManager;
import org.glassfish.logging.annotation.LoggerInfo;

public class InjectableJMSContext
extends ForwardingJMSContext
implements Serializable {
    @LoggerInfo(subsystem="JMS_INJECTION", description="JMS Injection Logger", publish=true)
    public static final String JMS_INJECTION_LOGGER = "javax.enterprise.resource.jms.injection";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.jms.injection");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InjectableJMSContext.class);
    private final String ipId;
    private final String id;
    @Inject
    private transient Instance<TransactedJMSContextManager> tm;
    private final RequestedJMSContextManager requestedManager;
    private TransactedJMSContextManager transactedManager;
    private final JMSContextMetadata metadata;
    private transient ConnectionFactory connectionFactory;
    private transient ConnectionFactory connectionFactoryPM;
    private transient JavaEETransactionManager transactionManager;
    private static final boolean usePMResourceInTransaction = Boolean.parseBoolean(System.getProperty("org.glassfish.jms.skip-resource-registration-in-transaction", "true"));

    @Inject
    public InjectableJMSContext(InjectionPoint ip, RequestedJMSContextManager rm) {
        this.getTransactionManager();
        JMSConnectionFactory jmsConnectionFactoryAnnot = (JMSConnectionFactory)ip.getAnnotated().getAnnotation(JMSConnectionFactory.class);
        JMSSessionMode sessionModeAnnot = (JMSSessionMode)ip.getAnnotated().getAnnotation(JMSSessionMode.class);
        JMSPasswordCredential credentialAnnot = (JMSPasswordCredential)ip.getAnnotated().getAnnotation(JMSPasswordCredential.class);
        this.ipId = UUID.randomUUID().toString();
        this.requestedManager = rm;
        this.metadata = new JMSContextMetadata(jmsConnectionFactoryAnnot, sessionModeAnnot, credentialAnnot);
        this.id = this.metadata.getFingerPrint();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, localStrings.getLocalString("JMSContext.injection.initialization", "Injecting JMSContext wrapper with id {0} and metadata [{1}].", new Object[]{this.ipId, this.metadata}));
        }
    }

    private synchronized TransactedJMSContextManager getTransactedManager() {
        if (this.transactedManager == null) {
            this.transactedManager = (TransactedJMSContextManager)this.tm.get();
        }
        return this.transactedManager;
    }

    @Override
    protected JMSContext delegate() {
        AbstractJMSContextManager manager = this.requestedManager;
        boolean isInTransaction = this.isInTransaction();
        if (isInTransaction) {
            manager = this.getTransactedManager();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, localStrings.getLocalString("JMSContext.delegation.type", "JMSContext wrapper with id {0} is delegating to {1} instance.", new Object[]{this.ipId, manager.getType()}));
        }
        try {
            return manager.getContext(this.ipId, this.id, this.metadata, this.getConnectionFactory(isInTransaction));
        }
        catch (ContextNotActiveException e) {
            String message = localStrings.getLocalString("ContextNotActiveException.msg", "An injected JMSContext cannot be used when there is neither a transaction or a valid request scope.");
            throw new RuntimeException(message, e);
        }
    }

    public String toString() {
        JMSContext rContext = null;
        JMSContext tContext = null;
        try {
            boolean isInTransaction = this.isInTransaction();
            if (isInTransaction) {
                TransactedJMSContextManager manager = this.getTransactedManager();
                tContext = manager.getContext(this.id);
                if (tContext == null) {
                    tContext = manager.getContext(this.ipId, this.id, this.metadata, this.getConnectionFactory(isInTransaction));
                }
            } else {
                rContext = this.requestedManager.getContext(this.id);
                if (rContext == null) {
                    rContext = this.requestedManager.getContext(this.ipId, this.id, this.metadata, this.getConnectionFactory(isInTransaction));
                }
            }
        }
        catch (ContextNotActiveException isInTransaction) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("JMSContext Wrapper ").append(this.ipId).append(" with metadata [").append(this.metadata).append("]");
        if (tContext != null) {
            sb.append(", around ").append(this.getTransactedManager().getType()).append(" [").append(tContext).append("]");
        } else if (rContext != null) {
            sb.append(", around ").append(this.requestedManager.getType()).append(" [").append(rContext).append("]");
        } else {
            sb.append(", there is neither a transaction or a valid request scope.");
        }
        return sb.toString();
    }

    @PreDestroy
    public void cleanup() {
        this.cleanupManager(this.requestedManager);
        this.cleanupManager(this.getTransactedManager());
    }

    private void cleanupManager(AbstractJMSContextManager manager) {
        try {
            manager.cleanup();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, localStrings.getLocalString("JMSContext.injection.cleanup", "Cleaning up {0} JMSContext wrapper with id {1} and metadata [{2}].", new Object[]{manager.getType(), this.ipId, this.metadata.getLookup()}));
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, localStrings.getLocalString("JMSContext.injection.cleanup.failure", "Failed to cleaning up {0} JMSContext wrapper with id {1} and metadata [{2}]. Reason: {3}.", new Object[]{manager.getType(), this.ipId, this.metadata.getLookup(), t.toString()}));
        }
    }

    private JavaEETransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            ServiceLocator serviceLocator = Globals.get(ServiceLocator.class);
            if (serviceLocator != null) {
                this.transactionManager = (JavaEETransactionManager)serviceLocator.getService(JavaEETransactionManager.class, new Annotation[0]);
            }
            if (this.transactionManager == null) {
                throw new RuntimeException(localStrings.getLocalString("txn.mgr.failure", "Unable to retrieve transaction manager."));
            }
        }
        return this.transactionManager;
    }

    private ConnectionFactory getConnectionFactory(boolean isInTransaction) {
        ConnectionFactory cachedCF = null;
        boolean usePMResource = isInTransaction && (usePMResourceInTransaction || this.connectionFactoryPM != null);
        cachedCF = usePMResource ? this.connectionFactoryPM : this.connectionFactory;
        if (cachedCF == null) {
            String jndiName = this.metadata.getLookup() == null ? "java:comp/DefaultJMSConnectionFactory" : this.metadata.getLookup();
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException ne) {
                throw new RuntimeException(localStrings.getLocalString("initialContext.init.exception", "Cannot create InitialContext."), ne);
            }
            try {
                boolean isPMName = jndiName.endsWith("__pm");
                if (isPMName) {
                    int l = jndiName.length();
                    jndiName = jndiName.substring(0, l - 4);
                }
                cachedCF = (ConnectionFactory)initialContext.lookup(jndiName);
                if (isInTransaction && (usePMResourceInTransaction || isPMName)) {
                    jndiName = ConnectorsUtil.getPMJndiName((String)jndiName);
                    cachedCF = (ConnectionFactory)initialContext.lookup(jndiName);
                    usePMResource = true;
                }
            }
            catch (NamingException ne) {
                throw new RuntimeException(localStrings.getLocalString("connectionFactory.not.found", "ConnectionFactory not found with lookup {0}.", new Object[]{jndiName}), ne);
            }
            finally {
                if (initialContext != null) {
                    try {
                        initialContext.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
            if (usePMResource) {
                this.connectionFactoryPM = cachedCF;
            } else {
                this.connectionFactory = cachedCF;
            }
        }
        return cachedCF;
    }

    private boolean isInTransaction() {
        boolean isInTransaction = false;
        try {
            Transaction txn = this.getTransactionManager().getTransaction();
            if (txn != null) {
                isInTransaction = true;
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(localStrings.getLocalString("txn.detection.failure", "Failed to detect transaction status of current thread."), e);
        }
        return isInTransaction;
    }
}

