/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.persistent.timer;

import com.sun.ejb.PersistentTimerService;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.nucleus.cluster.ClusterListener;
import fish.payara.nucleus.cluster.MemberEvent;
import fish.payara.nucleus.cluster.PayaraCluster;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.ejb.persistent.timer.PersistentEJBTimerService;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
public class DatabaseEJBTimerService
implements PersistentTimerService,
RecoveryEventListener,
PostConstruct,
ClusterListener {
    private static Logger logger = EjbContainerUtilImpl.getLogger();
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    PayaraCluster cluster;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    RecoveryResourceRegistry recoveryResourceRegistry;

    public void postConstruct() {
        if (!this.ejbContainerUtil.isDas()) {
            if (this.cluster != null && this.cluster.isEnabled()) {
                this.cluster.addClusterListener((ClusterListener)this);
            }
            this.recoveryResourceRegistry.addEventListener((RecoveryEventListener)this);
        }
    }

    @Override
    public void initPersistentTimerService(String target) {
        PersistentEJBTimerService.initEJBTimerService(target);
    }

    public void beforeRecovery(boolean delegated, String instance) {
    }

    public void afterRecovery(boolean success, boolean delegated, String instance) {
        if (!delegated) {
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "[DistributedEJBTimerService] afterRecovery event for instance {0}", instance);
        }
        if (instance != null && !instance.equals(this.ejbContainerUtil.getServerEnvironment().getInstanceName())) {
            if (success) {
                this.migrateTimers(instance);
            } else {
                logger.log(Level.WARNING, "[DistributedEJBTimerService] Cannot perform automatic timer migration after failed transaction recovery");
            }
        }
    }

    private int migrateTimers(String serverId) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "[DistributedEJBTimerService] migrating timers from {0}", serverId);
        }
        int result = 0;
        EJBTimerService ejbTimerService = EJBTimerService.getPersistentTimerService();
        if (ejbTimerService != null && ejbTimerService.isPersistent()) {
            result = ejbTimerService.migrateTimers(serverId);
        }
        return result;
    }

    public void memberAdded(MemberEvent event) {
    }

    public void memberRemoved(MemberEvent event) {
        String server = event.getServer();
        String group = event.getServerGroup();
        String thisServer = this.serverEnv.getInstanceName();
        boolean migrate = false;
        Cluster forServer = this.domain.getClusterForInstance(server);
        if (forServer != null) {
            for (Server instance : forServer.getInstances()) {
                if (!instance.getName().equals(thisServer)) continue;
                migrate = true;
                break;
            }
        }
        if (!migrate) {
            block1: for (DeploymentGroup deploymentGroup : this.domain.getDeploymentGroupsForInstance(server)) {
                for (Server instance : deploymentGroup.getInstances()) {
                    if (!instance.getName().equals(thisServer)) continue;
                    migrate = true;
                    continue block1;
                }
            }
        }
        if (migrate) {
            this.migrateTimers(event.getServer());
        }
    }
}

