/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.DasConfig;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=20)
public class AutoDeployService
implements PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    ServiceLocator habitat;
    @Inject
    ServerEnvironment env;
    @Inject
    private PayaraExecutorService executor;
    private AutoDeployer autoDeployer = null;
    private ScheduledFuture<?> autoDeployerTimerTask;
    private String target;
    private static final String DAS_TARGET = "server";
    private static final List<String> configPropertyNames = Arrays.asList("autodeploy-enabled", "autodeploy-polling-interval-in-seconds", "autodeploy-verifier-enabled", "autodeploy-jsp-precompilation-enabled");
    public static Logger deplLogger;
    @LogMessageInfo(message="Error parsing configured polling-interval-in-seconds {0} as an integer; {1} {2}", level="WARNING")
    private static final String PARSING_POLLING_INTERVAL_ERROR = "NCLS-DEPLOYMENT-02028";
    @LogMessageInfo(message="Exception caught:  {0}", cause="An exception was caught when the application was autodeployed.", action="See the exception to determine how to fix the error", level="SEVERE")
    private static final String EXCEPTION_CAUGHT = "NCLS-DEPLOYMENT-02029";
    @LogMessageInfo(message="Error processing configuration change of {0} from {1} to {2}; {3} {4}", level="WARNING")
    private static final String CONFIGURATION_CHANGE_ERROR = "NCLS-DEPLOYMENT-02030";
    private static final String DEFAULT_POLLING_INTERVAL_IN_SECONDS = "2";
    private static final String DEFAULT_AUTO_DEPLOY_ENABLED = "true";
    private static final Pattern TOKEN_SUBSTITUTION;
    private static final String SLASH_REPLACEMENT;
    private static final String DOLLAR_REPLACEMENT;

    public void postConstruct() {
        deplLogger = AutoDeployer.deplLogger;
        if (!this.env.isDas()) {
            return;
        }
        String directory = this.activeDasConfig.getAutodeployDir();
        this.target = this.getTarget();
        try {
            this.autoDeployer = new AutoDeployer(this.target, directory, this.getDefaultVirtualServer(), Boolean.parseBoolean(this.activeDasConfig.getAutodeployJspPrecompilationEnabled()), Boolean.parseBoolean(this.activeDasConfig.getAutodeployVerifierEnabled()), true, true, true, this.habitat);
            boolean isEnabled = this.isAutoDeployEnabled();
            int pollingIntervalInSeconds = Integer.parseInt(DEFAULT_POLLING_INTERVAL_IN_SECONDS);
            try {
                pollingIntervalInSeconds = this.getPollingIntervalInSeconds();
            }
            catch (NumberFormatException ex) {
                deplLogger.log(Level.WARNING, PARSING_POLLING_INTERVAL_ERROR, new Object[]{this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), ex.getClass().getName(), ex.getLocalizedMessage()});
            }
            if (isEnabled) {
                this.startAutoDeployer(pollingIntervalInSeconds);
            }
        }
        catch (AutoDeploymentException e) {
            LogRecord lr = new LogRecord(Level.SEVERE, EXCEPTION_CAUGHT);
            Object[] args = new Object[]{e.getMessage()};
            lr.setParameters(args);
            lr.setThrown((Throwable)((Object)e));
            deplLogger.log(lr);
        }
    }

    public void preDestroy() {
        this.stopAutoDeployer();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private void logConfig(String title, boolean isEnabled, int pollingIntervalInSeconds, String directory) {
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "[AutoDeploy] {0}, enabled={1}, polling interval(seconds)={2}, directory={3}", new Object[]{title, isEnabled, pollingIntervalInSeconds, directory});
        }
    }

    private String getTarget() {
        return null;
    }

    private String getDefaultVirtualServer() {
        return null;
    }

    private boolean isAutoDeployEnabled() {
        return Boolean.parseBoolean(AutoDeployService.getValue(this.activeDasConfig.getAutodeployEnabled(), DEFAULT_AUTO_DEPLOY_ENABLED));
    }

    private int getPollingIntervalInSeconds() throws NumberFormatException {
        return Integer.parseInt(AutoDeployService.getValue(this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), DEFAULT_POLLING_INTERVAL_IN_SECONDS));
    }

    private void startAutoDeployer(int pollingIntervalInSeconds) {
        this.autoDeployer.init();
        this.autoDeployerTimerTask = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    AutoDeployService.this.autoDeployer.run();
                }
                catch (Exception ex) {
                    AutoDeployer.deplLogger.log(Level.FINE, ex.getMessage(), ex);
                }
            }
        }, 0L, (long)pollingIntervalInSeconds, TimeUnit.SECONDS);
        this.logConfig("Started", this.isAutoDeployEnabled(), pollingIntervalInSeconds, this.activeDasConfig.getAutodeployDir());
    }

    private void stopAutoDeployer() {
        deplLogger.fine("[AutoDeploy] Stopping");
        if (this.autoDeployer != null) {
            this.autoDeployer.cancel(true);
        }
        if (this.autoDeployerTimerTask != null) {
            this.autoDeployerTimerTask.cancel(false);
        }
    }

    private void rescheduleAutoDeployer(int pollingIntervalInSeconds) {
        deplLogger.fine("[AutoDeploy] Restarting...");
        this.stopAutoDeployer();
        try {
            this.autoDeployer.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startAutoDeployer(pollingIntervalInSeconds);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        if (this.autoDeployer == null) {
            return null;
        }
        ArrayList unprocessedEvents = new ArrayList();
        Boolean newEnabled = null;
        Integer newPollingIntervalInSeconds = null;
        for (PropertyChangeEvent event : events) {
            if (!(event.getSource() instanceof DasConfig)) continue;
            String propName = event.getPropertyName();
            if (configPropertyNames.contains(propName) && event.getOldValue().equals(event.getNewValue())) {
                deplLogger.fine("[AutoDeploy] Ignoring reconfig of " + propName + " from " + event.getOldValue() + " to " + event.getNewValue());
                continue;
            }
            String oldValue = AutoDeployService.replaceTokens((String)event.getOldValue(), System.getProperties());
            String newValue = AutoDeployService.replaceTokens((String)event.getNewValue(), System.getProperties());
            if (propName.equals("autodeploy-enabled")) {
                newEnabled = Boolean.valueOf(newValue);
                deplLogger.fine("[AutoDeploy] Reconfig - enabled changed to " + newEnabled);
                continue;
            }
            if (propName.equals("autodeploy-polling-interval-in-seconds")) {
                try {
                    newPollingIntervalInSeconds = new Integer(newValue);
                    deplLogger.fine("[AutoDeploy] Reconfig - polling interval (seconds) changed from " + oldValue + " to " + newPollingIntervalInSeconds);
                }
                catch (NumberFormatException ex) {
                    deplLogger.log(Level.WARNING, CONFIGURATION_CHANGE_ERROR, new Object[]{propName, oldValue, newValue, ex.getClass().getName(), ex.getLocalizedMessage()});
                }
                continue;
            }
            if (propName.equals("autodeploy-dir")) {
                String newDir = newValue;
                try {
                    this.autoDeployer.setDirectory(newDir);
                    deplLogger.fine("[AutoDeploy] Reconfig - directory changed from " + oldValue + " to " + newDir);
                }
                catch (AutoDeploymentException ex) {
                    deplLogger.log(Level.WARNING, CONFIGURATION_CHANGE_ERROR, new Object[]{propName, oldValue, newValue, ((Object)((Object)ex)).getClass().getName(), ex.getLocalizedMessage()});
                }
                continue;
            }
            if (propName.equals("autodeploy-verifier-enabled")) {
                boolean newVerifierEnabled = Boolean.parseBoolean(newValue);
                this.autoDeployer.setVerifierEnabled(newVerifierEnabled);
                deplLogger.fine("[AutoDeploy] Reconfig - verifierEnabled changed from " + Boolean.parseBoolean(oldValue) + " to " + newVerifierEnabled);
                continue;
            }
            if (!propName.equals("autodeploy-jsp-precompilation-enabled")) continue;
            boolean newJspPrecompiled = Boolean.parseBoolean(newValue);
            this.autoDeployer.setJspPrecompilationEnabled(newJspPrecompiled);
            deplLogger.fine("[AutoDeploy] Reconfig - jspPrecompilationEnabled changed from " + Boolean.parseBoolean(oldValue) + " to " + newJspPrecompiled);
        }
        if (newEnabled != null) {
            if (newEnabled.booleanValue()) {
                this.startAutoDeployer(newPollingIntervalInSeconds == null ? this.getPollingIntervalInSeconds() : newPollingIntervalInSeconds.intValue());
            } else {
                this.stopAutoDeployer();
            }
        } else if (newPollingIntervalInSeconds != null && this.isAutoDeployEnabled()) {
            this.rescheduleAutoDeployer(newPollingIntervalInSeconds);
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }

    private static String replaceTokens(String s, Properties values) {
        Matcher m = TOKEN_SUBSTITUTION.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            String propertyValue = values.getProperty(propertyName);
            if (propertyValue == null) continue;
            String adjustedPropertyValue = propertyValue.replaceAll("\\\\", SLASH_REPLACEMENT).replaceAll("\\$", DOLLAR_REPLACEMENT);
            String x = s.substring(m.start(), m.end());
            try {
                m.appendReplacement(sb, adjustedPropertyValue);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("**** appendReplacement failed: segment is " + x + "; original replacement was " + propertyValue + " and adj. replacement is " + adjustedPropertyValue + "; exc follows");
                throw iae;
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        TOKEN_SUBSTITUTION = Pattern.compile("\\$\\{([^\\}]*)\\}");
        SLASH_REPLACEMENT = Matcher.quoteReplacement("\\\\");
        DOLLAR_REPLACEMENT = Matcher.quoteReplacement("\\$");
    }
}

