/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.autodeploy.AutoOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentProperties;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AutoDeploymentOperation
extends AutoOperation {
    public static final Logger deplLogger = AutoDeployer.deplLogger;
    @LogMessageInfo(message="Attempt to create file {0} failed; no further information.", level="WARNING")
    private static final String CREATE_FILE_FAILED = "NCLS-DEPLOYMENT-02034";
    private boolean writeMarkOnDeployed;
    private static final String COMMAND_NAME = "deploy";
    @Inject
    @Named(value="deploy")
    private AdminCommand deployCommand;
    @Inject
    private AutodeployRetryManager retryManager;

    public static AutoDeploymentOperation newInstance(ServiceLocator serviceLocator, File file, String virtualServer, String target, String contextRoot) {
        AutoDeploymentOperation autoDeploymentOperation = (AutoDeploymentOperation)serviceLocator.getService(AutoDeploymentOperation.class, new Annotation[0]);
        autoDeploymentOperation.init(true, file, true, virtualServer, true, true, false, target, contextRoot);
        return autoDeploymentOperation;
    }

    static AutoDeploymentOperation newInstance(ServiceLocator serviceLocator, boolean writeMarkOnDeployed, File file, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean preJspCompilation, String target) {
        AutoDeploymentOperation autoDeploymentOperation = (AutoDeploymentOperation)serviceLocator.getService(AutoDeploymentOperation.class, new Annotation[0]);
        autoDeploymentOperation.init(writeMarkOnDeployed, file, enabled, virtualServer, forceDeploy, verify, preJspCompilation, target, null);
        return autoDeploymentOperation;
    }

    protected AutoDeploymentOperation init(boolean writeMarkOnDeployed, File file, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean preJspCompilation, String target, String contextRoot) {
        super.init(file, AutoDeploymentOperation.getDeployActionProperties(file, enabled, virtualServer, forceDeploy, verify, preJspCompilation, target, contextRoot), COMMAND_NAME, this.deployCommand);
        this.writeMarkOnDeployed = writeMarkOnDeployed;
        return this;
    }

    @Override
    protected String getMessageString(AutoDeployer.AutodeploymentStatus ds, File file) {
        return localStrings.getLocalString(ds.deploymentMessageKey, ds.deploymentDefaultMessage, new Object[]{file});
    }

    @Override
    protected void markFiles(AutoDeployer.AutodeploymentStatus ds, File file) {
        if (ds != AutoDeployer.AutodeploymentStatus.SUCCESS && ds != AutoDeployer.AutodeploymentStatus.WARNING) {
            try {
                this.retryManager.recordFailedDeployment(file);
            }
            catch (AutoDeploymentException ex) {
                this.markDeployFailed(file);
                this.retryManager.endMonitoring(file);
            }
        } else {
            this.retryManager.recordSuccessfulDeployment(file);
            if (ds.status) {
                if (this.writeMarkOnDeployed) {
                    this.markDeployed(file);
                }
            } else {
                this.markDeployFailed(file);
            }
        }
    }

    private void markDeployed(File f) {
        try {
            this.deleteAllMarks(f);
            File deployedFile = this.getDeployedFile(f);
            if (!deployedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FILE_FAILED, deployedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markDeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            File deployFailedFile = this.getDeployFailedFile(f);
            if (!deployFailedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FILE_FAILED, deployFailedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Properties getDeployActionProperties(File deployablefile, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean jspPreCompilation, String target, String contextRoot) {
        DeploymentProperties deploymentProperties = new DeploymentProperties();
        deploymentProperties.setPath(deployablefile.getAbsolutePath());
        deploymentProperties.setVirtualServers(virtualServer);
        deploymentProperties.setTarget(target);
        deploymentProperties.setContextRoot(contextRoot);
        deploymentProperties.setEnabled(enabled);
        deploymentProperties.setForce(forceDeploy);
        deploymentProperties.setVerify(verify);
        deploymentProperties.setPrecompileJSP(jspPreCompilation);
        deploymentProperties.setProperty("logReportedErrors", "false");
        return deploymentProperties;
    }
}

