/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JvmOptions {
    private static final Pattern envP = Pattern.compile("([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)");
    private static final int MAX_SUBSTITUTION_DEPTH = 100;
    Map<String, String> sysProps = new HashMap<String, String>();
    Map<String, String> xxProps = new HashMap<String, String>();
    Map<String, String> xProps = new HashMap<String, String>();
    Map<String, String> plainProps = new HashMap<String, String>();
    Set<String> moduleProps = new HashSet<String>();
    int osgiPort = -1;

    /*
     * WARNING - void declaration
     */
    JvmOptions(List<String> options) throws GFLauncherException {
        for (String string : options) {
            void var3_3;
            void var3_6;
            String string2 = StringUtils.removeEnclosingQuotes(string);
            Matcher m2 = envP.matcher(string2);
            for (int i = 0; m2.find() && i < 100; ++i) {
                String matchValue = m2.group(2).trim();
                String newValue = System.getenv(matchValue);
                if (newValue == null) continue;
                String string3 = m2.replaceFirst(Matcher.quoteReplacement(m2.group(1) + newValue + m2.group(3)));
                m2.reset(string3);
            }
            if (!var3_6.startsWith("-")) {
                String string4 = "-" + (String)var3_6;
            }
            if (var3_3.startsWith("-D")) {
                this.addSysProp((String)var3_3);
                continue;
            }
            if (var3_3.startsWith("-XX")) {
                this.addXxProp((String)var3_3);
                continue;
            }
            if (var3_3.startsWith("-X")) {
                this.addXProp((String)var3_3);
                continue;
            }
            if (var3_3.startsWith("--add")) {
                this.addModuleProp((String)var3_3);
                continue;
            }
            if (var3_3.startsWith("-")) {
                this.addPlainProp((String)var3_3);
                continue;
            }
            throw new GFLauncherException("UnknownJvmOptionFormat", var3_3);
        }
        this.filter();
        this.setOsgiPort();
    }

    public String toString() {
        List<String> ss = this.toStringArray();
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    List<String> toStringArray() {
        String value;
        ArrayList<String> ss = new ArrayList<String>(this.moduleProps);
        Set<String> keys = this.xxProps.keySet();
        for (String name : keys) {
            value = this.xxProps.get(name);
            if (value != null) {
                ss.add("-XX" + name + "=" + value);
                continue;
            }
            ss.add("-XX" + name);
        }
        keys = this.xProps.keySet();
        for (String name : keys) {
            value = this.xProps.get(name);
            if (value != null) {
                ss.add("-X" + name + "=" + value);
                continue;
            }
            ss.add("-X" + name);
        }
        keys = this.plainProps.keySet();
        for (String name : keys) {
            value = this.plainProps.get(name);
            if (value != null) {
                ss.add("-" + name + "=" + value);
                continue;
            }
            ss.add("-" + name);
        }
        keys = this.sysProps.keySet();
        for (String name : keys) {
            value = this.sysProps.get(name);
            if (value != null) {
                ss.add("-D" + name + "=" + value);
                continue;
            }
            ss.add("-D" + name);
        }
        return this.postProcessOrdering(ss);
    }

    Map<String, String> getCombinedMap() {
        HashMap<String, String> all = new HashMap<String, String>(this.plainProps);
        all.putAll(this.xProps);
        all.putAll(this.xxProps);
        all.putAll(this.sysProps);
        return all;
    }

    int getOsgiPort() {
        return this.osgiPort;
    }

    private void addPlainProp(String s) {
        s = s.substring(1);
        NameValue nv = new NameValue(s);
        this.plainProps.put(nv.name, nv.value);
    }

    private void addSysProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.sysProps.put(nv.name, nv.value);
    }

    private void addXProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.xProps.put(nv.name, nv.value);
    }

    private void addXxProp(String s) {
        s = s.substring(3);
        NameValue nv = new NameValue(s);
        this.xxProps.put(nv.name, nv.value);
    }

    private void addModuleProp(String property) {
        this.moduleProps.add(property);
    }

    @Deprecated
    void addJvmLogging() {
        this.xxProps.put(":+UnlockDiagnosticVMOptions", null);
        this.xxProps.put(":+LogVMOutput", null);
        this.xxProps.put(":LogFile", "${com.sun.aas.instanceRoot}/logs/jvm.log");
    }

    @Deprecated
    void removeJvmLogging() {
        this.xxProps.remove(":+UnlockDiagnosticVMOptions");
        this.xxProps.remove(":+LogVMOutput");
        this.xxProps.remove(":LogFile");
    }

    private List<String> postProcessOrdering(List<String> unsorted) {
        ArrayList<String> sorted = new ArrayList<String>(unsorted.size());
        for (String s : unsorted) {
            if (!this.hasMagic(s)) continue;
            sorted.add(s);
        }
        for (String s : unsorted) {
            if (this.hasMagic(s)) continue;
            sorted.add(s);
        }
        return sorted;
    }

    private boolean hasMagic(String s) {
        String magic = "-XX:+Unlock";
        return s != null && s.startsWith("-XX:+Unlock");
    }

    private void filter() {
        String key = "javax.management.builder.initial";
        String forbiddenStart = "com.sun.enterprise";
        String forbiddenEnd = "AppServerMBeanServerBuilder";
        String val = this.sysProps.get("javax.management.builder.initial");
        if (val != null && val.startsWith("com.sun.enterprise") && val.endsWith("AppServerMBeanServerBuilder")) {
            this.sysProps.remove("javax.management.builder.initial");
        }
        if (OS.isDarwin() && System.getProperty("java.vm.vendor").equals("Apple Inc.")) {
            Pattern pattern = Pattern.compile("d\\d+");
            boolean settingPresent = false;
            for (String propName : this.plainProps.keySet()) {
                Matcher m = pattern.matcher(propName);
                if (!m.matches()) continue;
                settingPresent = true;
            }
            if (!settingPresent) {
                this.addPlainProp("-d32");
            }
        }
    }

    private void setOsgiPort() {
        String s = this.sysProps.get("osgi.shell.telnet.port");
        if (!StringUtils.ok(s)) {
            return;
        }
        try {
            this.osgiPort = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class NameValue {
        private String name;
        private String value;

        NameValue(String s) {
            int index = s.indexOf(61);
            if (index < 0) {
                this.name = s;
            } else {
                this.name = s.substring(0, index);
                if (index + 1 < s.length()) {
                    this.value = s.substring(index + 1);
                }
            }
        }
    }
}

