/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import fish.payara.admin.monitor.cli.Constants;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-monitoring-level")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.monitoring.level")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-monitoring-level", description="Set Module Monitoring level")})
public class SetMonitoringLevel
implements AdminCommand {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="module", optional=false)
    private String moduleNames;
    @Param(name="level", optional=false)
    private String moduleMonitoringLevels;
    @Inject
    private Target targetUtil;
    @Inject
    private Logger logger;
    private MonitoringService monitoringService;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Config config = this.targetUtil.getConfig(this.target);
        if (config != null) {
            this.monitoringService = config.getMonitoringService();
        } else {
            actionReport.setMessage("Cound not find target: " + this.target);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (this.moduleNames != null && this.moduleMonitoringLevels != null) {
            String modifiedModuleNames = this.moduleNames.replace(":", ",");
            String modifiedModuleMonitoringLevels = this.moduleMonitoringLevels.replace(":", ",");
            List<String> moduleNameList = Arrays.asList(modifiedModuleNames.split(","));
            List<String> moduleLevelList = Arrays.asList(modifiedModuleMonitoringLevels.split(","));
            if (moduleNameList.size() == moduleLevelList.size()) {
                for (int i = 0; i < moduleLevelList.size(); ++i) {
                    boolean isValidMoudle = false;
                    ArrayList<String> validModuleList = new ArrayList<String>(Arrays.asList(Constants.validModuleNames));
                    final String moduleName = moduleNameList.get(i).trim().toLowerCase();
                    for (String module : validModuleList) {
                        if (!module.trim().equalsIgnoreCase(moduleName)) continue;
                        final String moduleLevel = moduleLevelList.get(i).trim().toUpperCase();
                        try {
                            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                                public Object run(MonitoringService monitoringServiceProxy) throws PropertyVetoException, TransactionFailure {
                                    monitoringServiceProxy.setMonitoringLevel(moduleName, moduleLevel);
                                    return monitoringServiceProxy;
                                }
                            }, (ConfigBeanProxy)this.monitoringService);
                        }
                        catch (TransactionFailure ex) {
                            this.logger.log(Level.WARNING, "Failed to execute the command set-monitoring-level: {0}", ex.getCause().getMessage());
                            actionReport.setMessage(ex.getCause().getMessage());
                            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        }
                        isValidMoudle = true;
                        break;
                    }
                    if (isValidMoudle) continue;
                    actionReport.setMessage(moduleNameList.get(i) + " isn't a valid Module name");
                    actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                actionReport.setMessage("Number of Module and Level entered doesn't match");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

