/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import fish.payara.admin.amx.config.AMXConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-monitoring-service-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.monitoring.service.configuration")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-monitoring-service-configuration", description="Set Monitoring Service Configuration")})
public class SetMonitoringServiceConfiguration
implements AdminCommand {
    @Param(name="enabled", optional=true, alias="monitoringEnabled")
    private Boolean monitoringEnabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="mbeansenabled", optional=true, alias="mbeanEnabled")
    private Boolean mbeanEnabled;
    @Deprecated
    @Param(name="amxenabled", optional=true, alias="amxEnabled")
    private Boolean amxEnabled;
    @Param(name="dtraceenabled", optional=true, alias="dtraceEnabled")
    private Boolean dtraceEnabled;
    @Inject
    protected Target targetUtil;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    private Logger logger;
    private MonitoringService monitoringService;
    private Config config;

    @Override
    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        this.config = this.targetUtil.getConfig(this.target);
        if (this.config != null) {
            this.monitoringService = this.config.getMonitoringService();
        } else {
            actionReport.setMessage("Cound not find target: " + this.target);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService monitoringServiceProxy) throws PropertyVetoException, TransactionFailure {
                    if (SetMonitoringServiceConfiguration.this.monitoringEnabled != null) {
                        monitoringServiceProxy.setMonitoringEnabled(String.valueOf(SetMonitoringServiceConfiguration.this.monitoringEnabled));
                    }
                    if (SetMonitoringServiceConfiguration.this.mbeanEnabled != null) {
                        monitoringServiceProxy.setMbeanEnabled(String.valueOf(SetMonitoringServiceConfiguration.this.mbeanEnabled));
                    }
                    if (SetMonitoringServiceConfiguration.this.dtraceEnabled != null) {
                        monitoringServiceProxy.setDtraceEnabled(String.valueOf(SetMonitoringServiceConfiguration.this.dtraceEnabled));
                    }
                    if (SetMonitoringServiceConfiguration.this.amxEnabled != null) {
                        AMXConfiguration amxConfiguration = (AMXConfiguration)SetMonitoringServiceConfiguration.this.config.getExtensionByType(AMXConfiguration.class);
                        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AMXConfiguration>(){

                            public Object run(AMXConfiguration amxConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                                amxConfigurationProxy.setEnabled(String.valueOf(SetMonitoringServiceConfiguration.this.amxEnabled));
                                return amxConfigurationProxy;
                            }
                        }, (ConfigBeanProxy)amxConfiguration);
                    }
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return monitoringServiceProxy;
                }
            }, (ConfigBeanProxy)this.monitoringService);
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Failed to execute the command set-monitoring-service-configuration: {0}", ex.getCause().getMessage());
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

