/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import jakarta.ejb.EJBException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;

public class EjbExceptionMapper
implements ExtendedExceptionMapper<EJBException> {
    private final Provider<ExceptionMappers> mappers;

    @Inject
    public EjbExceptionMapper(Provider<ExceptionMappers> mappers) {
        this.mappers = mappers;
    }

    public Response toResponse(EJBException exception) {
        return this.causeToResponse(exception);
    }

    public boolean isMappable(EJBException exception) {
        try {
            return this.causeToResponse(exception) != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private Response causeToResponse(EJBException exception) {
        Exception cause = exception.getCausedByException();
        if (cause != null) {
            ExceptionMapper mapper = ((ExceptionMappers)this.mappers.get()).findMapping((Throwable)cause);
            if (mapper != null && mapper != this) {
                return mapper.toResponse((Throwable)cause);
            }
            if (cause instanceof WebApplicationException) {
                return ((WebApplicationException)cause).getResponse();
            }
        }
        return null;
    }
}

