/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.healthcheck.mphealth;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.healthcheck.mphealth.MicroProfileHealthChecker;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.configuration.MicroProfileHealthCheckerConfiguration;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-healthcheck-microprofile-health-checker-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.mphealthecheck.configure")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="healthcheck-mp-configure", description="Configures the Microprofile Healthcheck Checker")})
public class SetMicroProfileHealthCheckerConfiguration
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger("HEALTHCHECK-MP");
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="add-to-microprofile-health", alias="addToMicroProfileHealth", optional=true, defaultValue="false")
    private Boolean addToMicroProfileHealth;
    @Param(name="time", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private @Min(value=1L, message="Time period must be 1 or more") String time;
    @Param(name="unit", optional=true, acceptableValues="DAYS,HOURS,MICROSECONDS,MILLISECONDS,MINUTES,NANOSECONDS,SECONDS")
    private String unit;
    @Param(name="checkerName", optional=true)
    private String checkerName;
    @Param(name="timeout", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private @Min(value=1L, message="Time period must be 1 or more") String timeout;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Inject
    ServerEnvironment server;

    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Config config = this.targetUtil.getConfig(this.target);
        MicroProfileHealthChecker service = (MicroProfileHealthChecker)((Object)this.habitat.getService(MicroProfileHealthChecker.class, new Annotation[0]));
        if (service == null) {
            actionReport.appendMessage("Microprofile Healthcheck Checker Service could not be found");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            HealthCheckServiceConfiguration healthCheckServiceConfiguration = (HealthCheckServiceConfiguration)config.getExtensionByType(HealthCheckServiceConfiguration.class);
            MicroProfileHealthCheckerConfiguration healthCheckerConfiguration = (MicroProfileHealthCheckerConfiguration)healthCheckServiceConfiguration.getCheckerByType(MicroProfileHealthCheckerConfiguration.class);
            if (healthCheckerConfiguration == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        MicroProfileHealthCheckerConfiguration checkerProxy = (MicroProfileHealthCheckerConfiguration)healthCheckServiceConfigurationProxy.createChild(MicroProfileHealthCheckerConfiguration.class);
                        SetMicroProfileHealthCheckerConfiguration.this.applyValues(checkerProxy);
                        healthCheckServiceConfigurationProxy.getCheckerList().add(checkerProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, (ConfigBeanProxy)healthCheckServiceConfiguration);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MicroProfileHealthCheckerConfiguration>(){

                    public Object run(MicroProfileHealthCheckerConfiguration hoggingThreadConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        SetMicroProfileHealthCheckerConfiguration.this.applyValues(hoggingThreadConfigurationProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return hoggingThreadConfigurationProxy;
                    }
                }, (ConfigBeanProxy)healthCheckerConfiguration);
            }
            if (this.dynamic.booleanValue()) {
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        MicroProfileHealthCheckerConfiguration checkerByType = (MicroProfileHealthCheckerConfiguration)healthCheckServiceConfiguration.getCheckerByType(MicroProfileHealthCheckerConfiguration.class);
                        service.setOptions(service.constructOptions(checkerByType));
                        this.healthCheckService.registerCheck(checkerByType.getName(), (BaseHealthCheck)service);
                        this.healthCheckService.reboot();
                    }
                } else {
                    MicroProfileHealthCheckerConfiguration checkerByType = (MicroProfileHealthCheckerConfiguration)healthCheckServiceConfiguration.getCheckerByType(MicroProfileHealthCheckerConfiguration.class);
                    service.setOptions(service.constructOptions(healthCheckerConfiguration));
                    this.healthCheckService.registerCheck(checkerByType.getName(), (BaseHealthCheck)service);
                    this.healthCheckService.reboot();
                }
            }
        }
        catch (TransactionFailure ex) {
            LOGGER.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void applyValues(MicroProfileHealthCheckerConfiguration checkerProxy) throws PropertyVetoException {
        if (this.enabled != null) {
            checkerProxy.setEnabled(this.enabled.toString());
        }
        if (this.addToMicroProfileHealth != null) {
            checkerProxy.setAddToMicroProfileHealth(this.addToMicroProfileHealth.toString());
        }
        if (this.checkerName != null) {
            checkerProxy.setName(this.checkerName);
        }
        if (this.time != null) {
            checkerProxy.setTime(this.time);
        }
        if (this.unit != null) {
            checkerProxy.setUnit(this.unit);
        }
        if (this.timeout != null) {
            checkerProxy.setTimeout(this.timeout);
        }
    }
}

