/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.endpoint;

import com.sun.enterprise.security.ee.auth.login.ProgrammaticLogin;
import fish.payara.ejb.http.endpoint.EjbOverHttpResource;
import fish.payara.ejb.http.endpoint.EjbOverHttpService;
import fish.payara.ejb.http.protocol.ErrorResponse;
import fish.payara.ejb.http.protocol.InvokeMethodRequest;
import fish.payara.ejb.http.protocol.InvokeMethodResponse;
import fish.payara.ejb.http.protocol.LookupRequest;
import fish.payara.ejb.http.protocol.LookupResponse;
import jakarta.json.bind.JsonbBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.BiFunction;
import javax.naming.NamingException;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class EjbOverHttpResource {
    private static final String INVOKER_V1_REL = "https://payara.fish/ejb-http-invoker/v1";
    private static final String INVOKER_V0_REL = "https://payara.fish/ejb-http-invoker/v0";
    private final EjbOverHttpService service;

    public EjbOverHttpResource() {
        this((EjbOverHttpService)new /* Unavailable Anonymous Inner Class!! */);
    }

    public EjbOverHttpResource(EjbOverHttpService backend) {
        this.service = backend;
    }

    @HEAD
    public Response discover() {
        return Response.ok().link("jndi/lookup", "https://payara.fish/ejb-http-invoker/v1").link("ejb/lookup", "https://payara.fish/ejb-http-invoker/v0").build();
    }

    @POST
    @Path(value="jndi/lookup")
    @Produces(value={"application/x-java-object"})
    @Consumes(value={"application/x-java-object"})
    public Response lookupJavaSerialization(LookupRequest body) {
        return this.lookup(body, "application/x-java-object");
    }

    @POST
    @Path(value="jndi/lookup")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response lookupJsonb(LookupRequest body) {
        return this.lookup(body, "application/json");
    }

    private Response lookup(LookupRequest body, String mediaType) {
        try {
            return Response.status((Response.Status)Response.Status.CREATED).type(mediaType).location(new URI("jndi/invoke")).entity((Object)this.doLookup(body)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(mediaType).entity((Object)new ErrorResponse((Throwable)e)).build();
        }
    }

    @POST
    @Path(value="jndi/invoke")
    @Produces(value={"application/x-java-object"})
    @Consumes(value={"application/x-java-object"})
    public Response invokeJavaSerilaization(InvokeMethodRequest body) {
        return this.invoke(body, "application/x-java-object", (type, result) -> result);
    }

    @POST
    @Path(value="jndi/invoke")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response invokeJsonb(InvokeMethodRequest body) {
        return this.invoke(body, "application/json", (arg_0, arg_1) -> this.serializeToJsonb(arg_0, arg_1));
    }

    private Reader serializeToJsonb(Type returnType, InvokeMethodResponse result) {
        StringWriter output = new StringWriter();
        output.append("{\"type\":\"").append(result.type).append("\"");
        if (result != null) {
            output.append(",\"result\":");
            JsonbBuilder.create().toJson(result.result, returnType, (Writer)output);
        }
        output.append("}");
        return new StringReader(output.toString());
    }

    private Response invoke(InvokeMethodRequest body, String mediaType, BiFunction<Type, InvokeMethodResponse, Object> resultSerializer) {
        try {
            return Response.status((Response.Status)Response.Status.OK).type(mediaType).entity(this.doInvoke(body, resultSerializer)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(mediaType).entity((Object)new ErrorResponse((Throwable)e)).build();
        }
    }

    private LookupResponse doLookup(LookupRequest request) throws Exception {
        String jndiName = request.jndiName;
        return (LookupResponse)this.excuteInAppContext(jndiName, ejb -> {
            int bangIndex = jndiName.indexOf(33);
            if (bangIndex > 0) {
                String className = jndiName.substring(bangIndex + 1);
                try {
                    return new LookupResponse(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
                }
                catch (ClassNotFoundException ex) {
                    NamingException nex = new NamingException("Unknown class: " + className);
                    nex.initCause(ex);
                    throw nex;
                }
            }
            return new LookupResponse(ejb.getClass().getInterfaces()[0]);
        });
    }

    private Object doInvoke(InvokeMethodRequest request, BiFunction<Type, InvokeMethodResponse, Object> resultMapper) throws Exception {
        return this.excuteInAppContext(request.jndiName, ejb -> {
            if (!request.principal.isEmpty()) {
                new ProgrammaticLogin().login(EjbOverHttpResource.base64Decode((String)request.principal), EjbOverHttpResource.base64Decode((String)request.credentials), null, true);
            }
            Class[] argTypes = EjbOverHttpResource.toClasses((String[])request.argTypes);
            Type[] argActualTypes = EjbOverHttpResource.toClasses((String[])request.argActualTypes);
            Method method = EjbOverHttpResource.findBusinessMethodDeclaration((Object)ejb, (String)request.method, (Class[])argTypes);
            Object result = method.invoke(ejb, request.argDeserializer.deserialise(request.argValues, method, argActualTypes, Thread.currentThread().getContextClassLoader()));
            return resultMapper.apply(method.getGenericReturnType(), new InvokeMethodResponse(result));
        });
    }

    private static Class<?>[] toClasses(String[] classNames) {
        return (Class[])Arrays.asList(classNames).stream().map(EjbOverHttpResource::toClass).toArray(Class[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T excuteInAppContext(String jndiName, EjbOperation<T> operation) throws Exception {
        if (!jndiName.startsWith("java:global/")) {
            throw new NamingException("Only global names are supported but got: " + jndiName);
        }
        if (jndiName.indexOf(47, 12) < 0) {
            throw new NamingException("Global name must contain application name but got: " + jndiName);
        }
        Thread currentThread = Thread.currentThread();
        String applicationName = jndiName.substring(12, jndiName.indexOf(47, 12));
        ClassLoader existingContextClassLoader = currentThread.getContextClassLoader();
        ClassLoader appClassLoader = this.service.getAppClassLoader(applicationName);
        if (appClassLoader == null) {
            throw new NamingException("Unknown application: " + applicationName);
        }
        try {
            currentThread.setContextClassLoader(appClassLoader);
            Object bean = this.service.getBean(jndiName);
            Object object = operation.execute(bean);
            return (T)object;
        }
        finally {
            if (existingContextClassLoader != null) {
                currentThread.setContextClassLoader(existingContextClassLoader);
            }
        }
    }

    private static String base64Decode(String input) {
        return new String(Base64.getDecoder().decode(input));
    }

    private static Class<?> toClass(String name) {
        try {
            switch (name) {
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Method findBusinessMethodDeclaration(Object ejb, String methodName, Class<?>[] argTypeClasses) throws NoSuchMethodException {
        for (Class<?> intf : ejb.getClass().getInterfaces()) {
            try {
                return intf.getMethod(methodName, argTypeClasses);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new NoSuchMethodException("No method matching " + methodName + "(" + Arrays.toString(argTypeClasses) + ") found in business interface");
    }
}

