/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.PersistentTimerService;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerServiceConfigListener;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EJBTimerTask;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.NonPersistentEJBTimerService;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.logging.LogDomains;
import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.healthcheck.stuck.StuckThreadsStore;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.FinderException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.TimerConfig;
import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbTimerService;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.ScheduledTimerDescriptor;
import org.glassfish.internal.api.Globals;
import org.glassfish.server.ServerEnvironmentImpl;

public abstract class EJBTimerService {
    protected EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
    private long nextTimerIdMillis_ = 0L;
    private long nextTimerIdCounter_ = 0L;
    protected String domainName_;
    protected boolean isDas;
    private static final String TIMER_ID_SEP = "@@";
    protected String ownerIdOfThisServer_;
    protected TimerCache timerCache_;
    private boolean shutdown_ = false;
    private RequestTracingService requestTracing;
    private StuckThreadsStore stuckThreadsStore;
    protected long totalTimedObjectsInitialized_ = 0L;
    static final Logger logger = LogDomains.getLogger(EJBTimerService.class, (String)"javax.enterprise.system.container.ejb");
    public static final int STATE_ACTIVE = 0;
    public static final int STATE_CANCELLED = 1;
    private static final int MAX_REDELIVERIES = 1;
    private static final long REDELIVERY_INTERVAL = 5000L;
    private long minimumDeliveryInterval_ = 1000L;
    private long maxRedeliveries_ = 1L;
    private long redeliveryInterval_ = 5000L;
    private static final String TIMER_SERVICE_DOWNTIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private final Agent agent = this.ejbContainerUtil.getCallFlowAgent();
    private static final String RESCHEDULE_FAILED_TIMER = "reschedule-failed-timer";
    private boolean rescheduleFailedTimer = false;
    private static final Object LOCK = new Object();
    private static volatile boolean persistentTimerServiceVerified = false;
    private static volatile boolean nonPersistentTimerServiceVerified = false;
    private static EJBTimerService persistentTimerService;
    private static EJBTimerService nonPersistentTimerService;

    protected EJBTimerService() throws Exception {
        this.timerCache_ = new TimerCache();
        ServerEnvironmentImpl env = this.ejbContainerUtil.getServerEnvironment();
        this.ownerIdOfThisServer_ = env.getInstanceName();
        this.domainName_ = env.getDomainName();
        this.isDas = env.isDas() || env.isEmbedded();
        this.requestTracing = (RequestTracingService)Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        this.stuckThreadsStore = (StuckThreadsStore)Globals.getDefaultHabitat().getService(StuckThreadsStore.class, new Annotation[0]);
        this.initProperties();
    }

    public static EJBTimerServiceWrapper getEJBTimerServiceWrapper(EJBContextImpl ejbContext) {
        if (Objects.isNull(persistentTimerService) && Objects.isNull(nonPersistentTimerService)) {
            if (!nonPersistentTimerServiceVerified) {
                EJBTimerService.initNonPersistentTimerService(null, true);
            } else {
                throw new IllegalStateException("EJB Timer Service not available");
            }
        }
        return new EJBTimerServiceWrapper(persistentTimerService, nonPersistentTimerService, ejbContext);
    }

    protected static void setPersistentTimerService(EJBTimerService timerService) {
        persistentTimerService = timerService;
    }

    protected static void setNonPersistentTimerService(EJBTimerService timerService) {
        nonPersistentTimerService = timerService;
    }

    static void unsetEJBTimerService() {
        persistentTimerServiceVerified = false;
        persistentTimerService = null;
        nonPersistentTimerServiceVerified = false;
        nonPersistentTimerService = null;
    }

    public static EJBTimerService getPersistentTimerService() {
        return EJBTimerService.getEJBTimerService(null, false, true);
    }

    public static EJBTimerService getNonPersistentTimerService() {
        return EJBTimerService.getEJBTimerService(null, false, false);
    }

    public static boolean isPersistentTimerServiceLoaded() {
        return persistentTimerServiceVerified;
    }

    public static boolean isNonPersistentTimerServiceLoaded() {
        return nonPersistentTimerServiceVerified;
    }

    public static EJBTimerService getEJBTimerService(boolean persistent) {
        return EJBTimerService.getEJBTimerService(null, true, persistent);
    }

    public static EJBTimerService getEJBTimerService(String target) {
        return EJBTimerService.getEJBTimerService(target, true, true);
    }

    public static EJBTimerService getEJBTimerService(String target, boolean force) {
        return EJBTimerService.getEJBTimerService(target, force, true);
    }

    public static EJBTimerService getEJBTimerService(String target, boolean force, boolean persistent) {
        if (persistent) {
            if (!persistentTimerServiceVerified) {
                EJBTimerService.initPersistentTimerService(target, force);
            }
            return persistentTimerService;
        }
        if (!nonPersistentTimerServiceVerified) {
            EJBTimerService.initNonPersistentTimerService(target, force);
        }
        return nonPersistentTimerService;
    }

    public abstract boolean isPersistent();

    public abstract int migrateTimers(String var1);

    protected abstract void resetEJBTimers(String var1);

    protected abstract void stopTimers(long var1);

    protected abstract Collection<TimerPrimaryKey> getTimerIds(long var1, Object var3);

    protected abstract Collection<TimerPrimaryKey> getTimerIds(Collection<Long> var1);

    protected abstract void cancelTimersByKey(long var1, Object var3);

    protected abstract void cancelTimer(TimerPrimaryKey var1) throws FinderException, Exception;

    protected abstract Date getNextTimeout(TimerPrimaryKey var1) throws FinderException;

    protected abstract Serializable getInfo(TimerPrimaryKey var1) throws FinderException;

    protected abstract boolean isPersistent(TimerPrimaryKey var1) throws FinderException;

    protected abstract boolean timerExists(TimerPrimaryKey var1);

    protected abstract EJBTimerSchedule getTimerSchedule(TimerPrimaryKey var1) throws FinderException;

    protected abstract boolean isValidTimerForThisServer(TimerPrimaryKey var1, RuntimeTimerState var2);

    protected abstract void resetLastExpiration(TimerPrimaryKey var1, RuntimeTimerState var2);

    public abstract Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsByThisServer();

    private static synchronized void initNonPersistentTimerService(String target, boolean force) {
        if (nonPersistentTimerService == null) {
            try {
                nonPersistentTimerService = new NonPersistentEJBTimerService();
                nonPersistentTimerServiceVerified = true;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Cannot start non-persistent EJBTimerService: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initPersistentTimerService(String target, boolean force) {
        if (persistentTimerService == null) {
            EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
            String serviceType = ejbContainerUtil.getEjbContainer().getEjbTimerService().getEjbTimerService();
            List persistentTSList = EjbContainerUtilImpl.getInstance().getServices().getAllServices(PersistentTimerService.class, new Annotation[0]);
            if (persistentTSList.isEmpty() || "None".equals(serviceType)) {
                try {
                    persistentTimerService = new NonPersistentEJBTimerService();
                    persistentTimerServiceVerified = true;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Cannot start persistent EJBTimerService: ", e);
                }
            } else {
                Object object = LOCK;
                synchronized (object) {
                    PersistentTimerService persistentTS = null;
                    for (PersistentTimerService pts : persistentTSList) {
                        if (!pts.getClass().getSimpleName().startsWith(serviceType)) continue;
                        persistentTS = pts;
                        break;
                    }
                    if (persistentTS != null) {
                        persistentTS.initPersistentTimerService(target);
                    } else {
                        try {
                            persistentTimerService = new NonPersistentEJBTimerService();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Cannot start persistent EJBTimerService: ", e);
                        }
                    }
                    persistentTimerServiceVerified = true;
                }
                if (persistentTimerService != null) {
                    persistentTimerService.resetEJBTimers(target);
                } else if (!force) {
                    persistentTimerServiceVerified = false;
                }
            }
        }
    }

    private void initProperties() {
        try {
            EjbContainer ejbc = this.ejbContainerUtil.getEjbContainer();
            EjbTimerService ejbt = ejbc.getEjbTimerService();
            if (ejbt != null) {
                long val;
                String valString = ejbt.getMinimumDeliveryIntervalInMillis();
                long l = val = valString != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.minimumDeliveryInterval_ = val;
                }
                long l2 = val = (valString = ejbt.getMaxRedeliveries()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.maxRedeliveries_ = val;
                }
                long l3 = val = (valString = ejbt.getRedeliveryIntervalInternalInMillis()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.redeliveryInterval_ = val;
                }
                this.rescheduleFailedTimer = Boolean.valueOf(ejbt.getPropertyValue(RESCHEDULE_FAILED_TIMER));
                this.ejbContainerUtil.getServices().getService(EJBTimerServiceConfigListener.class, new Annotation[0]);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception converting timer service domain.xml properties.  Defaults will be used instead.", e);
        }
        logger.log(Level.FINE, "EJB Timer Service properties : min delivery interval = " + this.getMinimumDeliveryInterval() + "\nmax redeliveries = " + this.maxRedeliveries_ + "\nredelivery interval = " + this.getRedeliveryInterval());
    }

    synchronized void timedObjectCount() {
        ++this.totalTimedObjectsInitialized_;
    }

    public String getOwnerIdOfThisServer() {
        return this.ownerIdOfThisServer_;
    }

    public String[] listTimers(String[] serverIds) {
        String[] result = new String[serverIds.length];
        for (int i = 0; i < serverIds.length; ++i) {
            result[i] = "0";
        }
        return result;
    }

    protected EJBException createEJBException(Exception ex) {
        EJBException ejbEx = new EJBException();
        ejbEx.initCause(ex);
        return ejbEx;
    }

    protected void addToSchedules(long containerId, TimerPrimaryKey timerId, EJBTimerSchedule ts) {
        BaseContainer container = this.getContainer(containerId);
        if (container != null) {
            container.addSchedule(timerId, ts);
        }
    }

    private void shutdown() {
        this.shutdown_ = true;
    }

    public void destroyTimers(long containerId) {
        this._destroyTimers(containerId, false);
    }

    public void destroyAllTimers(long applicationId) {
        this._destroyTimers(applicationId, true);
    }

    protected void _destroyTimers(long id, boolean all) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimers(Set<TimerPrimaryKey> timerIds) {
        for (TimerPrimaryKey nextTimerId : timerIds) {
            RuntimeTimerState nextTimerState = null;
            try {
                nextTimerState = this.getTimerState(nextTimerId);
                if (nextTimerState == null) continue;
                RuntimeTimerState runtimeTimerState = nextTimerState;
                synchronized (runtimeTimerState) {
                    if (nextTimerState.isScheduled()) {
                        EJBTimerTask timerTask = nextTimerState.getCurrentTimerTask();
                        timerTask.cancel();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.destroy_timer_error", new Object[]{nextTimerId});
                logger.log(Level.WARNING, "", e);
            }
            finally {
                if (nextTimerState == null) continue;
                this.timerCache_.removeTimer(nextTimerId);
            }
        }
    }

    private void rescheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, true);
    }

    protected void scheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTask(TimerPrimaryKey timerId, Date expiration, boolean rescheduled) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                Date cutoff;
                Date timerExpiration = expiration;
                if (!rescheduled && expiration.before(cutoff = new Date(new Date().getTime() + this.getMinimumDeliveryInterval()))) {
                    timerExpiration = cutoff;
                }
                EJBTimerTask timerTask = new EJBTimerTask(timerExpiration, timerId, this);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, (rescheduled ? "RE-" : "") + "Scheduling " + timerState + " for timeout at " + timerExpiration);
                }
                if (rescheduled) {
                    timerState.rescheduled(timerTask);
                } else {
                    timerState.scheduled(timerTask);
                }
                Timer jdkTimer = this.ejbContainerUtil.getTimer();
                jdkTimer.schedule((TimerTask)timerTask, timerExpiration);
            }
        } else {
            logger.log(Level.FINE, "No timer state found for " + (rescheduled ? "RE-schedule" : "schedule") + " request of " + timerId + " for timeout at " + expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date cancelTask(TimerPrimaryKey timerId) {
        Date timeout = null;
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isCreated()) {
                    timeout = timerState.getInitialExpiration();
                } else if (timerState.isScheduled()) {
                    EJBTimerTask timerTask = timerState.getCurrentTimerTask();
                    timeout = timerTask.getTimeout();
                    timerTask.cancel();
                }
                timerState.cancelled();
            }
        } else {
            logger.log(Level.FINE, "No timer state found for cancelTask request of " + timerId);
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTaskToDelivered(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                timerState.restoredToDelivered();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Restoring " + timerId + " to delivered state after it was cancelled and  rolled back from within its own ejbTimeout method");
            }
        } else {
            logger.log(Level.FINE, "No timer state found for restoreTaskToDelivered request of " + timerId);
        }
    }

    private void expungeTimer(TimerPrimaryKey timerId) {
        this.expungeTimer(timerId, false);
    }

    protected Date calcNextFixedRateExpiration(RuntimeTimerState timerState) {
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException("Timer " + timerState + " is not a periodic timer");
        }
        EJBTimerSchedule ts = timerState.getTimerSchedule();
        if (ts != null) {
            return this.getNextScheduledTimeout(ts);
        }
        Date initialExpiration = timerState.getInitialExpiration();
        long intervalDuration = timerState.getIntervalDuration();
        return this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
    }

    protected Date calcNextFixedRateExpiration(Date initialExpiration, long intervalDuration) {
        Date now = new Date();
        long nowMillis = now.getTime();
        Date nextExpirationTime = initialExpiration;
        if (now.after(initialExpiration)) {
            long timeSinceInitialExpire = nowMillis - initialExpiration.getTime();
            long numIntervals = timeSinceInitialExpire / intervalDuration;
            nextExpirationTime = new Date(initialExpiration.getTime() + (numIntervals + 1L) * intervalDuration);
        }
        return nextExpirationTime;
    }

    protected void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        this.timerCache_.removeTimer(timerId);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, long initialDuration, long intervalDuration, TimerConfig timerConfig) throws CreateException {
        Date now = new Date();
        Date initialExpiration = new Date(now.getTime() + initialDuration);
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, initialExpiration, intervalDuration, timerConfig);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, initialExpiration, intervalDuration, null, timerConfig);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, EJBTimerSchedule schedule, TimerConfig timerConfig, String server_name) throws CreateException {
        return this.createTimer(containerId, applicationId, null, null, 0L, schedule, timerConfig, server_name);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, EJBTimerSchedule schedule, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, null, 0L, schedule, timerConfig, this.ownerIdOfThisServer_);
    }

    private TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, initialExpiration, intervalDuration, schedule, timerConfig, this.ownerIdOfThisServer_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig, String server_name) throws CreateException {
        RuntimeTimerState timerState;
        BaseContainer container = this.getContainer(containerId);
        boolean startTimers = this.ownerIdOfThisServer_.equals(server_name);
        if (startTimers) {
            if (container == null) {
                throw new CreateException("invalid container id " + containerId + " in createTimer request");
            }
            Class ejbClass = container.getEJBClass();
            if (!container.isTimedObject()) {
                throw new CreateException("Attempt to create an EJB Timer from a bean that is not a Timed Object.  EJB class " + ejbClass + " must implement jakarta.ejb.TimedObject or  annotation a timeout method with @Timeout");
            }
        }
        TimerPrimaryKey timerId = new TimerPrimaryKey(this.getNextTimerId());
        if (schedule != null) {
            Calendar next = schedule.getNextTimeout();
            initialExpiration = !schedule.isValid(next) ? new Date() : next.getTime();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "@@@ Created timer [" + timerId + "] with the first expiration set to: " + initialExpiration);
        }
        if (timerConfig == null) {
            timerConfig = new TimerConfig();
        }
        RuntimeTimerState runtimeTimerState = timerState = new RuntimeTimerState(timerId, initialExpiration, intervalDuration, containerId, container, timedObjectPrimaryKey, schedule, timerConfig.getInfo(), timerConfig.isPersistent());
        synchronized (runtimeTimerState) {
            if (startTimers) {
                this.timerCache_.addTimer(timerId, timerState);
            }
            try {
                this._createTimer(timerId, containerId, applicationId, timedObjectPrimaryKey, server_name, initialExpiration, intervalDuration, schedule, timerConfig);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ejb.create_timer_failure", new Object[]{String.valueOf(containerId), timedObjectPrimaryKey, timerConfig.getInfo()});
                logger.log(Level.SEVERE, "", e);
                this.timerCache_.removeTimer(timerId);
                if (e instanceof CreateException) {
                    throw (CreateException)e;
                }
                EJBException ejbEx = new EJBException();
                ejbEx.initCause(e);
                throw ejbEx;
            }
        }
        return timerId;
    }

    protected void _createTimer(TimerPrimaryKey timerId, long containerId, long applicationId, Object timedObjectPrimaryKey, String server_name, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws Exception {
        if (timerConfig.isPersistent()) {
            throw new CreateException("Persistent timers are not supported in this setup");
        }
        this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
    }

    protected Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, long applicationId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        try {
            this.createSchedules(containerId, applicationId, schedules, result, this.ownerIdOfThisServer_, true, deploy && this.isDas);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        return result;
    }

    public void createSchedulesOnServer(EjbDescriptor ejbDescriptor, String server_name) {
        for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
            if (schd.getTimeoutMethod() == null || !schd.getPersistent()) continue;
            throw new RuntimeException("EJB " + ejbDescriptor.getName() + " uses persistent EJB Timer Service. This feature is not part of the EJB Lite API");
        }
    }

    public void createSchedules(long containerId, long applicationId, Map<MethodDescriptor, List<ScheduledTimerDescriptor>> methodDescriptorSchedules, String server_name) {
        try {
            this.createSchedules(containerId, applicationId, methodDescriptorSchedules, null, server_name, false, true);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
    }

    protected void createSchedules(long containerId, long applicationId, Map<?, List<ScheduledTimerDescriptor>> schedules, Map<TimerPrimaryKey, Method> result, String server_name, boolean startTimers, boolean deploy) throws Exception {
        for (Map.Entry<?, List<ScheduledTimerDescriptor>> entry : schedules.entrySet()) {
            Object key = entry.getKey();
            String mname = null;
            int args_length = 0;
            if (key instanceof Method) {
                mname = ((Method)key).getName();
                args_length = ((Method)key).getParameterTypes().length;
            } else {
                mname = ((MethodDescriptor)key).getName();
                args_length = ((MethodDescriptor)key).getJavaParameterClassNames().length;
            }
            for (ScheduledTimerDescriptor sch : entry.getValue()) {
                boolean persistent = sch.getPersistent();
                if (persistent && !deploy || !persistent && !startTimers) continue;
                EJBTimerSchedule ts = new EJBTimerSchedule(sch, mname, args_length);
                TimerConfig tc = new TimerConfig();
                String info = sch.getInfo();
                if (info != null && !info.equals("")) {
                    tc.setInfo((Serializable)((Object)info));
                }
                tc.setPersistent(persistent);
                TimerPrimaryKey tpk = this.createTimer(containerId, applicationId, ts, tc, server_name);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "@@@ CREATED new schedule: " + ts.getScheduleAsString() + " FOR method: " + key);
                }
                if (!startTimers || result == null) continue;
                result.put(tpk, (Method)key);
            }
        }
    }

    public ClassLoader getTimerClassLoader(long containerId) {
        BaseContainer container = this.getContainer(containerId);
        return container != null ? container.getClassLoader() : null;
    }

    protected RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getTimerState(timerId);
    }

    protected Date _getNextTimeout(RuntimeTimerState rt) {
        Date initialExpiration = rt.getInitialExpiration();
        long intervalDuration = rt.getIntervalDuration();
        EJBTimerSchedule ts = rt.getTimerSchedule();
        Date nextTimeout = initialExpiration;
        if (ts != null) {
            nextTimeout = this.getNextScheduledTimeout(ts);
        } else if (intervalDuration > 0L) {
            nextTimeout = this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
        }
        return nextTimeout;
    }

    ScheduleExpression getScheduleExpression(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = this.getTimerSchedule(timerId);
        return ts == null ? null : ts.getScheduleExpression();
    }

    boolean isCalendarTimer(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = this.getTimerSchedule(timerId);
        return ts != null;
    }

    protected BaseContainer getContainer(long containerId) {
        return this.ejbContainerUtil.getContainer(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTimeout(TimerPrimaryKey timerId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService.deliverTimeout(): work thread is processing work for timerId = " + timerId);
        }
        if (this.shutdown_) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown.  Expiration  will occur when server is restarted.");
            }
            return;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState == null) {
            logger.log(Level.FINE, "Timer state is NULL for timer " + timerId + " in deliverTimeout");
            return;
        }
        BaseContainer container = this.getContainer(timerState.getContainerId());
        RuntimeTimerState runtimeTimerState = timerState;
        synchronized (runtimeTimerState) {
            if (container == null) {
                logger.log(Level.FINE, "Unknown container for timer " + timerId + " in deliverTimeout.  Expunging timer.");
                this.expungeTimer(timerId, true);
                return;
            }
            if (!timerState.isBeingDelivered()) {
                logger.log(Level.FINE, "Timer state = " + timerState.stateToString() + "for timer " + timerId + " before callEJBTimeout");
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Calling ejbTimeout for timer " + timerState);
            }
        }
        try {
            boolean redeliver;
            this.agent.requestStart(RequestType.TIMER_EJB);
            container.onEnteringContainer();
            if (this.isCancelledByAnotherInstance(timerState)) {
                return;
            }
            boolean bl = redeliver = timerState.isExpired() ? false : container.callEJBTimeout(timerState, this);
            if (this.shutdown_) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown. Expiration will  occur on server restart");
                }
                return;
            }
            timerState = this.getTimerState(timerId);
            if (timerState == null) {
                logger.log(Level.FINE, "Timer no longer exists for " + timerId + " after callEJBTimeout");
                return;
            }
            RuntimeTimerState runtimeTimerState2 = timerState;
            synchronized (runtimeTimerState2) {
                Date now = new Date();
                boolean reschedule = false;
                if (!timerState.isCancelled()) {
                    if (timerState.isExpired()) {
                        this.cancelTimer(timerId);
                    } else if (redeliver) {
                        int numDeliv = timerState.getNumFailedDeliveries() + 1;
                        if (this.redeliverTimeout(timerState)) {
                            Date redeliveryTimeout = new Date(now.getTime() + this.getRedeliveryInterval());
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Redelivering " + timerState);
                            }
                            this.rescheduleTask(timerId, redeliveryTimeout);
                        } else if (this.stopOnFailure()) {
                            this.shutdown();
                        } else if (this.rescheduleFailedTimer) {
                            logger.log(Level.INFO, "ejb.timer_reschedule_after_max_deliveries", new Object[]{timerState.toString(), numDeliv});
                            reschedule = true;
                        } else {
                            logger.log(Level.INFO, "ejb.timer_exceeded_max_deliveries", new Object[]{timerState.toString(), numDeliv});
                            this.expungeTimer(timerId, true);
                        }
                    } else {
                        reschedule = true;
                    }
                }
                if (reschedule && (redeliver || timerState.isPeriodic())) {
                    Date expiration = this.calcNextFixedRateExpiration(timerState);
                    if (expiration != null) {
                        this.scheduleTask(timerId, expiration);
                    } else {
                        this.cancelTimer(timerId);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "callEJBTimeout threw exception for timer id " + timerId, e);
            this.expungeTimer(timerId, true);
        }
        finally {
            container.onLeavingContainer();
            this.agent.requestEnd();
        }
    }

    protected boolean isCancelledByAnotherInstance(RuntimeTimerState timerState) {
        return false;
    }

    protected boolean redeliverTimeout(RuntimeTimerState timerState) {
        return (long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries();
    }

    protected boolean stopOnFailure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean postEjbTimeout(TimerPrimaryKey timerId) {
        boolean success = true;
        if (this.shutdown_) {
            return success;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            BaseContainer container = this.getContainer(timerState.getContainerId());
            container.incrementDeliveredTimedObject();
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (!timerState.isCancelled()) {
                    try {
                        if (!this.isValidTimerForThisServer(timerId, timerState)) {
                            return false;
                        }
                        if (timerState.isPeriodic()) {
                            this.resetLastExpiration(timerId, timerState);
                        } else {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Single-action timer " + timerState + " was successfully delivered.  Removing...");
                            }
                            this.cancelTimer(timerId);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Error in post-ejbTimeout timer processing for " + timerState, e);
                        success = false;
                    }
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskExpired(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isScheduled()) {
                    timerState.delivered();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Adding work pool task for timer " + timerId);
                    }
                    TaskExpiredWork work = new TaskExpiredWork(this, timerId, this.requestTracing, this.stuckThreadsStore);
                    this.ejbContainerUtil.addWork(work);
                } else {
                    logger.log(Level.FINE, "Timer " + timerId + " is not in scheduled state.  Current state = " + timerState.stateToString());
                }
            }
        } else {
            logger.log(Level.FINE, "null timer state for timer id " + timerId);
        }
    }

    private synchronized String getNextTimerId() {
        if (this.nextTimerIdCounter_ <= 0L) {
            this.nextTimerIdMillis_ = System.currentTimeMillis();
            this.nextTimerIdCounter_ = 1L;
        } else {
            ++this.nextTimerIdCounter_;
        }
        return this.nextTimerIdCounter_ + TIMER_ID_SEP + this.nextTimerIdMillis_ + TIMER_ID_SEP + this.ownerIdOfThisServer_ + TIMER_ID_SEP + this.domainName_;
    }

    private long getMinimumDeliveryInterval() {
        return this.minimumDeliveryInterval_;
    }

    protected long getMaxRedeliveries() {
        return this.maxRedeliveries_;
    }

    private long getRedeliveryInterval() {
        return this.redeliveryInterval_;
    }

    public void addTimerSynchronization(EJBContextImpl context_, String timerId, Date initialExpiration, long containerId, String ownerId) throws Exception {
        this.addTimerSynchronization(context_, timerId, initialExpiration, containerId, ownerId, true);
    }

    public void addTimerSynchronization(EJBContextImpl context_, String timerId, Date initialExpiration, long containerId, String ownerId, boolean persistent) throws Exception {
        if (context_ == null || this.timerOwnedByThisServer(ownerId)) {
            TimerPrimaryKey pk = new TimerPrimaryKey(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(context_, timerId, persistent);
            if (containerSynch == null) {
                this.scheduleTask(pk, initialExpiration);
                this.ejbContainerUtil.getContainer(containerId).incrementCreatedTimedObject();
            } else {
                TimerSynch timerSynch = new TimerSynch(pk, 0, initialExpiration, this.ejbContainerUtil.getContainer(containerId), this);
                containerSynch.addTimerSynchronization(pk, timerSynch);
            }
        }
    }

    public void cancelTimerSynchronization(EJBContextImpl context_, TimerPrimaryKey timerId, long containerId, String ownerId) throws Exception {
        this.cancelTimerSynchronization(context_, timerId, containerId, ownerId, true);
    }

    protected void cancelTimerSynchronization(EJBContextImpl context_, TimerPrimaryKey timerId, long containerId, String ownerId, boolean persistent) throws Exception {
        if (context_ == null || this.timerOwnedByThisServer(ownerId)) {
            Date nextTimeout = this.cancelTask(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(context_, timerId.getTimerId(), persistent);
            if (containerSynch == null) {
                this.expungeTimer(timerId);
                this.ejbContainerUtil.getContainer(containerId).incrementRemovedTimedObject();
            } else {
                Synchronization timerSynch = containerSynch.getTimerSynchronization(timerId);
                if (timerSynch != null) {
                    containerSynch.removeTimerSynchronization(timerId);
                    this.expungeTimer(timerId);
                } else {
                    timerSynch = new TimerSynch(timerId, 1, nextTimeout, this.ejbContainerUtil.getContainer(containerId), this);
                    containerSynch.addTimerSynchronization(timerId, timerSynch);
                }
            }
        }
    }

    protected void enableRescheduleTimers() {
        this.rescheduleFailedTimer = true;
    }

    private boolean timerOwnedByThisServer(String ownerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        return ownerIdOfThisServer != null && ownerIdOfThisServer.equals(ownerId);
    }

    protected Date getNextScheduledTimeout(EJBTimerSchedule ts) {
        Calendar next = ts.getNextTimeout();
        if (ts.isValid(next)) {
            return next.getTime();
        }
        return null;
    }

    ContainerSynchronization getContainerSynch(EJBContextImpl context_, String timerId, boolean persistent) throws Exception {
        Transaction transaction = null;
        if (context_ != null) {
            transaction = context_.getTransaction();
        }
        if (transaction == null) {
            ComponentInvocation i = this.ejbContainerUtil.getCurrentInvocation();
            if (i == null) {
                transaction = this.ejbContainerUtil.getTransactionManager().getTransaction();
            } else {
                transaction = (Transaction)i.getTransaction();
                if (context_ != null && transaction != null) {
                    logger.log(Level.WARNING, "Context transaction in TimerBean = null. Using invocation instead.");
                }
            }
        }
        if (transaction == null) {
            if (persistent) {
                throw new Exception("transaction = null in getContainerSynch for timerId = " + timerId);
            }
            return null;
        }
        return this.ejbContainerUtil.getContainerSync(transaction);
    }

    public static void onShutdown() {
        boolean shutdown = false;
        if (nonPersistentTimerService != null && !EJBTimerService.nonPersistentTimerService.shutdown_) {
            nonPersistentTimerService.shutdown();
            shutdown = true;
        }
        if (persistentTimerService != null && !EJBTimerService.persistentTimerService.shutdown_) {
            persistentTimerService.shutdown();
            shutdown = true;
        }
        if (shutdown) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(TIMER_SERVICE_DOWNTIME_FORMAT);
            String downTimeStr = dateFormat.format(new Date());
            logger.log(Level.INFO, "ejb.timer_service_shutdown_msg", new Object[]{downTimeStr});
        }
    }

    static String txStatusToString(int txStatus) {
        String txStatusStr = "UNMATCHED TX STATUS";
        switch (txStatus) {
            case 0: {
                txStatusStr = "TX_STATUS_ACTIVE";
                break;
            }
            case 3: {
                txStatusStr = "TX_STATUS_COMMITTED";
                break;
            }
            case 8: {
                txStatusStr = "TX_STATUS_COMMITTING";
                break;
            }
            case 1: {
                txStatusStr = "TX_STATUS_MARKED_ROLLBACK";
                break;
            }
            case 6: {
                txStatusStr = "TX_STATUS_NO_TRANSACTION";
                break;
            }
            case 2: {
                txStatusStr = "TX_STATUS_PREPARED";
                break;
            }
            case 7: {
                txStatusStr = "TX_STATUS_PREPARING";
                break;
            }
            case 4: {
                txStatusStr = "TX_STATUS_ROLLEDBACK";
                break;
            }
            case 9: {
                txStatusStr = "TX_STATUS_ROLLING_BACK";
                break;
            }
            case 5: {
                txStatusStr = "TX_STATUS_UNKNOWN";
                break;
            }
            default: {
                txStatusStr = "UNMATCHED TX STATUS";
            }
        }
        return txStatusStr;
    }

    public static String timerStateToString(int state) {
        String stateStr = "UNKNOWN_TIMER_STATE";
        switch (state) {
            case 0: {
                stateStr = "TIMER_ACTIVE";
                break;
            }
            case 1: {
                stateStr = "TIMER_CANCELLED";
                break;
            }
            default: {
                stateStr = "UNKNOWN_TIMER_STATE";
            }
        }
        return stateStr;
    }

    private static class TimerSynch
    implements Synchronization {
        private TimerPrimaryKey timerId_;
        private int state_;
        private Date timeout_;
        private BaseContainer container_;
        private EJBTimerService timerService_;

        public TimerSynch(TimerPrimaryKey timerId, int state, Date timeout, BaseContainer container, EJBTimerService timerService) {
            this.timerId_ = timerId;
            this.state_ = state;
            this.timeout_ = timeout;
            this.container_ = container;
            this.timerService_ = timerService;
        }

        @Override
        public void afterCompletion(int status) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "TimerSynch::afterCompletion. timer state = " + EJBTimerService.timerStateToString(this.state_) + " , timer id = " + this.timerId_ + " , JTA TX status = " + EJBTimerService.txStatusToString(status) + " , timeout = " + this.timeout_);
            }
            switch (this.state_) {
                case 0: {
                    if (status == 3) {
                        this.timerService_.scheduleTask(this.timerId_, this.timeout_);
                        this.container_.incrementCreatedTimedObject();
                        break;
                    }
                    this.timerService_.expungeTimer(this.timerId_);
                    break;
                }
                case 1: {
                    if (status == 4) {
                        if (this.timeout_ != null) {
                            this.timerService_.scheduleTask(this.timerId_, this.timeout_);
                            break;
                        }
                        this.timerService_.restoreTaskToDelivered(this.timerId_);
                        break;
                    }
                    this.timerService_.expungeTimer(this.timerId_);
                    this.container_.incrementRemovedTimedObject();
                    break;
                }
            }
        }

        @Override
        public void beforeCompletion() {
        }
    }

    private static class TaskExpiredWork
    implements Runnable {
        private EJBTimerService timerService_;
        private TimerPrimaryKey timerId_;
        private RequestTracingService requestTracing;
        private StuckThreadsStore stuckThreads;

        public TaskExpiredWork(EJBTimerService timerService, TimerPrimaryKey timerId, RequestTracingService rt, StuckThreadsStore stuckThreadStore) {
            this.timerService_ = timerService;
            this.timerId_ = timerId;
            this.requestTracing = rt;
            this.stuckThreads = stuckThreadStore;
        }

        @Override
        public void run() {
            if (this.stuckThreads != null) {
                this.stuckThreads.registerThread(Long.valueOf(Thread.currentThread().getId()));
            }
            if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
                RequestTraceSpan span = new RequestTraceSpan(EventType.TRACE_START, "executeEjbTimerTask");
                span.addSpanTag("TimerID", this.timerId_.toString());
                this.requestTracing.startTrace(span);
            }
            try {
                this.timerService_.deliverTimeout(this.timerId_);
            }
            finally {
                if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
                    this.requestTracing.endTrace();
                }
                if (this.stuckThreads != null) {
                    this.stuckThreads.deregisterThread(Thread.currentThread().getId());
                }
            }
        }
    }

    public static class TimerCache {
        private Map<TimerPrimaryKey, RuntimeTimerState> timers_ = new HashMap<TimerPrimaryKey, RuntimeTimerState>();
        private Map<Long, Object> containerTimers_ = new HashMap<Long, Object>();
        private Map<TimerPrimaryKey, RuntimeTimerState> nonpersistentTimers_ = new HashMap<TimerPrimaryKey, RuntimeTimerState>();

        public synchronized void addTimer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding timer {0}", timerState);
            }
            this.timers_.put(timerId, timerState);
            if (!timerState.isPersistent()) {
                this.nonpersistentTimers_.put(timerId, timerState);
            }
            Long containerId = timerState.getContainerId();
            Object containerInfo = this.containerTimers_.get(containerId);
            if (timerState.timedObjectIsEntity()) {
                ArrayList<Object> entityBeans;
                if (containerInfo == null) {
                    entityBeans = new ArrayList<Object>();
                    this.containerTimers_.put(containerId, entityBeans);
                } else {
                    entityBeans = (ArrayList<Object>)containerInfo;
                }
                entityBeans.add(timerState.getTimedObjectPrimaryKey());
            } else {
                Long timerCount = containerInfo == null ? 1L : (Long)containerInfo + 1L;
                this.containerTimers_.put(containerId, timerCount);
            }
        }

        public synchronized void removeTimer(TimerPrimaryKey timerId) {
            Long containerId;
            Object containerInfo;
            RuntimeTimerState timerState;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removing timer {0}", timerId);
            }
            if ((timerState = this.timers_.remove(timerId)) == null) {
                return;
            }
            if (!timerState.isPersistent()) {
                this.nonpersistentTimers_.remove(timerId);
            }
            if ((containerInfo = this.containerTimers_.get(containerId = Long.valueOf(timerState.getContainerId()))) != null) {
                if (timerState.timedObjectIsEntity()) {
                    Collection entityBeans = (Collection)containerInfo;
                    if (entityBeans.size() == 1) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        entityBeans.remove(timerState.getTimedObjectPrimaryKey());
                    }
                } else {
                    long timerCount = (Long)containerInfo;
                    if (timerCount == 1L) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        Long newCount = timerCount - 1L;
                        this.containerTimers_.put(containerId, newCount);
                    }
                }
            }
        }

        public synchronized RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
            return this.timers_.get(timerId);
        }

        public synchronized RuntimeTimerState getNonPersistentTimerState(TimerPrimaryKey timerId) {
            return this.nonpersistentTimers_.get(timerId);
        }

        public synchronized boolean entityBeanHasTimers(long containerId, Object pkey) {
            Object containerInfo = this.containerTimers_.get(containerId);
            return containerInfo != null ? ((Collection)containerInfo).contains(pkey) : false;
        }

        public synchronized boolean containerHasTimers(long containerId) {
            return this.containerTimers_.containsKey(containerId);
        }

        public synchronized void validate() {
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentTimerIdsForContainer(long containerId_) {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (Map.Entry<TimerPrimaryKey, RuntimeTimerState> entry : this.nonpersistentTimers_.entrySet()) {
                TimerPrimaryKey key = entry.getKey();
                RuntimeTimerState rt = entry.getValue();
                if (rt.getContainerId() != containerId_) continue;
                result.add(key);
            }
            return result;
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsForContainer(long containerId_) {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (Map.Entry<TimerPrimaryKey, RuntimeTimerState> entry : this.nonpersistentTimers_.entrySet()) {
                TimerPrimaryKey key = entry.getKey();
                RuntimeTimerState rt = entry.getValue();
                if (rt.getContainerId() != containerId_ || !rt.isActive()) continue;
                result.add(key);
            }
            return result;
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsByThisServer() {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (Map.Entry<TimerPrimaryKey, RuntimeTimerState> entry : this.nonpersistentTimers_.entrySet()) {
                TimerPrimaryKey key = entry.getKey();
                RuntimeTimerState rt = entry.getValue();
                if (!rt.isActive()) continue;
                result.add(key);
            }
            return result;
        }
    }
}

