/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs;

import fish.payara.microprofile.telemetry.tracing.WithSpanMethodInterceptor;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.container.ResourceInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

final class OpenTracingCdiUtils {
    private static final Logger LOG = Logger.getLogger(OpenTracingCdiUtils.class.getName());

    OpenTracingCdiUtils() {
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationClass, ResourceInfo resourceInfo) {
        return WithSpanMethodInterceptor.getAnnotation(beanManager, annotationClass, resourceInfo.getResourceClass(), resourceInfo.getResourceMethod());
    }

    public static <A extends Annotation, T> Optional<T> getConfigOverrideValue(Class<A> annotationClass, String parameterName, InvocationContext invocationContext, Class<T> parameterType) {
        return OpenTracingCdiUtils.getConfigOverrideValue(annotationClass, parameterName, invocationContext.getMethod(), parameterType);
    }

    public static <A extends Annotation, T> Optional<T> getConfigOverrideValue(Class<A> annotationClass, String parameterName, Method method, Class<T> parameterType) {
        Config config = OpenTracingCdiUtils.getConfig();
        if (config == null) {
            LOG.log(Level.FINE, "No config to get override parameters from.");
            return Optional.empty();
        }
        String annotationName = annotationClass.getSimpleName();
        String annotatedMethodName = method.getName();
        String annotatedClassCanonicalName = method.getDeclaringClass().getCanonicalName();
        LOG.log(Level.FINER, "Getting config override for annotated method...");
        Optional methodValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotatedMethodName + "/" + annotationName + "/" + parameterName, parameterType);
        if (methodValue.isPresent()) {
            return methodValue;
        }
        LOG.log(Level.FINER, "No config override for annotated method, checking if the method is annotated directly...");
        if (method.getAnnotation(annotationClass) != null) {
            LOG.log(Level.FINER, "Using method annotation.");
            return methodValue;
        }
        LOG.log(Level.FINER, "No config override or annotated method, getting config override for the annotated class...");
        Optional classValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotationName + "/" + parameterName, parameterType);
        if (classValue.isPresent()) {
            return classValue;
        }
        LOG.log(Level.FINER, "No config override for the annotated class, getting application wide config override...");
        Optional appValue = config.getOptionalValue(annotationName + "/" + parameterName, parameterType);
        if (!appValue.isPresent()) {
            LOG.log(Level.FINER, "No config overrides");
        }
        return appValue;
    }

    public static <A extends Annotation, T> Optional<T> getConfigOverrideValue(Class<A> annotationClass, String parameterName, ResourceInfo resourceInfo, Class<T> parameterType) {
        Config config = OpenTracingCdiUtils.getConfig();
        if (config == null) {
            LOG.log(Level.FINE, "No config to get override parameters from.");
            return Optional.empty();
        }
        LOG.log(Level.FINER, "Getting config override for annotated method...");
        String annotationName = annotationClass.getSimpleName();
        String annotatedMethodName = resourceInfo.getResourceMethod().getName();
        String annotatedClassCanonicalName = resourceInfo.getResourceClass().getCanonicalName();
        Optional methodValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotatedMethodName + "/" + annotationName + "/" + parameterName, parameterType);
        if (methodValue.isPresent()) {
            return methodValue;
        }
        LOG.log(Level.FINEST, "No config override for annotated method, checking if the method is annotated directly...");
        if (resourceInfo.getResourceMethod().getAnnotation(annotationClass) != null) {
            LOG.log(Level.FINER, "Using method annotation.");
            return methodValue;
        }
        LOG.log(Level.FINER, "No config override or annotated method, getting config override for the annotated class...");
        Optional classValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotationName + "/" + parameterName, parameterType);
        if (classValue.isPresent()) {
            return classValue;
        }
        LOG.log(Level.FINER, "No config override for the annotated class, getting application wide config override...");
        Optional appValue = config.getOptionalValue(annotationName + "/" + parameterName, parameterType);
        if (!appValue.isPresent()) {
            LOG.log(Level.FINER, "No config overrides");
        }
        return appValue;
    }

    private static Config getConfig() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.INFO, "No config could be found", ex);
            return null;
        }
    }
}

