/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs;

import fish.payara.microprofile.telemetry.tracing.PayaraTracingServices;
import fish.payara.microprofile.telemetry.tracing.jaxrs.OpenTracingCdiUtils;
import fish.payara.microprofile.telemetry.tracing.jaxrs.ResourceCache;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.opentracing.Traced;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.uri.UriTemplate;

final class OpenTracingHelper {
    private static final Logger LOG = Logger.getLogger(OpenTracingHelper.class.getName());
    public static final String SPAN_CONVENTION_MP_KEY = "payara.telemetry.span-convention";
    private static final Traced NULL_TRACED = new Traced(){

        public boolean value() {
            return false;
        }

        public String operationName() {
            return null;
        }

        public Class<? extends Annotation> annotationType() {
            return Traced.class;
        }
    };
    private static final WithSpan NULL_WITHSPAN = new WithSpan(){

        public SpanKind kind() {
            return null;
        }

        public String value() {
            return null;
        }

        public Class<? extends Annotation> annotationType() {
            return WithSpan.class;
        }
    };
    private final Config mpConfig;
    private SpanStrategy spanStrategy;
    private ResourceCache<String> routeCache = new ResourceCache();
    private ResourceCache<String> operationNameCache = new ResourceCache();
    private ResourceCache<Traced> tracedCache = new ResourceCache();
    private ResourceCache<WithSpan> withSpanCache = new ResourceCache();
    private static ResourceCache<Boolean> canTraceCache = new ResourceCache();

    public OpenTracingHelper() {
        this.mpConfig = PayaraTracingServices.getConfig();
    }

    public String determineOperationName(ResourceInfo resourceInfo, ContainerRequestContext request) {
        return this.operationNameCache.get(resourceInfo, () -> this.computeOperationName(resourceInfo, request));
    }

    public String computeOperationName(ResourceInfo resourceInfo, ContainerRequestContext request) {
        Traced tracedAnnotation = this.getTracedAnnotation(resourceInfo);
        if (tracedAnnotation != null) {
            Object operationName = OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "operationName", resourceInfo, String.class).orElse(tracedAnnotation.operationName());
            if (((String)operationName).equals("")) {
                operationName = request.getMethod() + ":" + resourceInfo.getResourceClass().getCanonicalName() + "." + resourceInfo.getResourceMethod().getName();
            }
            return operationName;
        }
        WithSpan withSpanAnnotation = this.getWithSpanAnnotation(resourceInfo);
        if (withSpanAnnotation != null && !"".equals(withSpanAnnotation.value())) {
            return withSpanAnnotation.value();
        }
        SpanStrategy naming = this.determineSpanStrategy();
        return naming.determineSpanName(request, resourceInfo);
    }

    private SpanStrategy determineSpanStrategy() {
        if (this.spanStrategy == null) {
            this.spanStrategy = this.computeSpanStrategy();
        }
        return this.spanStrategy;
    }

    private SpanStrategy computeSpanStrategy() {
        Optional operationNameProviderOptional = this.mpConfig.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        if (Optional.of("http-path").equals(operationNameProviderOptional)) {
            return SpanStrategy.OPENTRACING_PATH;
        }
        if (Optional.of("class-method").equals(operationNameProviderOptional)) {
            return SpanStrategy.OPENTRACING_CLASS_METHOD;
        }
        Optional vendorCompatibilitySetting = this.mpConfig.getOptionalValue(SPAN_CONVENTION_MP_KEY, String.class);
        if (vendorCompatibilitySetting.isPresent()) {
            switch (((String)vendorCompatibilitySetting.get()).toLowerCase()) {
                case "opentracing-http-path": {
                    return SpanStrategy.OPENTRACING_PATH;
                }
                case "opentracing-class-method": {
                    return SpanStrategy.OPENTRACING_CLASS_METHOD;
                }
                case "opentelemetry": {
                    return SpanStrategy.OTEL_SEM_CONV;
                }
                case "microprofile-telemetry": 
                case "opentelemetry-1.13": {
                    return SpanStrategy.OTEL_MP_TCK;
                }
            }
            LOG.fine(() -> "Unsupported value of payara.telemetry.span-convention: " + (String)vendorCompatibilitySetting.get());
        }
        return SpanStrategy.OTEL_SEM_CONV;
    }

    public void augmentSpan(SpanBuilder spanBuilder) {
        this.determineSpanStrategy().augmentSpan(spanBuilder);
    }

    public String getHttpRoute(ContainerRequest request, ResourceInfo resourceInfo) {
        return this.routeCache.get(resourceInfo, () -> SpanStrategy.OTEL_MP_TCK.determineSpanName((ContainerRequestContext)request, resourceInfo));
    }

    private Traced getTracedAnnotation(ResourceInfo resourceInfo) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager == null) {
            return null;
        }
        Traced cached = this.tracedCache.get(resourceInfo, () -> this.computeTracedAnnotation(resourceInfo, beanManager));
        return cached == NULL_TRACED ? null : cached;
    }

    public WithSpan getWithSpanAnnotation(ResourceInfo resourceInfo) {
        BeanManager bm = this.getBeanManager();
        if (bm == null) {
            return null;
        }
        WithSpan cached = this.withSpanCache.get(resourceInfo, () -> this.computeWithSpanAnnotation(resourceInfo, bm));
        return cached == NULL_WITHSPAN ? null : cached;
    }

    private WithSpan computeWithSpanAnnotation(ResourceInfo resourceInfo, BeanManager bm) {
        WithSpan result = OpenTracingCdiUtils.getAnnotation(bm, WithSpan.class, resourceInfo);
        return result == null ? NULL_WITHSPAN : result;
    }

    private Traced computeTracedAnnotation(ResourceInfo resourceInfo, BeanManager beanManager) {
        Traced result = OpenTracingCdiUtils.getAnnotation(beanManager, Traced.class, resourceInfo);
        return result == null ? NULL_TRACED : result;
    }

    public boolean canTrace(ResourceInfo resourceInfo, ContainerRequest request) {
        if (request == null || resourceInfo.getResourceClass() == null || resourceInfo.getResourceMethod() == null) {
            return false;
        }
        return canTraceCache.get(resourceInfo, () -> this.computeCanTrace(resourceInfo, request, this.getTracedAnnotation(resourceInfo)));
    }

    private boolean computeCanTrace(ResourceInfo resourceInfo, ContainerRequest request, Traced tracedAnnotation) {
        String uriPath = "/" + request.getUriInfo().getPath();
        String baseUriPath = request.getUriInfo().getBaseUri().getPath();
        if (uriPath.equals("/health") || uriPath.equals("/metrics") || uriPath.contains("/metrics/base") || uriPath.contains("/metrics/vendor") || uriPath.contains("/metrics/application") || baseUriPath.equals("/openapi/")) {
            return false;
        }
        Optional skipPatternOptional = this.mpConfig.getOptionalValue("mp.opentracing.server.skip-pattern", String.class);
        if (skipPatternOptional.isPresent()) {
            String[] splitSkipPatterns;
            String skipPatterns = (String)skipPatternOptional.get();
            for (String skipPattern : splitSkipPatterns = skipPatterns.split("\\|")) {
                if (!uriPath.matches(skipPattern)) continue;
                return false;
            }
        }
        return tracedAnnotation == null || this.getTracingFromConfig(resourceInfo).orElse(tracedAnnotation.value()) != false;
    }

    private BeanManager getBeanManager() {
        try {
            return CDI.current().getBeanManager();
        }
        catch (IllegalStateException ise) {
            LOG.log(Level.FINE, "Error getting Bean Manager, presumably due to this application not using CDI", ise);
            return null;
        }
    }

    private Optional<Boolean> getTracingFromConfig(ResourceInfo resourceInfo) {
        return OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "value", resourceInfo, Boolean.class);
    }

    static enum SpanStrategy {
        OTEL_SEM_CONV{

            @Override
            String determineSpanName(ContainerRequestContext request, ResourceInfo resourceInfo) {
                UriInfo uriInfo = request.getUriInfo();
                StringBuilder result = new StringBuilder();
                result.append(request.getMethod()).append(" ").append(uriInfo.getBaseUri().getPath());
                SpanStrategy.trimTrailingSlash(result);
                SpanStrategy.appendTemplate(resourceInfo, uriInfo, result);
                return result.toString();
            }
        }
        ,
        OTEL_MP_TCK{

            @Override
            String determineSpanName(ContainerRequestContext request, ResourceInfo resourceInfo) {
                UriInfo uriInfo = request.getUriInfo();
                StringBuilder result = new StringBuilder();
                result.append(uriInfo.getBaseUri().getPath());
                SpanStrategy.trimTrailingSlash(result);
                SpanStrategy.appendTemplate(resourceInfo, uriInfo, result);
                return result.toString();
            }
        }
        ,
        OPENTRACING_CLASS_METHOD{

            @Override
            String determineSpanName(ContainerRequestContext request, ResourceInfo resourceInfo) {
                return request.getMethod() + ":" + resourceInfo.getResourceClass().getCanonicalName() + "." + resourceInfo.getResourceMethod().getName();
            }
        }
        ,
        OPENTRACING_PATH{

            @Override
            String determineSpanName(ContainerRequestContext request, ResourceInfo resourceInfo) {
                Path classLevelAnnotation = resourceInfo.getResourceClass().getAnnotation(Path.class);
                Path methodLevelAnnotation = resourceInfo.getResourceMethod().getAnnotation(Path.class);
                if (classLevelAnnotation != null) {
                    String operationName = request.getMethod() + ":";
                    operationName = classLevelAnnotation.value().startsWith("/") ? operationName + classLevelAnnotation.value() : operationName + "/" + classLevelAnnotation.value();
                    if (methodLevelAnnotation != null) {
                        operationName = methodLevelAnnotation.value().startsWith("/") ? operationName + methodLevelAnnotation.value() : operationName + "/" + methodLevelAnnotation.value();
                    }
                    return operationName;
                }
                return OPENTRACING_CLASS_METHOD.determineSpanName(request, resourceInfo);
            }
        };


        private static void trimTrailingSlash(StringBuilder result) {
            if (result.length() > 1 && result.charAt(result.length() - 1) == '/') {
                result.setLength(result.length() - 1);
            }
        }

        private static void appendTemplate(ResourceInfo resourceInfo, UriInfo uriInfo, StringBuilder result) {
            if (uriInfo.getMatchedResources().size() == 1) {
                Path classRoute = resourceInfo.getResourceClass().getAnnotation(Path.class);
                Path methodRoute = resourceInfo.getResourceMethod().getAnnotation(Path.class);
                if (classRoute != null && !"/".equals(classRoute.value())) {
                    result.append(classRoute.value());
                }
                if (methodRoute != null && !"/".equals(methodRoute.value())) {
                    result.append(methodRoute.value());
                }
            } else if (uriInfo instanceof ExtendedUriInfo) {
                List templates = ((ExtendedUriInfo)uriInfo).getMatchedTemplates();
                for (int i = templates.size() - 1; i >= 0; --i) {
                    String template = ((UriTemplate)templates.get(i)).getTemplate();
                    if ("/".equals(template)) continue;
                    result.append(template);
                }
            } else {
                result.append("*");
            }
        }

        abstract String determineSpanName(ContainerRequestContext var1, ResourceInfo var2);

        void augmentSpan(SpanBuilder spanBuilder) {
            if (this == OPENTRACING_CLASS_METHOD || this == OPENTRACING_PATH) {
                spanBuilder.setAttribute("span.kind", "server");
            }
        }
    }
}

