/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs.client;

import fish.payara.opentracing.PropagationHelper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;

public class AsyncContextPropagator
implements AsyncInvocationInterceptor {
    private PropagationHelper helper;
    private Scope scope;

    public void prepareContext() {
        this.helper = PropagationHelper.startMultiThreaded((Span)Span.current(), (Context)Context.current());
    }

    public void applyContext() {
        this.scope = this.helper.localScope();
    }

    public void removeContext() {
        if (this.scope != null) {
            this.scope.close();
        }
        if (this.helper != null) {
            this.helper.close();
        }
    }

    static class Factory
    implements AsyncInvocationInterceptorFactory {
        Factory() {
        }

        public AsyncInvocationInterceptor newInterceptor() {
            return new AsyncContextPropagator();
        }
    }
}

