/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.deployment.util;

import fish.payara.deployment.util.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.config.support.TranslatedConfigView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class GAVConvertor {
    private static final Logger logger = Logger.getLogger("PayaraMicro");
    private static final String defaultMavenRepository = "https://repo.maven.apache.org/maven2/";

    private GAVConvertor() {
        throw new AssertionError();
    }

    public static Map.Entry<String, URI> getArtefactMapEntry(String GAV, Collection<String> repositoryURIs) throws URISyntaxException {
        Map<String, String> GAVMap = GAVConvertor.splitGAV(GAV);
        LinkedHashSet<String> repoURIs = new LinkedHashSet<String>();
        if (repositoryURIs != null) {
            for (String uri : repositoryURIs) {
                Object convertedURI = TranslatedConfigView.expandValue((String)uri);
                if (!((String)convertedURI).endsWith("/")) {
                    convertedURI = (String)convertedURI + "/";
                }
                repoURIs.add((String)convertedURI);
            }
        }
        repoURIs.add(defaultMavenRepository);
        String relativeURIString = GAVConvertor.constructRelativeURIString(GAVMap, repoURIs);
        URI artefactURI = GAVConvertor.findArtefactURI(repoURIs, relativeURIString);
        return new AbstractMap.SimpleImmutableEntry<String, URI>(GAVMap.get("artefactId"), artefactURI);
    }

    private static Map<String, String> splitGAV(String GAV) throws URISyntaxException {
        String[] splitGAV = GAV.split("[,:]");
        HashMap<String, String> GAVMap = new HashMap<String, String>();
        try {
            GAVMap.put("groupId", splitGAV[0].replace('.', '/'));
            GAVMap.put("artefactId", splitGAV[1]);
            GAVMap.put("versionNumber", splitGAV[2]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.log(Level.WARNING, "Error converting String \"{0}\" to GAV, make sure it takes the form of groupId,artifactId,version", GAV);
            throw new URISyntaxException("\nGAV does not appear to be in the correct format", ex.toString());
        }
        return GAVMap;
    }

    private static String constructRelativeURIString(Map<String, String> GAVMap, Collection<String> repositoryURIs) {
        String relativeURI = String.format("%s/%s/%s", GAVMap.get("groupId"), GAVMap.get("artefactId"), GAVMap.get("versionNumber"));
        Object artefactFileName = String.format("%s-%s", GAVMap.get("artefactId"), GAVMap.get("versionNumber"));
        if (!relativeURI.endsWith("SNAPSHOT")) {
            return relativeURI + "/" + (String)artefactFileName;
        }
        for (String repoURI : repositoryURIs) {
            URI mavenMetaDataURI = null;
            try {
                mavenMetaDataURI = new URI(repoURI + relativeURI + "/maven-metadata.xml");
                if (!URIUtils.exists(mavenMetaDataURI)) continue;
                File mavenMetaData = URIUtils.convertToFile(mavenMetaDataURI);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(mavenMetaData);
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("snapshotVersion");
                Node node = nodeList.item(0);
                Element element = (Element)node;
                String version = element.getElementsByTagName("value").item(0).getTextContent();
                artefactFileName = GAVMap.get("artefactId") + "-" + version;
                logger.log(Level.FINE, "Found version {0} from maven-metadata.xml", version);
                break;
            }
            catch (URISyntaxException e) {
                logger.log(Level.WARNING, "Error creating maven metadata URI");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error getting HTTP connection response code");
            }
            catch (ParserConfigurationException e) {
                logger.log(Level.WARNING, "Error creating Document Builder");
            }
            catch (SAXException e) {
                logger.log(Level.WARNING, "Error parsing maven-metadata.xml");
            }
        }
        logger.log(Level.FINE, "Relative URI String is: {0}", relativeURI + "/" + (String)artefactFileName);
        return relativeURI + "/" + (String)artefactFileName;
    }

    private static URI findArtefactURI(Collection<String> repositoryURIs, String relativeURIString) throws URISyntaxException {
        String[] archiveTypes = new String[]{".jar", ".war", ".ear", ".rar"};
        for (String repositoryURI : repositoryURIs) {
            URI artefactURI = null;
            for (String archiveType : archiveTypes) {
                try {
                    artefactURI = new URI(repositoryURI + relativeURIString + archiveType);
                    if (URIUtils.exists(artefactURI)) {
                        return artefactURI;
                    }
                    logger.log(Level.FINE, "Artefact not found at URI: {0}", artefactURI.toString());
                }
                catch (URISyntaxException ex) {
                    Object[] errorParameters = new String[]{repositoryURI, relativeURIString, archiveType};
                    logger.log(Level.WARNING, "Error creating URI from repository URI, {0}, relative URI, {1}, and archive type, {2}", errorParameters);
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.WARNING, "Error creating URL from artefact URI, {0}", artefactURI.toString());
                }
                catch (ProtocolException ex) {
                    logger.log(Level.WARNING, "Error setting request method to \"HEAD\"");
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Error getting HTTP connection response code");
                }
            }
        }
        throw new URISyntaxException(relativeURIString, "No artefact can be found for relative URI");
    }
}

