/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.interfaces.MailResourceIntf;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.repository.ResourceProperty;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailConfiguration
implements Serializable {
    private static final String PROP_NAME_PREFIX_LEGACY = "mail-";
    private static final char PROP_NAME_DELIM_LEGACY = '-';
    private static final String MAIL_STORE_PROTOCOL = "mail.store.protocol";
    private static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String MAIL_HOST = "mail.host";
    private static final String MAIL_USER = "mail.user";
    private static final String MAIL_PASSWORD = "mail.password";
    private static final String MAIL_FROM = "mail.from";
    private static final String MAIL_DEBUG = "mail.debug";
    private static final String MAIL_PREFIX = "mail.";
    private static final String MAIL_SUFFIX_CLASS = ".class";
    private static final String MAIL_SUFFIX_HOST = ".host";
    private static final String MAIL_SUFFIX_USER = ".user";
    private static final String MAIL_SUFFIX_PASSWORD = ".password";
    private static final String MAIL_SUFFIX_AUTH = ".auth";
    private static final char MAIL_DELIM = '.';
    private String description = "";
    private String jndiName = "";
    private boolean enabled = false;
    private String storeProtocol = null;
    private String storeProtocolClass = null;
    private String transportProtocol = null;
    private String transportProtocolClass = null;
    private String mailHost = null;
    private String username = null;
    private String password = null;
    private boolean auth = false;
    private String mailFrom = null;
    private boolean debug = false;
    private Properties mailProperties = new Properties();
    static Logger _logger = DOLUtils.getDefaultLogger();

    public MailConfiguration(String username, String mailFrom, String mailHost) {
        this.username = username;
        this.mailFrom = mailFrom;
        this.mailHost = mailHost;
        this.put(MAIL_FROM, mailFrom);
        this.put(MAIL_USER, username);
        this.put(MAIL_HOST, mailHost);
    }

    public MailConfiguration(MailResourceIntf mailRes) {
        try {
            this.loadMailResources(mailRes);
        }
        catch (Exception ce) {
            _logger.log(Level.INFO, "enterprise.deployment_mail_cfgexcp", ce);
        }
    }

    private void loadMailResources(MailResourceIntf mailResource) throws Exception {
        if (mailResource == null) {
            _logger.log(Level.FINE, "MailConfiguration: no MailResource object. mailResource=null");
            return;
        }
        this.jndiName = mailResource.getName();
        this.description = mailResource.getDescription();
        this.enabled = mailResource.isEnabled();
        this.storeProtocol = mailResource.getStoreProtocol();
        this.storeProtocolClass = mailResource.getStoreProtocolClass();
        this.transportProtocol = mailResource.getTransportProtocol();
        this.transportProtocolClass = mailResource.getTransportProtocolClass();
        this.mailHost = mailResource.getMailHost();
        this.username = mailResource.getUsername();
        this.password = mailResource.getPassword();
        this.auth = mailResource.getAuth();
        this.mailFrom = mailResource.getMailFrom();
        this.debug = mailResource.isDebug();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("storeProtocol " + this.storeProtocol);
            _logger.fine("storeProtocolClass " + this.storeProtocolClass);
            _logger.fine("transportProtocol " + this.transportProtocol);
            _logger.fine("transportProtocolClass " + this.transportProtocolClass);
            _logger.fine("mailHost " + this.mailHost);
            _logger.fine("username " + this.username);
            _logger.fine("password has been set.");
            _logger.fine("auth" + this.auth);
            _logger.fine("mailFrom " + this.mailFrom);
            _logger.fine("debug " + this.debug);
        }
        if (this.transportProtocol == null) {
            this.transportProtocol = "smtp";
        }
        this.put(MAIL_HOST, this.mailHost);
        this.put(MAIL_USER, this.username);
        this.put(MAIL_PASSWORD, this.password);
        this.put(MAIL_STORE_PROTOCOL, this.storeProtocol);
        this.put(MAIL_TRANSPORT_PROTOCOL, this.transportProtocol);
        if (this.storeProtocol != null) {
            this.put(MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_CLASS, this.storeProtocolClass);
        }
        if (this.transportProtocol != null) {
            this.put(MAIL_PREFIX + this.transportProtocol + MAIL_SUFFIX_CLASS, this.transportProtocolClass);
            this.put(MAIL_PREFIX + this.transportProtocol + MAIL_SUFFIX_AUTH, Boolean.toString(this.auth));
        }
        this.put(MAIL_FROM, this.mailFrom);
        this.put(MAIL_DEBUG, this.debug ? "true" : "false");
        Set properties = mailResource.getProperties();
        for (ResourceProperty property : properties) {
            String name = property.getName();
            String value = (String)property.getValue();
            if (name.startsWith(PROP_NAME_PREFIX_LEGACY)) {
                name = name.replace('-', '.');
            }
            this.put(name, value);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("mail property: " + name + " = " + value);
        }
    }

    private void put(String name, String value) {
        if (value != null && value.length() > 0) {
            this.mailProperties.put(name, value);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getAuth() {
        return this.auth;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public String getMailStoreProtocol() {
        return this.storeProtocol;
    }

    public String getMailTransportProtocol() {
        return this.transportProtocol;
    }

    public String getMailStoreProtocolClass() {
        return this.storeProtocolClass;
    }

    public String getMailTransportProtocolClass() {
        return this.transportProtocolClass;
    }

    public boolean getMailDebug() {
        return this.debug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public void print(StringBuilder toStringBuilder) {
        toStringBuilder.append("MailConfiguration: [");
        toStringBuilder.append("description=").append(this.description);
        toStringBuilder.append(", jndiName=").append(this.jndiName);
        toStringBuilder.append(", enabled=").append(this.enabled);
        toStringBuilder.append(", storeProtocol=").append(this.storeProtocol);
        toStringBuilder.append(", transportProtocol=").append(this.transportProtocol);
        toStringBuilder.append(", storeProtocolClass=").append(this.storeProtocolClass);
        toStringBuilder.append(", transportProtocolClass=").append(this.transportProtocolClass);
        toStringBuilder.append(", mailHost=").append(this.mailHost);
        toStringBuilder.append(", username=").append(this.username);
        toStringBuilder.append(", mailFrom=").append(this.mailFrom);
        toStringBuilder.append(", debug=").append(this.debug);
        toStringBuilder.append(", mailProperties: [");
        Enumeration<?> e = this.mailProperties.propertyNames();
        boolean isFirst = true;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.mailProperties.getProperty(name);
            if (!isFirst) {
                toStringBuilder.append(", ");
            }
            toStringBuilder.append(name).append("=").append(value);
            isFirst = false;
        }
        toStringBuilder.append("]]");
    }
}

