/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpUpgradeHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.WebConnectionImpl;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;
import org.glassfish.web.valve.GlassFishValveAdapter;
import org.glassfish.web.valve.TomcatValveAdapter;

public class StandardPipeline
implements Pipeline,
Contained,
Lifecycle {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    protected GlassFishValve basic;
    protected Container container;
    protected static final String info = "org.apache.catalina.core.StandardPipeline/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected boolean started;
    protected GlassFishValve[] valves = new GlassFishValve[0];
    private Valve firstTcValve;
    private Valve lastTcValve;

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    public String getInfo() {
        return info;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00232"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        for (GlassFishValve valve : this.valves) {
            if (!(valve instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)valve)).start();
        }
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00233"));
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).stop();
        }
        for (GlassFishValve valve : this.valves) {
            if (!(valve instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)valve)).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    @Override
    public GlassFishValve getBasic() {
        return this.basic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBasic(GlassFishValve valve) {
        GlassFishValve oldBasic = null;
        StandardPipeline standardPipeline = this;
        synchronized (standardPipeline) {
            oldBasic = this.basic;
        }
        if (oldBasic == valve) {
            return;
        }
        if (oldBasic != null) {
            standardPipeline = this;
            synchronized (standardPipeline) {
                if (this.started && oldBasic instanceof Lifecycle) {
                    try {
                        ((Lifecycle)((Object)oldBasic)).stop();
                    }
                    catch (LifecycleException e) {
                        log.log(Level.SEVERE, "AS-WEB-CORE-00234", e);
                    }
                }
            }
            if (oldBasic instanceof Contained) {
                try {
                    ((Contained)((Object)oldBasic)).setContainer(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00235", e);
                return;
            }
        }
        standardPipeline = this;
        synchronized (standardPipeline) {
            this.basic = valve;
        }
    }

    @Override
    public void addValve(GlassFishValve valve) {
        if (this.firstTcValve != null) {
            this.addValve(new TomcatValveAdapter(valve));
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00236", e);
            }
        }
        GlassFishValve[] results = new GlassFishValve[this.valves.length + 1];
        System.arraycopy(this.valves, 0, results, 0, this.valves.length);
        results[this.valves.length] = valve;
        this.valves = results;
    }

    @Override
    public synchronized void addValve(Valve valve) {
        if (this.isGlassFishValve(valve)) {
            try {
                this.addValve(new GlassFishValveAdapter(valve));
            }
            catch (Exception e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00237"), valve);
                log.log(Level.SEVERE, msg, e);
            }
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00236", e);
            }
        }
        if (this.firstTcValve == null) {
            this.firstTcValve = this.lastTcValve = valve;
        } else {
            this.lastTcValve.setNext(valve);
            this.lastTcValve = valve;
        }
        if (this.basic != null) {
            valve.setNext((Valve)((Object)this.basic));
        }
    }

    @Override
    public GlassFishValve[] getValves() {
        if (this.basic == null) {
            return this.valves;
        }
        GlassFishValve[] results = new GlassFishValve[this.valves.length + 1];
        System.arraycopy(this.valves, 0, results, 0, this.valves.length);
        results[this.valves.length] = this.basic;
        return results;
    }

    @Override
    public boolean hasNonBasicValves() {
        return this.valves != null && this.valves.length > 0 || this.firstTcValve != null;
    }

    public ObjectName[] getValveObjectNames() {
        ObjectName[] oname = new ObjectName[this.valves.length + 1];
        for (int i = 0; i < this.valves.length; ++i) {
            if (!(this.valves[i] instanceof ValveBase)) continue;
            oname[i] = ((ValveBase)this.valves[i]).getObjectName();
        }
        if (this.basic instanceof ValveBase) {
            oname[this.valves.length] = ((ValveBase)this.basic).getObjectName();
        }
        return oname;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.doInvoke(request, response, false);
    }

    public void doChainInvoke(Request request, Response response) throws IOException, ServletException {
        this.doInvoke(request, response, true);
    }

    @Override
    public void removeValve(GlassFishValve valve) {
        int j = -1;
        for (int i = 0; i < this.valves.length; ++i) {
            if (valve != this.valves[i]) continue;
            j = i;
            break;
        }
        if (j < 0) {
            return;
        }
        GlassFishValve[] results = new GlassFishValve[this.valves.length - 1];
        int n = 0;
        for (int i = 0; i < this.valves.length; ++i) {
            if (i == j) continue;
            results[n++] = this.valves[i];
        }
        this.valves = results;
        try {
            if (valve instanceof Contained) {
                ((Contained)((Object)valve)).setContainer(null);
            }
        }
        catch (Throwable i) {
            // empty catch block
        }
        if (this.started) {
            if (valve instanceof ValveBase) {
                if (((ValveBase)valve).isStarted()) {
                    try {
                        ((Lifecycle)((Object)valve)).stop();
                    }
                    catch (LifecycleException e) {
                        log.log(Level.SEVERE, "AS-WEB-CORE-00240", e);
                    }
                }
            } else if (valve instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00240", e);
                }
            }
        }
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00241"), this.container.getName(), message);
            if (logger != null) {
                logger.log(msg);
            } else {
                log.log(Level.INFO, msg);
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, MessageFormat.format(rb.getString("AS-WEB-CORE-00242"), message));
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00241"), this.container.getName(), message);
            if (logger != null) {
                logger.log(msg, t, 2);
            } else {
                log.log(Level.WARNING, msg, t);
            }
        } else {
            log.log(Level.WARNING, MessageFormat.format(rb.getString("AS-WEB-CORE-00242"), message), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke(Request request, Response response, boolean chaining) throws IOException, ServletException {
        org.apache.catalina.connector.Request req;
        GlassFishValve[] savedValves;
        if (this.valves.length > 0 || this.basic != null) {
            int status = 1;
            for (int i = 0; i < this.valves.length; ++i) {
                Request req2 = request;
                Response resp = response;
                if (chaining) {
                    req2 = this.getWrappedRequest(request);
                    resp = this.getWrappedResponse(request, response);
                }
                if ((status = this.valves[i].invoke(req2, resp)) != 1) break;
            }
            savedValves = this.valves;
            if (status == 1) {
                if (this.firstTcValve != null) {
                    this.firstTcValve.invoke((org.apache.catalina.connector.Request)request, (org.apache.catalina.connector.Response)response);
                } else if (this.basic != null) {
                    Request req3 = request;
                    Response resp = response;
                    if (chaining) {
                        req3 = this.getWrappedRequest(request);
                        resp = this.getWrappedResponse(request, response);
                    }
                    this.basic.invoke(req3, resp);
                    this.postInvoke(this.basic, req3, resp);
                }
            }
            for (int j = i - 1; j >= 0; --j) {
                Request req4 = request;
                Response resp = response;
                if (chaining) {
                    req4 = this.getWrappedRequest(request);
                    resp = this.getWrappedResponse(request, response);
                }
                this.postInvoke(savedValves[j], req4, resp);
            }
        } else {
            throw new ServletException(rb.getString("AS-WEB-CORE-00238"));
        }
        savedValves = null;
        if (request instanceof org.apache.catalina.connector.Request && (req = (org.apache.catalina.connector.Request)request).isUpgrade()) {
            HttpUpgradeHandler handler = req.getHttpUpgradeHandler();
            if (handler != null) {
                WebConnectionImpl wc = new WebConnectionImpl(req.getInputStream(), ((org.apache.catalina.connector.Response)req.getResponse()).getOutputStream());
                wc.setRequest(req);
                req.setWebConnection(wc);
                if (response instanceof org.apache.catalina.connector.Response) {
                    wc.setResponse((org.apache.catalina.connector.Response)response);
                }
                Context context = req.getContext();
                try {
                    context.fireContainerEvent("beforeUpgradeHandlerInitialized", handler);
                    req.initialiseHttpUpgradeHandler(wc);
                }
                finally {
                    context.fireContainerEvent("afterUpgradeHandlerInitialized", handler);
                }
            } else {
                log.log(Level.SEVERE, "AS-WEB-CORE-00239");
            }
        }
    }

    private void postInvoke(final GlassFishValve savedValve, final Request request, final Response response) throws IOException, ServletException {
        if (request.getRequest().isAsyncSupported() && request.getRequest().isAsyncStarted()) {
            request.getRequest().getAsyncContext().addListener(new AsyncListener(){

                @Override
                public void onComplete(AsyncEvent event) throws IOException {
                    try {
                        savedValve.postInvoke(request, response);
                    }
                    catch (ServletException ex) {
                        log.log(Level.SEVERE, "AS-WEB-CORE-00493", ex);
                    }
                }

                @Override
                public void onTimeout(AsyncEvent event) throws IOException {
                    try {
                        savedValve.postInvoke(request, response);
                    }
                    catch (ServletException ex) {
                        log.log(Level.SEVERE, "AS-WEB-CORE-00493", ex);
                    }
                }

                @Override
                public void onError(AsyncEvent event) throws IOException {
                    try {
                        savedValve.postInvoke(request, response);
                    }
                    catch (ServletException ex) {
                        log.log(Level.SEVERE, "AS-WEB-CORE-00493", ex);
                    }
                }

                @Override
                public void onStartAsync(AsyncEvent event) throws IOException {
                }
            });
        } else {
            savedValve.postInvoke(request, response);
        }
    }

    private boolean isGlassFishValve(Valve valve) {
        try {
            Method m = valve.getClass().getMethod("invoke", Request.class, Response.class);
            return m != null && Integer.TYPE.equals(m.getReturnType()) && !Modifier.isAbstract(m.getModifiers());
        }
        catch (Exception e) {
            return false;
        }
    }

    private Request getWrappedRequest(Request request) {
        Request wrappedRequest = (Request)request.getNote("__jakarta.security.auth.message.request");
        if (wrappedRequest == null) {
            wrappedRequest = request;
        }
        return wrappedRequest;
    }

    private Response getWrappedResponse(Request request, Response response) {
        Response wrappedResponse = (Response)request.getNote("__jakarta.security.auth.message.response");
        if (wrappedResponse == null) {
            wrappedResponse = response;
        }
        return wrappedResponse;
    }
}

